/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.interop;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.runtime.interop.InteropArray;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.LinkedHashMap;
import java.util.Map;

@ExportLibrary(value=InteropLibrary.class)
public final class PythonLocalScope
implements TruffleObject {
    final Map<String, Integer> slots;
    final RootNode root;
    final Frame frame;
    final SourceSection sourceSection;

    PythonLocalScope(Map<String, Integer> slotsMap, RootNode root, Frame frame) {
        assert (root != null);
        this.slots = slotsMap;
        this.root = root;
        this.sourceSection = root.getSourceSection();
        this.frame = frame;
    }

    @CompilerDirectives.TruffleBoundary
    static PythonLocalScope createLocalScope(RootNode root, MaterializedFrame frame) {
        LinkedHashMap<String, Integer> slotsMap = new LinkedHashMap<String, Integer>();
        FrameDescriptor fd = frame == null ? root.getFrameDescriptor() : frame.getFrameDescriptor();
        for (int slot = 0; slot < fd.getNumberOfSlots(); ++slot) {
            Object identifier = fd.getSlotName(slot);
            if (identifier == null || frame != null && frame.getValue(slot) == null) continue;
            slotsMap.put(identifier.toString(), slot);
        }
        return new PythonLocalScope(slotsMap, root, (Frame)frame);
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    boolean isMemberInsertable(String member) {
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    Integer findFrameSlot(String member) {
        return this.slots.get(member);
    }

    private boolean hasFrame() {
        return this.frame != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member) throws UnknownIdentifierException, UnsupportedMessageException {
        if (this.hasFrame()) {
            Integer slot = this.findFrameSlot(member);
            if (slot == null) {
                throw UnknownIdentifierException.create((String)member);
            }
            return this.frame.getValue(slot.intValue());
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    protected String[] getVariableNames() {
        return this.slots.keySet().toArray(new String[0]);
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return new InteropArray(this.getVariableNames());
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberReadable(String member) {
        return this.slots.containsKey(member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberModifiable(String member) {
        return this.slots.containsKey(member) && this.frame != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void writeMember(String member, Object value) throws UnknownIdentifierException, UnsupportedMessageException {
        Integer slot;
        if (this.hasFrame()) {
            slot = this.findFrameSlot(member);
            if (slot == null) {
                throw UnknownIdentifierException.create((String)member);
            }
        } else {
            throw UnsupportedMessageException.create();
        }
        this.frame.setObject(slot.intValue(), PForeignToPTypeNode.getUncached().executeConvert(value));
    }

    @ExportMessage
    boolean hasSourceLocation() {
        return this.sourceSection != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    SourceSection getSourceLocation() throws UnsupportedMessageException {
        if (this.sourceSection == null) {
            throw UnsupportedMessageException.create();
        }
        return this.sourceSection;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return PythonLanguage.class;
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        String name = this.root.getName();
        return name == null ? "local" : name;
    }
}

