/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.instrumentation;

import com.oracle.graal.python.nodes.instrumentation.NodeObjectDescriptorKeys;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.HashMap;
import java.util.Map;

@ExportLibrary(value=InteropLibrary.class)
public final class NodeObjectDescriptor
implements TruffleObject {
    private final Map<String, Object> data = new HashMap<String, Object>();

    @CompilerDirectives.TruffleBoundary
    public void addProperty(String name, Object value) {
        this.data.put(name, value);
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String key, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            assert (this.data.containsKey(key));
            Object object = this.data.get(key);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        return new NodeObjectDescriptorKeys(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberReadable(String key, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = this.data.containsKey(key);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    public static NodeObjectDescriptor createNodeObjectDescriptor() {
        return new NodeObjectDescriptor();
    }

    public static NodeObjectDescriptor createNodeObjectDescriptor(String name, Object value) {
        NodeObjectDescriptor desc = new NodeObjectDescriptor();
        desc.addProperty(name, value);
        return desc;
    }
}

