/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.bytecode.ImportFromNodeGen;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(value=false)
public abstract class ImportFromNode
extends PNodeWithContext {
    private static final TruffleString T_UNKNOWN_LOCATION = PythonUtils.tsLiteral("unknown location");
    private static final TruffleString T_UNKNOWN_MODULE_NAME = PythonUtils.tsLiteral("<unknown module name>");

    public abstract Object execute(Frame var1, Object var2, TruffleString var3);

    @Specialization
    Object doImport(VirtualFrame frame, Object module, TruffleString name, @Bind Node inliningTarget, @Cached PyObjectLookupAttr lookupAttr, @Cached InlinedBranchProfile maybeCircularProfile) {
        Object result = lookupAttr.execute((Frame)frame, inliningTarget, module, name);
        if (result != PNone.NO_VALUE) {
            return result;
        }
        maybeCircularProfile.enter(inliningTarget);
        return this.tryResolveCircularImport(module, name);
    }

    @CompilerDirectives.TruffleBoundary
    private Object tryResolveCircularImport(Object module, TruffleString name) {
        Object pkgnameObj;
        Object pkgpathObj = null;
        TruffleString pkgname = T_UNKNOWN_MODULE_NAME;
        TruffleString pkgpath = T_UNKNOWN_LOCATION;
        try {
            pkgnameObj = PyObjectGetAttr.executeUncached(module, SpecialAttributeNames.T___NAME__);
            pkgname = CastToTruffleStringNode.executeUncached(pkgnameObj);
        }
        catch (CannotCastException | PException e) {
            pkgnameObj = null;
        }
        if (pkgnameObj != null) {
            TruffleString fullname = StringUtils.cat(pkgname, StringLiterals.T_DOT, name);
            Object imported = PyDictGetItem.executeUncached(this.getContext().getSysModules(), fullname);
            if (imported != null) {
                return imported;
            }
            try {
                pkgpathObj = PyObjectGetAttr.executeUncached(module, SpecialAttributeNames.T___FILE__);
                pkgpath = CastToTruffleStringNode.executeUncached(pkgpathObj);
            }
            catch (CannotCastException | PException e) {
                pkgpathObj = null;
            }
        }
        if (pkgnameObj == null) {
            pkgnameObj = PNone.NONE;
        }
        if (pkgpathObj != null && AbstractImportNode.PyModuleIsInitializing.getUncached().execute(null, module)) {
            throw PConstructAndRaiseNode.getUncached().raiseImportErrorWithModule(null, pkgnameObj, pkgpathObj, ErrorMessages.CANNOT_IMPORT_NAME_CIRCULAR, name, pkgname, pkgpath);
        }
        if (pkgpathObj == null) {
            pkgpathObj = PNone.NONE;
        }
        throw PConstructAndRaiseNode.getUncached().raiseImportErrorWithModule(null, pkgnameObj, pkgpathObj, ErrorMessages.CANNOT_IMPORT_NAME, name, pkgname, pkgpath);
    }

    @NeverDefault
    public static ImportFromNode create() {
        return ImportFromNodeGen.create();
    }

    public static ImportFromNode getUncached() {
        return ImportFromNodeGen.getUncached();
    }
}

