/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.compiler.BlockInfo;
import com.oracle.graal.python.compiler.Instruction;
import com.oracle.graal.python.compiler.OpCodes;
import java.util.ArrayList;
import java.util.EnumSet;

final class Block {
    ArrayList<Instruction> instr = new ArrayList();
    Block next;
    BlockInfo info;
    int unwindOffset;
    int stackLevel = -1;
    int startBci = -1;
    int endBci = -1;
    private static final EnumSet<OpCodes> RETURN_OPCODES = EnumSet.of(OpCodes.RETURN_VALUE, OpCodes.RAISE_VARARGS);

    boolean isReturn() {
        return !this.instr.isEmpty() && RETURN_OPCODES.contains((Object)this.instr.get((int)(this.instr.size() - 1)).opcode);
    }

    BlockInfo.AbstractExceptionHandler findExceptionHandler() {
        if (this.info != null) {
            return this.info.findExceptionHandler();
        }
        return null;
    }

    int computeLoopDepth() {
        int loopDepth = 0;
        BlockInfo b = this.info;
        while (b != null) {
            if (b instanceof BlockInfo.Loop) {
                ++loopDepth;
            }
            b = b.outer;
        }
        return loopDepth;
    }
}

