/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.ssl.MemoryBIOBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.ssl.MemoryBIOBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ssl.MemoryBIOBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.ssl.PMemoryBIO;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PMemoryBIO})
public final class MemoryBIOBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = MemoryBIOBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MemoryBIOBuiltinsFactory.getFactories();
    }

    @Builtin(name="write_eof", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class WriteEOFNode
    extends PythonUnaryBuiltinNode {
        WriteEOFNode() {
        }

        @Specialization
        static PNone writeEOF(PMemoryBIO self) {
            self.writeEOF();
            return PNone.NONE;
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "buffer"})
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class WriteNode
    extends PythonBinaryClinicBuiltinNode {
        WriteNode() {
        }

        @Specialization(limit="3")
        static int write(VirtualFrame frame, PMemoryBIO self, Object buffer, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode raiseNode) {
            try {
                if (self.didWriteEOF()) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, ErrorMessages.SSL_CANNOT_WRITE_AFTER_EOF);
                }
                try {
                    byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                    int len = bufferLib.getBufferLength(buffer);
                    self.write(bytes, len);
                    int n = len;
                    return n;
                }
                catch (OverflowException | OutOfMemoryError e) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.MemoryError);
                }
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MemoryBIOBuiltinsClinicProviders.WriteNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1")
    @GenerateNodeFactory
    static abstract class ReadNode
    extends PythonBinaryClinicBuiltinNode {
        ReadNode() {
        }

        @Specialization
        static PBytes read(PMemoryBIO self, int size, @Bind PythonLanguage language) {
            int len = size >= 0 ? size : Integer.MAX_VALUE;
            return PFactory.createBytes(language, self.read(len));
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MemoryBIOBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="eof", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class EOFNode
    extends PythonUnaryBuiltinNode {
        EOFNode() {
        }

        @Specialization
        static boolean eof(PMemoryBIO self) {
            return self.isEOF();
        }
    }

    @Builtin(name="pending", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class PendingNode
    extends PythonUnaryBuiltinNode {
        PendingNode() {
        }

        @Specialization
        static int getPending(PMemoryBIO self) {
            return self.getPending();
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="MemoryBIO", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class MemoryBIONode
    extends PythonUnaryBuiltinNode {
        MemoryBIONode() {
        }

        @Specialization
        static PMemoryBIO create(Object type, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createMemoryBIO(language, type, getInstanceShape.execute(type));
        }
    }
}

