/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGCSupport;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.GetNativeWrapperNode;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.GetNextVaArgNode;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CConstants;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.module.ModuleGetNameNode;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNodeGen;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CExtNodes {
    private static final String J_UNICODE = "unicode";
    private static final String J_SUBTYPE_NEW = "_subtype_new";
    private static final long SIZEOF_PY_OBJECT_PTR = 8L;

    @CompilerDirectives.TruffleBoundary
    public static Object lookupNativeMemberInMRO(PythonManagedClass cls, CFields nativeMemberName, HiddenAttr managedMemberName) {
        NativeCAPISymbol symbol = null;
        if (managedMemberName == HiddenAttr.ALLOC) {
            symbol = NativeCAPISymbol.FUN_PY_TYPE_GENERIC_ALLOC;
        } else if (managedMemberName == HiddenAttr.FREE) {
            symbol = (TypeNodes.GetTypeFlagsNode.executeUncached(cls) & 0x4000L) != 0L ? NativeCAPISymbol.FUN_GRAALPY_OBJECT_GC_DEL : NativeCAPISymbol.FUN_PY_OBJECT_FREE;
        } else if (managedMemberName == HiddenAttr.TRAVERSE) {
            symbol = cls instanceof PythonBuiltinClass ? NativeCAPISymbol.FUN_NO_OP_TRAVERSE : NativeCAPISymbol.FUN_SUBTYPE_TRAVERSE;
        } else if (managedMemberName == HiddenAttr.CLEAR) {
            symbol = NativeCAPISymbol.FUN_NO_OP_CLEAR;
        }
        if (symbol != null) {
            Object func = HiddenAttr.ReadNode.executeUncached(cls, managedMemberName, null);
            if (func != null) {
                return func;
            }
            return CApiContext.getNativeSymbol(null, symbol);
        }
        MroSequenceStorage mroStorage = TypeNodes.GetMroStorageNode.executeUncached(cls);
        int n = mroStorage.length();
        for (int i = 0; i < n; ++i) {
            Object result;
            PythonAbstractClass mroCls = (PythonAbstractClass)SequenceStorageNodes.GetItemDynamicNode.executeUncached(mroStorage, i);
            if (PGuards.isManagedClass(mroCls)) {
                result = HiddenAttr.ReadNode.executeUncached((PythonObject)((Object)mroCls), managedMemberName, null);
                if (result == null) continue;
                return result;
            }
            assert (PGuards.isNativeClass(mroCls)) : "invalid class inheritance structure; expected native class";
            result = CStructAccess.ReadPointerNode.getUncached().readFromObj((PythonNativeClass)mroCls, nativeMemberName);
            if (PGuards.isNullOrZero(result, InteropLibrary.getUncached())) continue;
            return result;
        }
        if (managedMemberName == HiddenAttr.CLEAR && (TypeNodes.GetTypeFlagsNode.executeUncached(cls) & 0x4000L) != 0L) {
            return CApiContext.getNativeSymbol(null, NativeCAPISymbol.FUN_NO_OP_CLEAR);
        }
        return HiddenAttr.ReadNode.executeUncached(PythonContext.get(null).lookupType(PythonBuiltinClassType.PythonObject), managedMemberName, PNone.NO_VALUE);
    }

    @CompilerDirectives.TruffleBoundary
    public static long lookupNativeI64MemberInMRO(Object cls, CFields nativeMemberName, Object managedMemberName) {
        long l;
        boolean isBasicsizeOrWeaklistoffset;
        assert (managedMemberName instanceof HiddenAttr || managedMemberName instanceof TruffleString);
        MroSequenceStorage mroStorage = TypeNodes.GetMroStorageNode.executeUncached(cls);
        int n = mroStorage.length();
        boolean bl = isBasicsizeOrWeaklistoffset = nativeMemberName == CFields.PyTypeObject__tp_basicsize || nativeMemberName == CFields.PyTypeObject__tp_weaklistoffset;
        if (isBasicsizeOrWeaklistoffset && cls instanceof PythonManagedClass) {
            PythonManagedClass pmc = (PythonManagedClass)cls;
            l = (long)pmc.getIndexedSlotCount() * 8L;
        } else {
            l = 0L;
        }
        long indexedSlotsSize = l;
        for (int i = 0; i < n; ++i) {
            PythonAbstractClass mroCls = (PythonAbstractClass)SequenceStorageNodes.GetItemDynamicNode.executeUncached(mroStorage, i);
            if (PGuards.isManagedClass(mroCls)) {
                Object attr;
                if (managedMemberName instanceof HiddenAttr) {
                    HiddenAttr ha = (HiddenAttr)managedMemberName;
                    attr = HiddenAttr.ReadNode.executeUncached((PythonAbstractObject)((Object)mroCls), ha, PNone.NO_VALUE);
                } else {
                    attr = ReadAttributeFromObjectNode.getUncachedForceType().execute(mroCls, (TruffleString)CompilerDirectives.castExact((Object)managedMemberName, TruffleString.class));
                }
                if (attr != PNone.NO_VALUE) {
                    return PyNumberAsSizeNode.executeExactUncached(attr);
                }
                if (indexedSlotsSize == 0L) continue;
                break;
            }
            assert (PGuards.isNativeClass(mroCls)) : "invalid class inheritance structure; expected native class";
            return CStructAccess.ReadI64Node.getUncached().readFromObj((PythonNativeClass)mroCls, nativeMemberName);
        }
        return isBasicsizeOrWeaklistoffset ? indexedSlotsSize + (long)CStructs.PyObject.size() : 0L;
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class VisitNode
    extends Node {
        public abstract int execute(VirtualFrame var1, Node var2, PythonContext.PythonThreadState var3, Object var4, Object var5, Object var6);

        @Specialization
        static int doGeneric(VirtualFrame frame, Node inliningTarget, PythonContext.PythonThreadState threadState, Object item, Object visitFunction, Object visitArg, @Cached InlinedConditionProfile isNativeObjectProfile, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalFunctionInvokeNode, @Cached(inline=false) ExternalFunctionNodes.CheckPrimitiveFunctionResultNode checkPrimitiveFunctionResultNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode) {
            assert (InteropLibrary.getUncached().isExecutable(visitFunction));
            if (isNativeObjectProfile.profile(inliningTarget, item instanceof PythonAbstractNativeObject)) {
                Object result = externalFunctionInvokeNode.call(frame, inliningTarget, threadState, CApiGCSupport.VISIT_TIMING, StringLiterals.T_VISIT, visitFunction, toNativeNode.execute(item), visitArg);
                return (int)checkPrimitiveFunctionResultNode.executeLong(threadState, StringLiterals.T_VISIT, result);
            }
            return 0;
        }
    }

    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class})
    static abstract class ReleaseNativeWrapperNode
    extends Node {
        ReleaseNativeWrapperNode() {
        }

        public abstract void execute(Object var1);

        @Specialization
        static void doNativeWrapper(PythonNativeWrapper.PythonAbstractObjectNativeWrapper nativeWrapper) {
        }

        @Specialization(guards={"!isNativeWrapper(object)"})
        static void doOther(Object object) {
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CreateMemoryViewFromNativeNode
    extends PNodeWithContext {
        public abstract PMemoryView execute(Node var1, PythonNativeObject var2, int var3);

        @Specialization
        static PMemoryView fromNative(PythonNativeObject buf, int flags, @Cached(inline=false) CApiTransitions.PythonToNativeNode toSulongNode, @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode asPythonObjectNode, @Cached(inline=false) PCallCapiFunction callCapiFunction, @Cached(inline=false) ExternalFunctionNodes.DefaultCheckFunctionResultNode checkFunctionResultNode) {
            Object result = callCapiFunction.call(NativeCAPISymbol.FUN_GRAALPY_MEMORYVIEW_FROM_OBJECT, toSulongNode.execute(buf), flags);
            checkFunctionResultNode.execute(PythonContext.get(callCapiFunction), NativeCAPISymbol.FUN_GRAALPY_MEMORYVIEW_FROM_OBJECT.getTsName(), result);
            return (PMemoryView)asPythonObjectNode.execute(result);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class HasNativeBufferNode
    extends PNodeWithContext {
        public abstract boolean execute(Node var1, PythonAbstractNativeObject var2);

        @Specialization
        static boolean readTpAsBuffer(PythonAbstractNativeObject object, @CachedLibrary(limit="3") InteropLibrary lib, @Cached(inline=false) CStructAccess.ReadPointerNode readType, @Cached(inline=false) CStructAccess.ReadPointerNode readAsBuffer) {
            Object type = readType.readFromObj(object, CFields.PyObject__ob_type);
            Object result = readAsBuffer.read(type, CFields.PyTypeObject__tp_as_buffer);
            return !PGuards.isNullOrZero(result, lib);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CreateMethodNode
    extends PNodeWithContext {
        public abstract PBuiltinFunction execute(Node var1, Object var2, int var3);

        @Specialization
        static PBuiltinFunction doIt(Node inliningTarget, Object methodDef, int element, @CachedLibrary(limit="2") InteropLibrary resultLib, @Cached(inline=false) CStructAccess.ReadPointerNode readPointerNode, @Cached(inline=false) CStructAccess.ReadI32Node readI32Node, @Cached(inline=false) FromCharPointerNode fromCharPointerNode, @Bind PythonLanguage language, @Cached CExtCommonNodes.EnsureExecutableNode ensureCallableNode, @Cached HiddenAttr.WriteNode writeHiddenAttrNode, @Cached(inline=false) WriteAttributeToPythonObjectNode writeAttributeToPythonObjectNode) {
            Object methodNamePtr = readPointerNode.readStructArrayElement(methodDef, element, CFields.PyMethodDef__ml_name);
            if (resultLib.isNull(methodNamePtr) || methodNamePtr instanceof Long && (Long)methodNamePtr == 0L) {
                return null;
            }
            TruffleString methodName = fromCharPointerNode.execute(methodNamePtr);
            PNone methodDoc = PNone.NONE;
            Object methodDocPtr = readPointerNode.readStructArrayElement(methodDef, element, CFields.PyMethodDef__ml_doc);
            if (!resultLib.isNull(methodDocPtr)) {
                methodDoc = fromCharPointerNode.execute(methodDocPtr, false);
            }
            int flags = readI32Node.readStructArrayElement(methodDef, element, CFields.PyMethodDef__ml_flags);
            Object mlMethObj = readPointerNode.readStructArrayElement(methodDef, element, CFields.PyMethodDef__ml_meth);
            ExternalFunctionNodes.PExternalFunctionWrapper sig = ExternalFunctionNodes.PExternalFunctionWrapper.fromMethodFlags(flags);
            RootCallTarget callTarget = ExternalFunctionNodes.PExternalFunctionWrapper.getOrCreateCallTarget(sig, PythonLanguage.get(inliningTarget), methodName, CExtContext.isMethStatic(flags));
            mlMethObj = ensureCallableNode.execute(inliningTarget, mlMethObj, sig);
            PKeyword[] kwDefaults = ExternalFunctionNodes.createKwDefaults(mlMethObj);
            PBuiltinFunction function = PFactory.createBuiltinFunction(language, methodName, null, PythonUtils.EMPTY_OBJECT_ARRAY, kwDefaults, flags, callTarget);
            writeHiddenAttrNode.execute(inliningTarget, function, HiddenAttr.METHOD_DEF_PTR, methodDef);
            writeAttributeToPythonObjectNode.execute(function, SpecialAttributeNames.T___DOC__, methodDoc);
            return function;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ExecModuleNode
    extends MultiPhaseExtensionModuleInitNode {
        private static final String NFI_EXEC_SRC = "(POINTER):SINT32";
        private static final Source NFI_LIBFFI_EXEC = Source.newBuilder((String)"nfi", (CharSequence)"(POINTER):SINT32", (String)"exec").build();
        private static final Source NFI_PANAMA_EXEC = Source.newBuilder((String)"nfi", (CharSequence)"with panama (POINTER):SINT32", (String)"exec").build();

        public abstract int execute(CApiContext var1, PythonModule var2, Object var3);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int doGeneric(CApiContext capiContext, PythonModule module, Object moduleDef, @Bind Node inliningTarget, @Cached ModuleGetNameNode getNameNode, @Cached CStructAccess.ReadI64Node readI64, @Cached CStructAccess.AllocateNode alloc, @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached CStructAccess.ReadI32Node readI32Node, @CachedLibrary(limit="3") InteropLibrary interopLib, @CachedLibrary(limit="1") SignatureLibrary signatureLibrary, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode, @Cached PRaiseNode raiseNode) {
            block13: {
                InteropLibrary U = InteropLibrary.getUncached();
                TruffleString mName = getNameNode.execute(inliningTarget, module);
                long mSize = readI64.read(moduleDef, CFields.PyModuleDef__m_size);
                try {
                    Object slotDefinitions;
                    if (mSize >= 0L) {
                        Object mdState = alloc.alloc(mSize == 0L ? 1L : mSize);
                        assert (mdState != null && !InteropLibrary.getUncached().isNull(mdState));
                        module.setNativeModuleState(mdState);
                    }
                    if (interopLib.isNull(slotDefinitions = readPointerNode.read(moduleDef, CFields.PyModuleDef__m_slots))) {
                        return 0;
                    }
                    int i = 0;
                    while (true) {
                        int slotId = readI32Node.readStructArrayElement(slotDefinitions, i, CFields.PyModuleDef_Slot__slot);
                        switch (slotId) {
                            case 0: {
                                break block13;
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                Object execFunction = readPointerNode.readStructArrayElement(slotDefinitions, i, CFields.PyModuleDef_Slot__value);
                                PythonContext context = capiContext.getContext();
                                if (!U.isExecutable(execFunction)) {
                                    boolean panama = context.getOption(PythonOptions.UsePanama);
                                    Object signature = context.getEnv().parseInternal(panama ? NFI_PANAMA_EXEC : NFI_LIBFFI_EXEC, new String[0]).call(new Object[0]);
                                    execFunction = signatureLibrary.bind(signature, execFunction);
                                }
                                Object result = interopLib.execute(execFunction, new Object[]{CApiTransitions.PythonToNativeNode.executeUncached(module)});
                                int iResult = interopLib.asInt(result);
                                PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget);
                                transformExceptionFromNativeNode.execute(inliningTarget, threadState, mName, iResult != 0, true, ErrorMessages.EXECUTION_FAILED_WITHOUT_EXCEPTION, ErrorMessages.EXECUTION_RAISED_EXCEPTION);
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw raiseNode.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.MODULE_INITIALIZED_WITH_UNKNOWN_SLOT, mName, slotId);
                            }
                        }
                        ++i;
                    }
                }
                catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            return 0;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CreateModuleNode
    extends MultiPhaseExtensionModuleInitNode {
        private static final String NFI_CREATE_NAME = "create";
        private static final String NFI_CREATE_SRC = "(POINTER,POINTER):POINTER";
        private static final Source NFI_LIBFFI_CREATE = Source.newBuilder((String)"nfi", (CharSequence)"(POINTER,POINTER):POINTER", (String)"create").build();
        private static final Source NFI_PANAMA_CREATE = Source.newBuilder((String)"nfi", (CharSequence)"with panama (POINTER,POINTER):POINTER", (String)"create").build();

        public abstract Object execute(CApiContext var1, CApiContext.ModuleSpec var2, Object var3, Object var4);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doGeneric(CApiContext capiContext, CApiContext.ModuleSpec moduleSpec, Object moduleDefWrapper, Object library, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached CStructAccess.ReadPointerNode readPointer, @Cached CStructAccess.ReadI64Node readI64, @CachedLibrary(limit="3") InteropLibrary interopLib, @Cached FromCharPointerNode fromCharPointerNode, @Cached WriteAttributeToObjectNode writeAttrNode, @Cached WriteAttributeToPythonObjectNode writeAttrToMethodNode, @Cached CreateMethodNode addLegacyMethodNode, @Cached CApiTransitions.NativeToPythonTransferNode toJavaNode, @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached CStructAccess.ReadI32Node readI32Node, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode, @Cached PRaiseNode raiseNode) {
            Object module;
            Object moduleDef = moduleDefWrapper instanceof PythonAbstractNativeObject ? ((PythonAbstractNativeObject)moduleDefWrapper).getPtr() : moduleDefWrapper;
            TruffleString mName = moduleSpec.name;
            Object docPtr = readPointer.read(moduleDef, CFields.PyModuleDef__m_doc);
            PNone mDoc = PGuards.isNullOrZero(docPtr, interopLib) ? PNone.NO_VALUE : fromCharPointerNode.execute(docPtr);
            long mSize = readI64.read(moduleDef, CFields.PyModuleDef__m_size);
            if (mSize < 0L) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.M_SIZE_CANNOT_BE_NEGATIVE, mName);
            }
            Object createFunction = null;
            boolean hasExecutionSlots = false;
            Object slotDefinitions = readPointerNode.read(moduleDef, CFields.PyModuleDef__m_slots);
            if (!interopLib.isNull(slotDefinitions)) {
                int i = 0;
                block8: while (true) {
                    int slotId = readI32Node.readStructArrayElement(slotDefinitions, i, CFields.PyModuleDef_Slot__slot);
                    switch (slotId) {
                        case 0: {
                            break block8;
                        }
                        case 1: {
                            if (createFunction != null) {
                                throw raiseNode.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.MODULE_HAS_MULTIPLE_CREATE_SLOTS, mName);
                            }
                            createFunction = readPointerNode.readStructArrayElement(slotDefinitions, i, CFields.PyModuleDef_Slot__value);
                            break;
                        }
                        case 2: {
                            hasExecutionSlots = true;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw raiseNode.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.MODULE_USES_UNKNOW_SLOT_ID, mName, slotId);
                        }
                    }
                    ++i;
                }
            }
            if (createFunction != null && !interopLib.isNull(createFunction)) {
                Object[] cArguments = new Object[]{CApiTransitions.PythonToNativeNode.executeUncached(moduleSpec.originalModuleSpec), moduleDef};
                try {
                    Object result;
                    PythonContext context = capiContext.getContext();
                    if (!interopLib.isExecutable(createFunction)) {
                        boolean panama = context.getOption(PythonOptions.UsePanama);
                        Object signature = context.getEnv().parseInternal(panama ? NFI_PANAMA_CREATE : NFI_LIBFFI_CREATE, new String[0]).call(new Object[0]);
                        result = interopLib.execute(SignatureLibrary.getUncached().bind(signature, createFunction), cArguments);
                    } else {
                        result = interopLib.execute(createFunction, cArguments);
                    }
                    PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget);
                    transformExceptionFromNativeNode.execute(inliningTarget, threadState, mName, interopLib.isNull(result), true, ErrorMessages.CREATION_FAILD_WITHOUT_EXCEPTION, ErrorMessages.CREATION_RAISED_EXCEPTION);
                    module = toJavaNode.execute(result);
                }
                catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                if (!(module instanceof PythonModule)) {
                    if (mSize > 0L) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.NOT_A_MODULE_OBJECT_BUT_REQUESTS_MODULE_STATE, mName);
                    }
                    if (hasExecutionSlots) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.MODULE_SPECIFIES_EXEC_SLOTS_BUT_DIDNT_CREATE_INSTANCE, mName);
                    }
                } else {
                    ((PythonModule)module).setNativeModuleDef(moduleDef);
                }
            } else {
                PythonModule pythonModule = PFactory.createPythonModule(language, mName);
                pythonModule.setNativeModuleDef(moduleDef);
                module = pythonModule;
            }
            Object methodDefinitions = readPointerNode.read(moduleDef, CFields.PyModuleDef__m_methods);
            if (!interopLib.isNull(methodDefinitions)) {
                PBuiltinFunction fun;
                int i = 0;
                while ((fun = addLegacyMethodNode.execute(inliningTarget, methodDefinitions, i)) != null) {
                    PBuiltinMethod method = PFactory.createBuiltinMethod(language, module, fun);
                    writeAttrToMethodNode.execute(method, SpecialAttributeNames.T___MODULE__, mName);
                    writeAttrNode.execute(module, fun.getName(), method);
                    ++i;
                }
            }
            writeAttrNode.execute(module, SpecialAttributeNames.T___DOC__, mDoc);
            writeAttrNode.execute(module, SpecialAttributeNames.T___LIBRARY__, library);
            capiContext.addLoadedExtensionLibrary(library);
            return module;
        }
    }

    static abstract class MultiPhaseExtensionModuleInitNode
    extends Node {
        static final int SLOT_PY_MOD_CREATE = 1;
        static final int SLOT_PY_MOD_EXEC = 2;
        static final int SLOT_PY_MOD_MULTIPLE_INTERPRETERS = 3;

        MultiPhaseExtensionModuleInitNode() {
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class UnicodeFromFormatNode
    extends Node {
        private static Pattern pattern;

        public static Object executeUncached(TruffleString format, Object vaList) {
            return CExtNodesFactory.UnicodeFromFormatNodeGen.getUncached().execute(null, format, vaList);
        }

        private static Matcher match(String formatStr) {
            if (pattern == null) {
                pattern = Pattern.compile("%(?<flags>[-+ #0])?(?<width>\\d+)?(\\.(?<prec>\\d+))?(?<len>(l|ll|z))?(?<spec>[%cduixspAUVSR])");
            }
            return pattern.matcher(formatStr);
        }

        public abstract Object execute(Node var1, TruffleString var2, Object var3);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doGeneric(TruffleString f, Object vaList) {
            String format = f.toJavaStringUncached();
            CApiTransitions.NativeToPythonNode toJavaNode = CApiTransitionsFactory.NativeToPythonNodeGen.getUncached();
            CastToJavaStringNode castToJavaStringNode = CastToJavaStringNodeGen.getUncached();
            FromCharPointerNode fromCharPointerNode = CExtNodesFactory.FromCharPointerNodeGen.getUncached();
            InteropLibrary interopLibrary = InteropLibrary.getUncached();
            StringBuilder result = new StringBuilder();
            int vaArgIdx = 0;
            try {
                Matcher matcher = UnicodeFromFormatNode.match(format);
                int cur = 0;
                while (matcher.find(cur)) {
                    boolean valid = false;
                    result.append(format, cur, matcher.start());
                    cur = matcher.end();
                    String spec = matcher.group("spec");
                    String len = matcher.group("len");
                    int prec = UnicodeFromFormatNode.getPrec(matcher.group("prec"));
                    assert (spec.length() == 1);
                    char la = spec.charAt(0);
                    PythonContext context = PythonContext.get(null);
                    switch (la) {
                        case '%': {
                            result.append('%');
                            valid = true;
                            break;
                        }
                        case 'c': {
                            int ordinal = this.getAndCastToInt(interopLibrary, vaList);
                            if (ordinal < 0 || ordinal > 0x110000) {
                                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.OverflowError, ErrorMessages.CHARACTER_ARG_NOT_IN_RANGE);
                            }
                            result.append((char)ordinal);
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'd': 
                        case 'i': {
                            if (len != null) {
                                switch (len) {
                                    case "ll": 
                                    case "l": 
                                    case "z": {
                                        ++vaArgIdx;
                                        result.append(this.castToLong(interopLibrary, GetNextVaArgNode.executeUncached(vaList)));
                                        valid = true;
                                    }
                                }
                                break;
                            }
                            result.append(this.getAndCastToInt(interopLibrary, vaList));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'u': {
                            if (len != null) {
                                switch (len) {
                                    case "ll": 
                                    case "l": 
                                    case "z": {
                                        ++vaArgIdx;
                                        result.append(this.castToLong(interopLibrary, GetNextVaArgNode.executeUncached(vaList)));
                                        valid = true;
                                    }
                                }
                                break;
                            }
                            result.append(Integer.toUnsignedString(this.getAndCastToInt(interopLibrary, vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'x': {
                            result.append(Integer.toHexString(this.getAndCastToInt(interopLibrary, vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 's': {
                            Object unicodeObj;
                            String sValue;
                            Object charPtr = GetNextVaArgNode.executeUncached(vaList);
                            if (interopLibrary.isNull(charPtr)) {
                                sValue = "(NULL)";
                            } else {
                                unicodeObj = fromCharPointerNode.execute(charPtr);
                                sValue = castToJavaStringNode.execute(unicodeObj);
                            }
                            try {
                                if (prec == -1) {
                                    result.append(sValue);
                                } else {
                                    result.append(sValue, 0, Math.min(sValue.length(), prec));
                                }
                            }
                            catch (CannotCastException e) {
                                throw CompilerDirectives.shouldNotReachHere();
                            }
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'p': {
                            Object ptr = GetNextVaArgNode.executeUncached(vaList);
                            long value = interopLibrary.isPointer(ptr) ? interopLibrary.asPointer(ptr) : (interopLibrary.hasIdentity(ptr) ? (long)interopLibrary.identityHashCode(ptr) : (long)System.identityHashCode(ptr));
                            result.append(PythonUtils.formatJString("0x%x", value));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'A': {
                            result.append(UnicodeFromFormatNode.callBuiltin(context, BuiltinNames.T_ASCII, UnicodeFromFormatNode.getPyObject(vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'U': {
                            result.append(castToJavaStringNode.execute(UnicodeFromFormatNode.getPyObject(vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'V': {
                            Object pyObjectPtr = GetNextVaArgNode.executeUncached(vaList);
                            Object unicodeObj = InteropLibrary.getUncached().isNull(pyObjectPtr) ? fromCharPointerNode.execute(GetNextVaArgNode.executeUncached(vaList)) : toJavaNode.execute(pyObjectPtr);
                            result.append(castToJavaStringNode.execute(unicodeObj));
                            vaArgIdx += 2;
                            valid = true;
                            break;
                        }
                        case 'S': {
                            result.append(UnicodeFromFormatNode.callBuiltin(context, BuiltinNames.T_STR, UnicodeFromFormatNode.getPyObject(vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'R': {
                            result.append(UnicodeFromFormatNode.callBuiltin(context, BuiltinNames.T_REPR, UnicodeFromFormatNode.getPyObject(vaList)));
                            ++vaArgIdx;
                            valid = true;
                        }
                    }
                    if (valid) continue;
                    result.append(matcher.group());
                }
                result.append(format, cur, format.length());
            }
            catch (InteropException e) {
                throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.SystemError, ErrorMessages.ERROR_WHEN_ACCESSING_VAR_ARG_AT_POS, vaArgIdx);
            }
            return PythonUtils.toTruffleStringUncached(result.toString());
        }

        private static int getPrec(String prec) {
            if (prec == null) {
                return -1;
            }
            return Integer.parseInt(prec);
        }

        private int getAndCastToInt(InteropLibrary lib, Object vaList) throws InteropException {
            Object value = GetNextVaArgNode.executeUncached(vaList);
            if (lib.fitsInInt(value)) {
                try {
                    return lib.asInt(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (!lib.isPointer(value)) {
                lib.toNative(value);
            }
            if (lib.isPointer(value)) {
                try {
                    return (int)lib.asPointer(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.SystemError, ErrorMessages.P_OBJ_CANT_BE_INTEPRETED_AS_INTEGER, value);
        }

        private long castToLong(InteropLibrary lib, Object value) {
            if (lib.fitsInLong(value)) {
                try {
                    return lib.asLong(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (!lib.isPointer(value)) {
                lib.toNative(value);
            }
            if (lib.isPointer(value)) {
                try {
                    return lib.asPointer(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.SystemError, ErrorMessages.P_OBJ_CANT_BE_INTEPRETED_AS_INTEGER, value);
        }

        private static Object getPyObject(Object vaList) throws InteropException {
            return CApiTransitions.NativeToPythonNode.executeUncached(GetNextVaArgNode.executeUncached(vaList));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object callBuiltin(PythonContext context, TruffleString builtinName, Object object) {
            Object attribute = PyObjectLookupAttr.executeUncached(context.getBuiltins(), builtinName);
            return CastToJavaStringNodeGen.getUncached().execute(CallNode.executeUncached(attribute, object));
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class ObSizeNode
    extends PNodeWithContext {
        public abstract long execute(Node var1, Object var2);

        @Specialization
        static long doPythonNativeVoidPtr(PythonNativeVoidPtr object) {
            return 63 / CConstants.PYLONG_BITS_IN_DIGIT.intValue() + 1;
        }

        @Specialization
        static long doClass(PythonManagedClass object) {
            return 0L;
        }

        @Fallback
        static long doOther(Node inliningTarget, Object object, @Cached PyObjectSizeNode sizeNode) {
            try {
                return sizeNode.execute(null, inliningTarget, object);
            }
            catch (PException e) {
                return -1L;
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class LvTagNode
    extends PNodeWithContext {
        private static final int SIGN_ZERO = 1;
        private static final int SIGN_NEGATIVE = 2;
        private static final int NON_SIZE_BITS = 3;

        public abstract long execute(Node var1, Object var2);

        public long getDigitCount(Node inliningTarget, Object object) {
            return this.execute(inliningTarget, object) >> 3;
        }

        static long toLvTag(long x, boolean isNegative) {
            int sign = 0;
            if (x == 0L) {
                return 1L;
            }
            if (isNegative) {
                sign = 2;
            }
            return x << 3 | (long)sign;
        }

        @Specialization
        static long doBoolean(boolean object) {
            return LvTagNode.toLvTag(object ? 1L : 0L, false);
        }

        @Specialization
        static long doInteger(int object) {
            return LvTagNode.doLong(object);
        }

        @Specialization
        static long doLong(long object) {
            boolean sign = object < 0L;
            int size = 0;
            for (long t = PInt.abs(object); t != 0L; t >>>= CConstants.PYLONG_BITS_IN_DIGIT.intValue()) {
                ++size;
            }
            return LvTagNode.toLvTag(size, sign);
        }

        @Specialization
        static long doPInt(PInt object) {
            int bw = CConstants.PYLONG_BITS_IN_DIGIT.intValue();
            int len = (PInt.bitLength(object.abs()) + bw - 1) / bw;
            return LvTagNode.toLvTag(len, object.isNegative());
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ResolvePointerNode
    extends PNodeWithContext {
        public static Object executeUncached(Object pointerObject) {
            return CExtNodesFactory.ResolvePointerNodeGen.getUncached().execute(null, pointerObject);
        }

        public abstract Object execute(Node var1, Object var2);

        public abstract Object executeLong(Node var1, long var2);

        @Specialization
        static Object resolveLongCached(Node inliningTarget, long pointer, @Cached.Exclusive @Cached CApiTransitions.ResolveHandleNode resolveHandleNode, @Cached.Exclusive @Cached CApiTransitions.UpdateStrongRefNode updateRefNode) {
            Object lookup = CApiTransitions.lookupNative(pointer);
            if (lookup != null) {
                if (lookup instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                    PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)lookup;
                    updateRefNode.execute(inliningTarget, objectNativeWrapper, objectNativeWrapper.incRef());
                }
                return lookup;
            }
            if (CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(pointer)) {
                return resolveHandleNode.execute(inliningTarget, pointer);
            }
            return pointer;
        }

        @Specialization(guards={"!isLong(pointerObject)"})
        static Object resolveGeneric(Node inliningTarget, Object pointerObject, @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Exclusive @Cached CApiTransitions.ResolveHandleNode resolveHandleNode, @Cached.Exclusive @Cached CApiTransitions.UpdateStrongRefNode updateRefNode) {
            if (lib.isPointer(pointerObject)) {
                long pointer;
                try {
                    pointer = lib.asPointer(pointerObject);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                Object lookup = CApiTransitions.lookupNative(pointer);
                if (lookup != null) {
                    if (lookup instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                        PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)lookup;
                        updateRefNode.execute(inliningTarget, objectNativeWrapper, objectNativeWrapper.incRef());
                    }
                    return lookup;
                }
                if (CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(pointer)) {
                    return resolveHandleNode.execute(inliningTarget, pointer);
                }
            }
            return pointerObject;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class ClearNativeWrapperNode
    extends Node {
        public abstract void execute(Node var1, Object var2, PythonNativeWrapper var3);

        @Specialization(guards={"!isPrimitiveNativeWrapper(nativeWrapper)"})
        static void doPythonAbstractObject(PythonAbstractObject delegate, PythonNativeWrapper nativeWrapper) {
            assert (!(nativeWrapper instanceof PythonObjectNativeWrapper) || delegate.getNativeWrapper() == nativeWrapper) : "inconsistent native wrappers";
            delegate.clearNativeWrapper();
        }

        @Specialization(guards={"delegate == null"})
        static void doPrimitiveNativeWrapper(Node inliningTarget, Object delegate, PrimitiveNativeWrapper nativeWrapper) {
            assert (!ClearNativeWrapperNode.isSmallIntegerWrapperSingleton(nativeWrapper, PythonContext.get(inliningTarget))) : "clearing primitive native wrapper singleton of small integer";
        }

        @Specialization(guards={"delegate != null"})
        static void doPrimitiveNativeWrapperMaterialized(Node inliningTarget, PythonAbstractObject delegate, PrimitiveNativeWrapper nativeWrapper, @Cached InlinedConditionProfile profile) {
            if (profile.profile(inliningTarget, delegate.getNativeWrapper() == nativeWrapper)) {
                assert (!ClearNativeWrapperNode.isSmallIntegerWrapperSingleton(nativeWrapper, PythonContext.get(inliningTarget))) : "clearing primitive native wrapper singleton of small integer";
                delegate.clearNativeWrapper();
            }
        }

        @Specialization(guards={"delegate != null", "!isAnyPythonObject(delegate)"})
        static void doOther(Object delegate, PythonNativeWrapper nativeWrapper) {
            assert (!ClearNativeWrapperNode.isPrimitiveNativeWrapper(nativeWrapper));
        }

        static boolean isPrimitiveNativeWrapper(PythonNativeWrapper nativeWrapper) {
            return nativeWrapper instanceof PrimitiveNativeWrapper;
        }

        private static boolean isSmallIntegerWrapperSingleton(PrimitiveNativeWrapper nativeWrapper, PythonContext context) {
            return CApiGuards.isSmallIntegerWrapper(nativeWrapper) && GetNativeWrapperNode.doLongSmall(nativeWrapper.getLong(), context) == nativeWrapper;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class XDecRefPointerNode
    extends PNodeWithContext {
        public static void executeUncached(Object pointer) {
            CExtNodesFactory.XDecRefPointerNodeGen.getUncached().execute(null, pointer);
        }

        public abstract void execute(Node var1, Object var2);

        @Specialization
        static void doDecref(Node inliningTarget, Object pointerObj, @CachedLibrary(limit="2") InteropLibrary lib, @Cached(inline=false) CApiTransitions.ToPythonWrapperNode toPythonWrapperNode, @Cached InlinedBranchProfile isWrapperProfile, @Cached InlinedBranchProfile isNativeObject, @Cached CApiTransitions.UpdateStrongRefNode updateRefNode, @Cached(inline=false) CStructAccess.ReadI64Node readRefcount, @Cached(inline=false) CStructAccess.WriteLongNode writeRefcount, @Cached(inline=false) PCallCapiFunction callDealloc) {
            long pointer;
            if (pointerObj instanceof Long) {
                Long longPointer = (Long)pointerObj;
                pointer = longPointer;
            } else if (lib.isPointer(pointerObj)) {
                try {
                    pointer = lib.asPointer(pointerObj);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            } else {
                return;
            }
            if (pointer == 0L) {
                return;
            }
            PythonNativeWrapper wrapper = toPythonWrapperNode.executeWrapper(pointer, false);
            if (wrapper instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)wrapper;
                isWrapperProfile.enter(inliningTarget);
                updateRefNode.execute(inliningTarget, objectWrapper, objectWrapper.decRef());
            } else if (wrapper == null) {
                isNativeObject.enter(inliningTarget);
                assert (CApiTransitions.NativeToPythonNode.executeUncached(new NativePointer(pointer)) instanceof PythonAbstractNativeObject);
                long refcount = readRefcount.read(pointer, CFields.PyObject__ob_refcnt);
                if (refcount != 0xFFFFFFFFL) {
                    writeRefcount.write(pointer, CFields.PyObject__ob_refcnt, --refcount);
                    if (refcount == 0L) {
                        callDealloc.call(NativeCAPISymbol.FUN_PY_DEALLOC, pointer);
                    }
                }
            } else {
                throw CompilerDirectives.shouldNotReachHere((String)"Cannot DECREF non-object");
            }
        }
    }

    @GenerateUncached
    @GenerateCached
    @GenerateInline(value=false)
    public static abstract class PRaiseNativeNode
    extends Node {
        public final int raiseInt(Frame frame, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.executeInt(frame, errorValue, errType, format, arguments);
        }

        public final <T> T raise(Frame frame, T errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            Object result = this.execute(frame, errorValue, errType, format, arguments);
            assert (result == errorValue);
            return errorValue;
        }

        public final int raiseIntWithoutFrame(int errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.executeInt(null, errorValue, errType, format, arguments);
        }

        public abstract Object execute(Frame var1, Object var2, PythonBuiltinClassType var3, TruffleString var4, Object[] var5);

        public abstract int executeInt(Frame var1, int var2, PythonBuiltinClassType var3, TruffleString var4, Object[] var5);

        @Specialization
        static int doInt(int errorValue, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, @Bind Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="transformExceptionToNativeNode") @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode) {
            PRaiseNativeNode.raiseNative(inliningTarget, errType, format, arguments, raiseNode, transformExceptionToNativeNode);
            return errorValue;
        }

        @Specialization
        static Object doObject(Object errorValue, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, @Bind Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="transformExceptionToNativeNode") @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode) {
            PRaiseNativeNode.raiseNative(inliningTarget, errType, format, arguments, raiseNode, transformExceptionToNativeNode);
            return errorValue;
        }

        private static void raiseNative(Node inliningTarget, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, PRaiseNode raiseNode, CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode) {
            try {
                throw raiseNode.raise(inliningTarget, errType, format, arguments);
            }
            catch (PException p) {
                transformExceptionToNativeNode.execute(inliningTarget, p);
                return;
            }
        }

        @GenerateInline
        @GenerateUncached
        @GenerateCached(value=false)
        public static abstract class Lazy
        extends Node {
            public final PRaiseNativeNode get(Node inliningTarget) {
                return this.execute(inliningTarget);
            }

            abstract PRaiseNativeNode execute(Node var1);

            @Specialization
            static PRaiseNativeNode doIt(@Cached(inline=false) PRaiseNativeNode node) {
                return node;
            }
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class LookupNativeI64MemberFromBaseNode
    extends Node {
        public final long execute(Object cls, CFields nativeMemberName, HiddenAttr managedMemberName) {
            return this.execute(cls, nativeMemberName, managedMemberName, null);
        }

        public abstract long execute(Object var1, CFields var2, HiddenAttr var3, Function<PythonBuiltinClassType, Integer> var4);

        @Specialization
        static long doSingleContext(Object cls, CFields nativeMember, HiddenAttr managedMemberName, Function<PythonBuiltinClassType, Integer> builtinCallback, @Bind Node inliningTarget, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached HiddenAttr.ReadNode readAttrNode, @Cached CStructAccess.ReadI64Node getTypeMemberNode, @Cached PyNumberAsSizeNode asSizeNode) {
            long indexedSlotsSize;
            boolean isBasicsizeOrWeaklistoffset;
            CompilerAsserts.partialEvaluationConstant(builtinCallback);
            Object current = cls;
            boolean bl = isBasicsizeOrWeaklistoffset = nativeMember == CFields.PyTypeObject__tp_basicsize || nativeMember == CFields.PyTypeObject__tp_weaklistoffset;
            if (isBasicsizeOrWeaklistoffset && cls instanceof PythonManagedClass) {
                PythonManagedClass pmc = (PythonManagedClass)cls;
                v1 = (long)pmc.getIndexedSlotCount() * 8L;
            } else {
                v1 = indexedSlotsSize = 0L;
            }
            do {
                if (current instanceof PythonBuiltinClassType) {
                    PythonBuiltinClassType pbct = (PythonBuiltinClassType)((Object)current);
                    current = PythonContext.get(inliningTarget).lookupType(pbct);
                }
                if (builtinCallback != null && current instanceof PythonBuiltinClass) {
                    PythonBuiltinClass builtinClass = (PythonBuiltinClass)current;
                    return ((Integer)builtinCallback.apply(builtinClass.getType())).intValue();
                }
                if (PGuards.isManagedClass(current)) {
                    Object attr = readAttrNode.execute(inliningTarget, (PythonObject)current, managedMemberName, null);
                    if (attr != null) {
                        return asSizeNode.executeExact(null, inliningTarget, attr);
                    }
                    if (indexedSlotsSize == 0L) continue;
                    break;
                }
                assert (PGuards.isNativeClass(current)) : "invalid class inheritance structure; expected native class";
                return getTypeMemberNode.readFromObj((PythonNativeClass)current, nativeMember);
            } while ((current = getBaseClassNode.execute(inliningTarget, current)) != null);
            return isBasicsizeOrWeaklistoffset ? indexedSlotsSize + (long)CStructs.PyObject.size() : 0L;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class PCallCapiFunction
    extends Node {
        public static Object callUncached(NativeCAPISymbol symbol, Object ... args) {
            return PCallCapiFunction.getUncached().execute(symbol, args);
        }

        public final Object call(NativeCAPISymbol symbol, Object ... args) {
            return this.execute(symbol, args);
        }

        protected abstract Object execute(NativeCAPISymbol var1, Object[] var2);

        @Specialization
        static Object doWithoutContext(NativeCAPISymbol symbol, Object[] args, @Bind Node inliningTarget, @CachedLibrary(limit="1") InteropLibrary interopLibrary, @Cached CExtCommonNodes.EnsureTruffleStringNode ensureTruffleStringNode) {
            try {
                PythonContext pythonContext = PythonContext.get(inliningTarget);
                if (!pythonContext.hasCApiContext()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    CApiContext.ensureCapiWasLoaded("call internal native GraalPy function");
                }
                Object callable = CApiContext.getNativeSymbol(inliningTarget, symbol);
                return ensureTruffleStringNode.execute(inliningTarget, interopLibrary.execute(callable, args));
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @NeverDefault
        public static PCallCapiFunction create() {
            return CExtNodesFactory.PCallCapiFunctionNodeGen.create();
        }

        public static PCallCapiFunction getUncached() {
            return CExtNodesFactory.PCallCapiFunctionNodeGen.getUncached();
        }
    }

    @ImportStatic(value={PythonUtils.class})
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    public static abstract class CastToNativeLongNode
    extends PNodeWithContext {
        public abstract long execute(Node var1, boolean var2);

        public abstract long execute(Node var1, byte var2);

        public abstract long execute(Node var1, int var2);

        public abstract long execute(Node var1, long var2);

        public abstract long execute(Node var1, double var2);

        public abstract Object execute(Node var1, Object var2);

        @Specialization(guards={"lengthNode.execute(value, TS_ENCODING) == 1"}, limit="1")
        static long doString(TruffleString value, @Cached(inline=false) TruffleString.CodePointAtIndexNode codepointAtIndexNode, @Cached(inline=false) TruffleString.CodePointLengthNode lengthNode) {
            return codepointAtIndexNode.execute((AbstractTruffleString)value, 0, PythonUtils.TS_ENCODING);
        }

        @Specialization
        static long doBoolean(boolean value) {
            return value ? 1L : 0L;
        }

        @Specialization
        static long doByte(byte value) {
            return value;
        }

        @Specialization
        static long doInt(int value) {
            return value;
        }

        @Specialization
        static long doLong(long value) {
            return value;
        }

        @Specialization
        static long doDouble(double value) {
            return (long)value;
        }

        @Specialization
        static long doPInt(PInt value) {
            return value.longValue();
        }

        @Specialization
        static long doPFloat(PFloat value) {
            return (long)value.getValue();
        }

        @Specialization
        static Object doPythonNativeVoidPtr(PythonNativeVoidPtr object) {
            return object.getPointerObject();
        }

        @Specialization(guards={"!object.isDouble()"})
        static long doLongNativeWrapper(PrimitiveNativeWrapper object) {
            return object.getLong();
        }

        @Specialization(guards={"object.isDouble()"})
        static long doDoubleNativeWrapper(PrimitiveNativeWrapper object) {
            return (long)object.getDouble();
        }

        @Specialization
        static Object run(Node inliningTarget, PythonNativeWrapper value, @Cached(inline=false) CastToNativeLongNode recursive) {
            return recursive.execute(inliningTarget, value.getDelegate());
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class AsNativeComplexNode
    extends PNodeWithContext {
        public abstract PComplex execute(Node var1, boolean var2);

        public abstract PComplex execute(Node var1, int var2);

        public abstract PComplex execute(Node var1, long var2);

        public abstract PComplex execute(Node var1, double var2);

        public abstract PComplex execute(Node var1, Object var2);

        @Specialization
        static PComplex doPComplex(PComplex value) {
            return value;
        }

        @Specialization
        static PComplex doBoolean(boolean value, @Bind PythonLanguage language) {
            return PFactory.createComplex(language, value ? 1.0 : 0.0, 0.0);
        }

        @Specialization
        static PComplex doInt(int value, @Bind PythonLanguage language) {
            return PFactory.createComplex(language, value, 0.0);
        }

        @Specialization
        static PComplex doLong(long value, @Bind PythonLanguage language) {
            return PFactory.createComplex(language, value, 0.0);
        }

        @Specialization
        PComplex doDouble(double value, @Bind PythonLanguage language) {
            return PFactory.createComplex(language, value, 0.0);
        }

        @Specialization
        static PComplex doPInt(PInt value, @Bind PythonLanguage language) {
            return PFactory.createComplex(language, value.doubleValue(), 0.0);
        }

        @Specialization
        static PComplex doPFloat(PFloat value, @Bind PythonLanguage language) {
            return PFactory.createComplex(language, value.getValue(), 0.0);
        }

        @Specialization(replaces={"doPComplex", "doBoolean", "doInt", "doLong", "doDouble", "doPInt", "doPFloat"})
        static PComplex runGeneric(Node inliningTarget, Object value, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached(inline=false) LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode callComplex, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            Object result = callComplex.executeObject(value, SpecialMethodNames.T___COMPLEX__);
            if (result != PNone.NO_VALUE) {
                if (result instanceof PComplex) {
                    return (PComplex)result;
                }
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.COMPLEX_RETURNED_NON_COMPLEX, value);
            }
            return PFactory.createComplex(language, asDoubleNode.execute(null, inliningTarget, value), 0.0);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PointerCompareNode
    extends Node {
        public abstract boolean execute(Node var1, RichCmpOp var2, Object var3, Object var4);

        @Specialization
        static boolean doGeneric(Node inliningTarget, RichCmpOp op, Object a, Object b, @Cached NormalizePtrNode normalizeA, @Cached NormalizePtrNode normalizeB, @CachedLibrary(limit="1") InteropLibrary interopLibrary) {
            CompilerAsserts.partialEvaluationConstant((Object)((Object)op));
            Object ptrA = normalizeA.execute(inliningTarget, a);
            Object ptrB = normalizeB.execute(inliningTarget, b);
            try {
                Object sym = CApiContext.getNativeSymbol(inliningTarget, NativeCAPISymbol.FUN_PTR_COMPARE);
                return (Integer)interopLibrary.execute(sym, new Object[]{ptrA, ptrB, op.asNative()}) != 0;
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @TypeSystemReference(value=PythonIntegerTypes.class)
        @GenerateInline
        @GenerateCached(value=false)
        @GenerateUncached
        static abstract class NormalizePtrNode
        extends Node {
            NormalizePtrNode() {
            }

            abstract Object execute(Node var1, Object var2);

            @Specialization
            static Object doLong(long l) {
                return l;
            }

            @Specialization
            static Object doLong(PythonNativeObject o) {
                return o.getPtr();
            }

            @Specialization
            static Object doLong(PythonNativeVoidPtr o) {
                return o.getNativePointer();
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class GetNativeClassNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, PythonAbstractNativeObject var2);

        @Specialization
        static Object getNativeClass(Node inliningTarget, PythonAbstractNativeObject object, @Cached(inline=false) CStructAccess.ReadObjectNode callGetObTypeNode, @Cached TypeNodes.ProfileClassNode classProfile) {
            return classProfile.profile(inliningTarget, callGetObTypeNode.readFromObj(object, CFields.PyObject__ob_type));
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class FromCharPointerNode
    extends Node {
        public final TruffleString execute(Object charPtr) {
            return this.execute(charPtr, true);
        }

        public static TruffleString executeUncached(Object charPtr) {
            return CExtNodesFactory.FromCharPointerNodeGen.getUncached().execute(charPtr);
        }

        public abstract TruffleString execute(Object var1, boolean var2);

        @Specialization
        static TruffleString doCStringWrapper(CArrayWrappers.CStringWrapper cStringWrapper, boolean copy) {
            return cStringWrapper.getString();
        }

        @Specialization
        static TruffleString doCByteArrayWrapper(CArrayWrappers.CByteArrayWrapper cByteArrayWrapper, boolean copy, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromBytes, @Cached.Shared(value="switchEncoding") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            CompilerAsserts.partialEvaluationConstant((boolean)copy);
            byte[] byteArray = cByteArrayWrapper.getByteArray();
            return switchEncodingNode.execute((AbstractTruffleString)fromBytes.execute(byteArray, 0, byteArray.length, TruffleString.Encoding.UTF_8, copy), PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"!isCArrayWrapper(charPtr)"}, limit="3")
        static TruffleString doPointer(Object charPtr, boolean copy, @Cached CStructAccess.ReadByteNode read, @CachedLibrary(value="charPtr") InteropLibrary lib, @Cached TruffleString.FromNativePointerNode fromNative, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromBytes, @Cached.Shared(value="switchEncoding") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            int length = 0;
            while (read.readArrayElement(charPtr, length) != 0) {
                ++length;
            }
            if (lib.isPointer(charPtr)) {
                return switchEncodingNode.execute((AbstractTruffleString)fromNative.execute(charPtr, 0, length, TruffleString.Encoding.UTF_8, copy), PythonUtils.TS_ENCODING);
            }
            byte[] result = read.readByteArray(charPtr, length);
            return switchEncodingNode.execute((AbstractTruffleString)fromBytes.execute(result, TruffleString.Encoding.UTF_8, false), PythonUtils.TS_ENCODING);
        }

        static boolean isCArrayWrapper(Object object) {
            return object instanceof CArrayWrappers.CArrayWrapper || object instanceof PySequenceArrayWrapper;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class AsCharPointerNode
    extends Node {
        public abstract Object execute(Object var1, boolean var2);

        public abstract Object execute(TruffleString var1, boolean var2);

        public final Object execute(Object obj) {
            return this.execute(obj, false);
        }

        @Specialization
        static Object doPString(PString str, boolean allocatePyMem, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached TruffleString.CopyToByteArrayNode toBytes, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncoding, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            TruffleString value = castToStringNode.execute(inliningTarget, str);
            byte[] bytes = toBytes.execute((AbstractTruffleString)switchEncoding.execute((AbstractTruffleString)value, TruffleString.Encoding.UTF_8), TruffleString.Encoding.UTF_8);
            Object mem = alloc.alloc(bytes.length + 1, allocatePyMem);
            write.writeByteArray(mem, bytes);
            return mem;
        }

        @Specialization
        static Object doString(TruffleString str, boolean allocatePyMem, @Cached.Shared @Cached TruffleString.CopyToByteArrayNode toBytes, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncoding, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            byte[] bytes = toBytes.execute((AbstractTruffleString)switchEncoding.execute((AbstractTruffleString)str, TruffleString.Encoding.UTF_8), TruffleString.Encoding.UTF_8);
            Object mem = alloc.alloc(bytes.length + 1, allocatePyMem);
            write.writeByteArray(mem, bytes);
            return mem;
        }

        @Specialization
        static Object doBytes(PBytes bytes, boolean allocatePyMem, @Bind Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ToByteArrayNode toBytesNode, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            return AsCharPointerNode.doByteArray(toBytesNode.execute(inliningTarget, bytes.getSequenceStorage()), allocatePyMem, alloc, write);
        }

        @Specialization
        static Object doBytes(PByteArray bytes, boolean allocatePyMem, @Bind Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ToByteArrayNode toBytesNode, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            return AsCharPointerNode.doByteArray(toBytesNode.execute(inliningTarget, bytes.getSequenceStorage()), allocatePyMem, alloc, write);
        }

        @Specialization
        static Object doByteArray(byte[] arr, boolean allocatePyMem, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            Object mem = alloc.alloc(arr.length + 1, allocatePyMem);
            write.writeByteArray(mem, arr);
            return mem;
        }

        public static AsCharPointerNode getUncached() {
            return CExtNodesFactory.AsCharPointerNodeGen.getUncached();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={CApiGuards.class})
    public static abstract class MaterializeDelegateNode
    extends Node {
        public abstract Object execute(Node var1, PythonNativeWrapper var2);

        @Specialization(guards={"!isMaterialized(object)", "object.isBool()"})
        static PInt doBoolNativeWrapper(Node inliningTarget, PrimitiveNativeWrapper object) {
            PythonContext core = PythonContext.get(inliningTarget);
            PInt materializedInt = object.getBool() ? core.getTrue() : core.getFalse();
            object.setMaterializedObject(materializedInt);
            if (materializedInt.getNativeWrapper() != null) {
                object.setNativePointer(materializedInt.getNativeWrapper().getNativePointer());
            } else {
                materializedInt.setNativeWrapper(object);
            }
            return materializedInt;
        }

        @Specialization(guards={"!isMaterialized(object)", "object.isInt()"})
        static PInt doIntNativeWrapper(PrimitiveNativeWrapper object, @Bind PythonLanguage language) {
            PInt materializedInt = PFactory.createInt(language, object.getInt());
            object.setMaterializedObject(materializedInt);
            materializedInt.setNativeWrapper(object);
            return materializedInt;
        }

        @Specialization(guards={"!isMaterialized(object)", "object.isLong()"})
        static PInt doLongNativeWrapper(PrimitiveNativeWrapper object, @Bind PythonLanguage language) {
            PInt materializedInt = PFactory.createInt(language, object.getLong());
            object.setMaterializedObject(materializedInt);
            materializedInt.setNativeWrapper(object);
            return materializedInt;
        }

        @Specialization(guards={"!isMaterialized(object)", "object.isDouble()", "!isNaN(object)"})
        static PFloat doDoubleNativeWrapper(PrimitiveNativeWrapper object, @Bind PythonLanguage language) {
            PFloat materializedInt = PFactory.createFloat(language, object.getDouble());
            materializedInt.setNativeWrapper(object);
            object.setMaterializedObject(materializedInt);
            return materializedInt;
        }

        @Specialization(guards={"!isMaterialized(object)", "object.isDouble()", "isNaN(object)"})
        static PFloat doDoubleNativeWrapperNaN(Node inliningTarget, PrimitiveNativeWrapper object) {
            PFloat materializedFloat = PythonContext.get(inliningTarget).getNaN();
            object.setMaterializedObject(materializedFloat);
            if (materializedFloat.getNativeWrapper() != null) {
                object.setNativePointer(materializedFloat.getNativeWrapper().getNativePointer());
            } else {
                materializedFloat.setNativeWrapper(object);
            }
            return materializedFloat;
        }

        @Specialization(guards={"isMaterialized(object)"})
        static Object doMaterialized(PrimitiveNativeWrapper object) {
            return object.getDelegate();
        }

        @Specialization(guards={"!isPrimitiveNativeWrapper(object)"})
        static Object doNativeWrapperGeneric(PythonNativeWrapper object) {
            return object.getDelegate();
        }

        protected static boolean isPrimitiveNativeWrapper(PythonNativeWrapper object) {
            return object instanceof PrimitiveNativeWrapper;
        }

        protected static boolean isNaN(PrimitiveNativeWrapper object) {
            assert (object.isDouble());
            return Double.isNaN(object.getDouble());
        }

        static boolean isMaterialized(PrimitiveNativeWrapper wrapper) {
            return wrapper.getDelegate() != null;
        }
    }

    @GenerateInline(value=false)
    public static abstract class FromNativeSubclassNode
    extends Node {
        public abstract Double execute(VirtualFrame var1, PythonAbstractNativeObject var2);

        @Specialization
        static Double doDouble(PythonAbstractNativeObject object, @Bind Node inliningTarget, @Cached GetClassNode.GetPythonObjectClassNode getClass, @Cached IsSubtypeNode isSubtype, @Cached CStructAccess.ReadDoubleNode read) {
            if (FromNativeSubclassNode.isFloatSubtype(inliningTarget, object, getClass, isSubtype)) {
                return read.readFromObj(object, CFields.PyFloatObject__ob_fval);
            }
            return null;
        }

        public static boolean isFloatSubtype(Node inliningTarget, Object object, GetClassNode getClass, IsSubtypeNode isSubtype) {
            return isSubtype.execute(getClass.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PFloat);
        }

        public static boolean isFloatSubtype(Node inliningTarget, PythonAbstractNativeObject object, GetClassNode.GetPythonObjectClassNode getClass, IsSubtypeNode isSubtype) {
            return isSubtype.execute(getClass.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PFloat);
        }

        @NeverDefault
        public static FromNativeSubclassNode create() {
            return CExtNodesFactory.FromNativeSubclassNodeGen.create();
        }
    }

    public static abstract class StringSubtypeNew
    extends SubtypeNew {
        @Node.Child
        private CApiTransitions.PythonToNativeNode toNativeNode;

        @Override
        protected final NativeCAPISymbol getFunction() {
            return NativeCAPISymbol.FUN_UNICODE_SUBTYPE_NEW;
        }

        public final Object call(Object object, Object arg) {
            if (this.toNativeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNativeNode = (CApiTransitions.PythonToNativeNode)this.insert(CApiTransitionsFactory.PythonToNativeNodeGen.create());
            }
            return this.execute(object, this.toNativeNode.execute(arg));
        }

        public static StringSubtypeNew create() {
            return CExtNodesFactory.StringSubtypeNewNodeGen.create();
        }
    }

    public static abstract class TupleSubtypeNew
    extends SubtypeNew {
        @Node.Child
        private CApiTransitions.PythonToNativeNode toNativeNode;

        @Override
        protected final NativeCAPISymbol getFunction() {
            return NativeCAPISymbol.FUN_TUPLE_SUBTYPE_NEW;
        }

        public final Object call(Object object, Object arg) {
            if (this.toNativeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNativeNode = (CApiTransitions.PythonToNativeNode)this.insert(CApiTransitionsFactory.PythonToNativeNodeGen.create());
            }
            return this.execute(object, this.toNativeNode.execute(arg));
        }

        @NeverDefault
        public static TupleSubtypeNew create() {
            return CExtNodesFactory.TupleSubtypeNewNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class FloatSubtypeNew
    extends SubtypeNew {
        @Override
        protected final NativeCAPISymbol getFunction() {
            return NativeCAPISymbol.FUN_FLOAT_SUBTYPE_NEW;
        }

        public final Object call(Object object, double arg) {
            return this.execute(object, arg);
        }

        public static FloatSubtypeNew create() {
            return CExtNodesFactory.FloatSubtypeNewNodeGen.create();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline(value=false)
    public static abstract class SubtypeNew
    extends Node {
        protected NativeCAPISymbol getFunction() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        protected abstract Object execute(Object var1, Object var2);

        @Specialization
        Object callNativeConstructor(Object object, Object arg, @Bind Node inliningTarget, @Cached CApiTransitions.PythonToNativeNode toSulongNode, @Cached CApiTransitions.NativeToPythonTransferNode toJavaNode, @CachedLibrary(limit="1") InteropLibrary interopLibrary) {
            assert (TypeNodes.NeedsNativeAllocationNode.executeUncached(object));
            try {
                Object callable = CApiContext.getNativeSymbol(inliningTarget, this.getFunction());
                Object result = interopLibrary.execute(callable, new Object[]{toSulongNode.execute(object), arg});
                return toJavaNode.execute(result);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"C subtype_new function failed", (Throwable)e);
            }
        }
    }
}

