/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecUtil;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteDecodeBuffer;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalDecoderBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamReaderBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamReaderBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamReaderBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamReaderObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.MultibyteStreamReader})
public final class MultibyteStreamReaderBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = MultibyteStreamReaderBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MultibyteStreamReaderBuiltinsFactory.getFactories();
    }

    @Builtin(name="stream", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StreamMemberNode
    extends PythonUnaryBuiltinNode {
        StreamMemberNode() {
        }

        @Specialization
        static Object stream(MultibyteStreamReaderObject self) {
            return self.stream;
        }
    }

    @Builtin(name="reset", minNumOfPositionalArgs=1, parameterNames={"$self"}, doc="reset($self, /)\n--\n\n")
    @GenerateNodeFactory
    static abstract class ResetNode
    extends PythonUnaryBuiltinNode {
        ResetNode() {
        }

        @Specialization
        static Object reset(MultibyteStreamReaderObject self) {
            self.codec.decreset(self.state);
            self.pendingsize = 0;
            return PNone.NONE;
        }
    }

    @Builtin(name="readlines", minNumOfPositionalArgs=1, parameterNames={"$self", "sizehintobj"}, doc="readlines($self, sizehintobj=None, /)\n--\n\n")
    @ArgumentClinic(name="sizehintobj", conversion=ArgumentClinic.ClinicConversion.Long, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadlinesNode
    extends PythonBinaryClinicBuiltinNode {
        ReadlinesNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultibyteStreamReaderBuiltinsClinicProviders.ReadlinesNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object readlines(VirtualFrame frame, MultibyteStreamReaderObject self, long sizehint, @Cached StringBuiltins.SplitLinesNode splitLinesNode, @Cached IReadNode iReadNode) {
            TruffleString r = iReadNode.execute(frame, self, StringLiterals.T_READ, sizehint);
            return splitLinesNode.execute(frame, r, true);
        }
    }

    @Builtin(name="readline", minNumOfPositionalArgs=1, parameterNames={"$self", "sizeobj"}, doc="readline($self, sizeobj=None, /)\n--\n\n")
    @ArgumentClinic(name="sizeobj", conversion=ArgumentClinic.ClinicConversion.Long, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadlineNode
    extends PythonBinaryClinicBuiltinNode {
        ReadlineNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultibyteStreamReaderBuiltinsClinicProviders.ReadlineNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object readline(VirtualFrame frame, MultibyteStreamReaderObject self, long size, @Cached IReadNode iReadNode) {
            return iReadNode.execute(frame, self, StringLiterals.T_READLINE, size);
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, parameterNames={"$self", "sizeobj"}, doc="read($self, sizeobj=None, /)\n--\n\n")
    @ArgumentClinic(name="sizeobj", conversion=ArgumentClinic.ClinicConversion.Long, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends PythonBinaryClinicBuiltinNode {
        ReadNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultibyteStreamReaderBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object read(VirtualFrame frame, MultibyteStreamReaderObject self, long size, @Cached IReadNode iReadNode) {
            return iReadNode.execute(frame, self, StringLiterals.T_READ, size);
        }
    }

    @GenerateInline(value=false)
    static abstract class IReadNode
    extends PNodeWithContext {
        IReadNode() {
        }

        abstract TruffleString execute(VirtualFrame var1, MultibyteStreamReaderObject var2, TruffleString var3, long var4);

        @Specialization
        static TruffleString iread(VirtualFrame frame, MultibyteStreamReaderObject self, TruffleString method, long sizehint, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PyBytesCheckNode bytesCheckNode, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached MultibyteCodecUtil.DecodeErrorNode decodeErrorNode, @Cached PRaiseNode raiseNode) {
            if (sizehint == 0L) {
                return StringLiterals.T_EMPTY_STRING;
            }
            MultibyteDecodeBuffer buf = null;
            while (true) {
                Object cres;
                if (!((cres = sizehint < 0L ? callMethod.execute((Frame)frame, inliningTarget, self.stream, method, new Object[0]) : callMethod.execute((Frame)frame, inliningTarget, self.stream, method, sizehint)) instanceof PBytes) && !bytesCheckNode.execute(inliningTarget, cres)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.STREAM_FUNCTION_RETURNED_A_NON_BYTES_OBJECT_P, cres);
                }
                byte[] cresBytes = toBytesNode.execute(frame, cres);
                int cresBytesLen = cresBytes.length;
                boolean endoffile = cresBytesLen == 0;
                int rsize = cresBytesLen;
                if (self.pendingsize > 0) {
                    byte[] ctr = new byte[rsize += self.pendingsize];
                    PythonUtils.arraycopy(self.pending, 0, ctr, 0, self.pendingsize);
                    PythonUtils.arraycopy(cresBytes, 0, ctr, self.pendingsize, cresBytesLen);
                    cresBytes = ctr;
                    self.pendingsize = 0;
                }
                if (buf == null) {
                    buf = new MultibyteDecodeBuffer(cresBytes);
                } else {
                    buf.replaceInbuf(cresBytes);
                }
                if (rsize > 0) {
                    MultibyteIncrementalDecoderBuiltins.DecodeNode.decoderFeedBuffer(frame, self, buf, decodeErrorNode, inliningTarget);
                }
                if ((endoffile || sizehint < 0L) && !buf.isFull()) {
                    decodeErrorNode.execute(frame, self.codec, buf, self.errors, -2);
                }
                if (!buf.isFull()) {
                    MultibyteIncrementalDecoderBuiltins.DecodeNode.decoderAppendPending(inliningTarget, self, buf, raiseNode);
                }
                if (sizehint < 0L || buf.getOutpos() != 0 || rsize == 0) break;
                sizehint = 1L;
            }
            return buf.toTString();
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="MultibyteStreamReader", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        PNone init(MultibyteStreamReaderObject self) {
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=2, parameterNames={"$cls", "stream", "errors"})
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends PythonTernaryBuiltinNode {
        protected NewNode() {
        }

        @Specialization
        static Object mbstreamreaderNew(VirtualFrame frame, Object type, Object stream, Object err, @Bind Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached PyObjectGetAttr getAttr, @Cached TruffleString.EqualNode isEqual, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            TruffleString errors = null;
            if (err != PNone.NO_VALUE) {
                errors = castToStringNode.execute(inliningTarget, err);
            }
            MultibyteStreamReaderObject self = PFactory.createMultibyteStreamReaderObject(language, type, getInstanceShape.execute(type));
            Object codec = getAttr.execute((Frame)frame, inliningTarget, type, StringLiterals.T_CODEC);
            if (!(codec instanceof MultibyteCodecObject)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CODEC_IS_UNEXPECTED_TYPE);
            }
            self.codec = ((MultibyteCodecObject)codec).codec;
            self.stream = stream;
            self.pendingsize = 0;
            self.errors = MultibyteCodecUtil.internalErrorCallback(errors, isEqual);
            self.state = self.codec.decinit(self.errors);
            return self;
        }
    }
}

