/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.schema;

import schemacrawler.tools.command.text.schema.SchemaTextRenderer;
import schemacrawler.tools.command.text.schema.options.CommandProviderUtility;
import schemacrawler.tools.command.text.schema.options.PortableType;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptions;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptionsBuilder;
import schemacrawler.tools.command.text.schema.options.TextOutputFormat;
import schemacrawler.tools.executable.BaseCommandProvider;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import us.fatehi.utility.property.PropertyName;

public final class SchemaTextCommandProvider
extends BaseCommandProvider {
    public SchemaTextCommandProvider() {
        super(CommandProviderUtility.schemaTextCommands());
    }

    public PluginCommand getCommandLineCommand() {
        PluginCommand pluginCommand = PluginCommand.newPluginCommand((PropertyName)SchemaTextDetailType.schema.toPropertyName(), () -> new String[]{"Applies to all commands that show schema information"}, () -> new String[0]);
        pluginCommand.addOption("no-info", Boolean.class, new String[]{"Hide or show SchemaCrawler header and database information", "--no-info=<boolean>", "<boolean> can be true or false", "Optional, defaults to false"}).addOption("no-remarks", Boolean.class, new String[]{"Hide or show table and column remarks", "--no-remarks=<boolean>", "<boolean> can be true or false", "Optional, defaults to false"}).addOption("portable", PortableType.class, new String[]{"Allow for easy comparison between databases, by hiding or showing foreign key names, constraint names, trigger names, specific names for routines, or index and primary key names, and fully-qualified table names", "<portable> is one of ${COMPLETION-CANDIDATES}", "Optional, defaults to none"}).addOption("sort-columns", Boolean.class, new String[]{"Sort columns in a table alphabetically", "--sort-columns=<sortcolumns>", "<sortcolumns> can be true or false", "Optional, defaults to false"}).addOption("sort-tables", Boolean.class, new String[]{"Sort tables alphabetically", "--sort-tables=<sorttables>", "<sorttables> can be true or false", "Optional, defaults to true"}).addOption("sort-routines", Boolean.class, new String[]{"Sort routines alphabetically", "--sort-routines=<sortroutines>", "<sortroutines> can be true or false", "Optional, defaults to true"});
        return pluginCommand;
    }

    public SchemaTextRenderer newSchemaCrawlerCommand(String command, Config config) {
        PropertyName commandName = this.lookupSupportedCommand(command);
        if (commandName == null) {
            throw new IllegalArgumentException("Cannot support command, " + command);
        }
        SchemaTextOptions schemaTextOptions = ((SchemaTextOptionsBuilder)SchemaTextOptionsBuilder.builder().fromConfig(config)).toOptions();
        SchemaTextRenderer scCommand = new SchemaTextRenderer(commandName);
        scCommand.configure(schemaTextOptions);
        return scCommand;
    }

    public boolean supportsOutputFormat(String command, OutputOptions outputOptions) {
        return this.supportsOutputFormat(command, outputOptions, TextOutputFormat::isSupportedFormat);
    }
}

