/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.util.Properties;
import org.postgresql.PGProperty;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.internal.Nullness;

enum ChannelBinding {
    DISABLE,
    PREFER,
    REQUIRE;


    public static ChannelBinding of(Properties info) throws PSQLException {
        String option;
        switch (option = Nullness.castNonNull(PGProperty.CHANNEL_BINDING.getOrDefault(info))) {
            case "disable": {
                return DISABLE;
            }
            case "prefer": {
                return PREFER;
            }
            case "require": {
                return REQUIRE;
            }
        }
        throw new PSQLException(GT.tr("Invalid channelBinding value: {0}", option), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }
}

