/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jaybird.Version;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBPreparedStatement;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FirebirdDatabaseMetaData;
import org.firebirdsql.jdbc.FirebirdVersionMetaData;
import org.firebirdsql.jdbc.InternalTransactionCoordinator;
import org.firebirdsql.jdbc.escape.FBEscapedFunctionHelper;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.GetAttributes;
import org.firebirdsql.jdbc.metadata.GetBestRowIdentifier;
import org.firebirdsql.jdbc.metadata.GetCatalogs;
import org.firebirdsql.jdbc.metadata.GetClientInfoProperties;
import org.firebirdsql.jdbc.metadata.GetColumnPrivileges;
import org.firebirdsql.jdbc.metadata.GetColumns;
import org.firebirdsql.jdbc.metadata.GetCrossReference;
import org.firebirdsql.jdbc.metadata.GetExportedKeys;
import org.firebirdsql.jdbc.metadata.GetFunctionColumns;
import org.firebirdsql.jdbc.metadata.GetFunctions;
import org.firebirdsql.jdbc.metadata.GetImportedKeys;
import org.firebirdsql.jdbc.metadata.GetIndexInfo;
import org.firebirdsql.jdbc.metadata.GetPrimaryKeys;
import org.firebirdsql.jdbc.metadata.GetProcedureColumns;
import org.firebirdsql.jdbc.metadata.GetProcedures;
import org.firebirdsql.jdbc.metadata.GetPseudoColumns;
import org.firebirdsql.jdbc.metadata.GetSchemas;
import org.firebirdsql.jdbc.metadata.GetSuperTables;
import org.firebirdsql.jdbc.metadata.GetSuperTypes;
import org.firebirdsql.jdbc.metadata.GetTablePrivileges;
import org.firebirdsql.jdbc.metadata.GetTables;
import org.firebirdsql.jdbc.metadata.GetTypeInfo;
import org.firebirdsql.jdbc.metadata.GetUDTs;
import org.firebirdsql.jdbc.metadata.GetVersionColumns;
import org.firebirdsql.jdbc.metadata.MetadataPattern;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.FirebirdSupportInfo;

public class FBDatabaseMetaData
implements FirebirdDatabaseMetaData {
    private static final Logger log;
    private final GDSHelper gdsHelper;
    private final FBConnection connection;
    private final FirebirdSupportInfo firebirdSupportInfo;
    private static final int STATEMENT_CACHE_SIZE = 12;
    private final Map<String, FBPreparedStatement> statements = new LruPreparedStatementCache(12);
    private final FirebirdVersionMetaData versionMetaData;
    public static final String TABLE = "TABLE";
    public static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String VIEW = "VIEW";
    public static final String GLOBAL_TEMPORARY = "GLOBAL TEMPORARY";
    static final int JDBC_MAJOR_VERSION = 4;
    static final int JDBC_MINOR_VERSION;

    protected FBDatabaseMetaData(FBConnection c) throws SQLException {
        this.gdsHelper = c.getGDSHelper();
        this.connection = c;
        this.firebirdSupportInfo = FirebirdSupportInfo.supportInfoFor(c);
        this.versionMetaData = FirebirdVersionMetaData.getVersionMetaDataFor(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try (LockCloseable ignored = this.connection.withLock();){
            if (this.statements.isEmpty()) {
                return;
            }
            try {
                for (FBStatement fBStatement : this.statements.values()) {
                    try {
                        fBStatement.close();
                    }
                    catch (Exception e) {
                        log.warnDebug("error closing cached statements in DatabaseMetaData.close", e);
                    }
                }
            }
            finally {
                this.statements.clear();
            }
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        GDSType gdsType = this.getGDSType();
        return GDSFactory.getJdbcUrl(gdsType, this.gdsHelper.getConnectionProperties());
    }

    private GDSType getGDSType() {
        return this.connection.mc.getManagedConnectionFactory().getGDSType();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.gdsHelper.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.gdsHelper.compareToVersion(2, 0) >= 0;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.gdsHelper.compareToVersion(2, 0) < 0;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.gdsHelper.getDatabaseProductName();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.gdsHelper.getDatabaseProductVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Jaybird JCA/JDBC driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return Version.JAYBIRD_SIMPLE_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return Version.JAYBIRD_MAJOR_VERSION;
    }

    @Override
    public int getDriverMinorVersion() {
        return Version.JAYBIRD_MINOR_VERSION;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.getConnectionDialect() == 1 ? " " : "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.versionMetaData.getSqlKeywords();
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return FBDatabaseMetaData.collectionToCommaSeparatedList(FBEscapedFunctionHelper.getSupportedNumericFunctions());
    }

    private static String collectionToCommaSeparatedList(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        for (String item : collection) {
            sb.append(item);
            sb.append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return FBDatabaseMetaData.collectionToCommaSeparatedList(FBEscapedFunctionHelper.getSupportedStringFunctions());
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return FBDatabaseMetaData.collectionToCommaSeparatedList(FBEscapedFunctionHelper.getSupportedSystemFunctions());
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return FBDatabaseMetaData.collectionToCommaSeparatedList(FBEscapedFunctionHelper.getSupportedTimeDateFunctions());
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "$";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        switch (fromType) {
            case -6001: {
                if (!this.firebirdSupportInfo.supportsDecfloat()) {
                    return false;
                }
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (toType) {
                    case -16: 
                    case -15: 
                    case -9: 
                    case -6: 
                    case -5: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        return true;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        return true;
                    }
                    case -6001: {
                        return this.firebirdSupportInfo.supportsDecfloat();
                    }
                }
                return false;
            }
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: 
            case 2011: {
                switch (toType) {
                    case -16: 
                    case -15: 
                    case -9: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2004: 
                    case 2005: 
                    case 2011: {
                        return true;
                    }
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return fromType != -8;
                    }
                    case -6001: {
                        return fromType != -8 && this.firebirdSupportInfo.supportsDecfloat();
                    }
                    case 16: {
                        return fromType != -8 && this.firebirdSupportInfo.supportsBoolean();
                    }
                    case -8: {
                        return false;
                    }
                    case 2013: 
                    case 2014: {
                        return fromType != -8 && this.firebirdSupportInfo.supportsTimeZones();
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case 91: 
                    case 93: {
                        return true;
                    }
                    case 92: 
                    case 2013: {
                        return false;
                    }
                    case 2014: {
                        return this.firebirdSupportInfo.supportsTimeZones();
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        return true;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (toType) {
                    case 92: 
                    case 93: {
                        return true;
                    }
                    case 91: {
                        return false;
                    }
                    case 2013: 
                    case 2014: {
                        return this.firebirdSupportInfo.supportsTimeZones();
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        return true;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (toType) {
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                    case 2013: 
                    case 2014: {
                        return this.firebirdSupportInfo.supportsTimeZones();
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        return true;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                return toType != 0 && this.supportsConvert(toType, toType);
            }
            case 16: {
                if (this.firebirdSupportInfo.supportsBoolean()) {
                    switch (toType) {
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 16: 
                        case 2005: 
                        case 2011: {
                            return true;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case 2013: {
                if (this.firebirdSupportInfo.supportsTimeZones()) {
                    switch (toType) {
                        case 92: 
                        case 93: {
                            return true;
                        }
                        case 91: {
                            return false;
                        }
                        case 2013: 
                        case 2014: {
                            return true;
                        }
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: 
                        case 2011: {
                            return true;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case 2014: {
                if (this.firebirdSupportInfo.supportsTimeZones()) {
                    switch (toType) {
                        case 91: 
                        case 92: 
                        case 93: 
                        case 2013: 
                        case 2014: {
                            return true;
                        }
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: 
                        case 2011: {
                            return true;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case 2003: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.firebirdSupportInfo.isVersionEqualOrAbove(1, 5);
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "PROCEDURE";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return null;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 32765;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getMaxObjectNameLength();
    }

    private int getMaxObjectNameLength() {
        if (this.gdsHelper.compareToVersion(4, 0) < 0) {
            return 31;
        }
        return 63;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 31;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        if (this.gdsHelper.compareToVersion(2, 0) < 0) {
            return 252;
        }
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMaxObjectNameLength();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        if (this.gdsHelper.compareToVersion(1, 5) >= 0) {
            return 65531;
        }
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        if (this.gdsHelper.compareToVersion(3, 0) >= 0) {
            return 0xA00000;
        }
        return 65536;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getMaxObjectNameLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getMaxObjectNameLength();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return GetProcedures.create(this.getDbMetadataMediator()).getProcedures(procedureNamePattern);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return GetProcedureColumns.create(this.getDbMetadataMediator()).getProcedureColumns(procedureNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return this.createGetTablesInstance().getTables(tableNamePattern, types);
    }

    private GetTables createGetTablesInstance() {
        return GetTables.create(this.getDbMetadataMediator());
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return GetCatalogs.create(this.getDbMetadataMediator()).getCatalogs();
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.createGetTablesInstance().getTableTypes();
    }

    @Override
    public String[] getTableTypeNames() throws SQLException {
        return this.createGetTablesInstance().getTableTypeNames();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return GetColumns.create(this.getDbMetadataMediator()).getColumns(tableNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return GetColumnPrivileges.create(this.getDbMetadataMediator()).getColumnPrivileges(table, columnNamePattern);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return GetTablePrivileges.create(this.getDbMetadataMediator()).getTablePrivileges(tableNamePattern);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return GetBestRowIdentifier.create(this.getDbMetadataMediator()).getBestRowIdentifier(catalog, schema, table, scope, nullable);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return GetVersionColumns.create(this.getDbMetadataMediator()).getVersionColumns(catalog, schema, table);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return GetPrimaryKeys.create(this.getDbMetadataMediator()).getPrimaryKeys(table);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return GetImportedKeys.create(this.getDbMetadataMediator()).getImportedKeys(table);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return GetExportedKeys.create(this.getDbMetadataMediator()).getExportedKeys(table);
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return GetCrossReference.create(this.getDbMetadataMediator()).getCrossReference(primaryTable, foreignTable);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return GetTypeInfo.create(this.getDbMetadataMediator()).getTypeInfo();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return GetIndexInfo.create(this.getDbMetadataMediator()).getIndexInfo(table, unique, approximate);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                return concurrency == 1007 || concurrency == 1008;
            }
        }
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return 1004 == type || 1005 == type;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return 1004 == type || 1005 == type;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return 1004 == type || 1005 == type;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return GetUDTs.create(this.getDbMetadataMediator()).getUDTs();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return GetAttributes.create(this.getDbMetadataMediator()).getAttributes();
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return this.firebirdSupportInfo.supportsSavepoint();
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return this.firebirdSupportInfo.supportsInsertReturning() && this.connection.getGeneratedKeysSupport().supportsGetGeneratedKeys();
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return GetSuperTypes.create(this.getDbMetadataMediator()).getSuperTypes();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return GetSuperTables.create(this.getDbMetadataMediator()).getSuperTables();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 2 || holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.gdsHelper.getDatabaseProductMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.gdsHelper.getDatabaseProductMinorVersion();
    }

    @Override
    public int getOdsMajorVersion() {
        return this.gdsHelper.getCurrentDatabase().getOdsMajor();
    }

    @Override
    public int getOdsMinorVersion() {
        return this.gdsHelper.getCurrentDatabase().getOdsMinor();
    }

    @Override
    public int getDatabaseDialect() throws SQLException {
        return this.gdsHelper.getCurrentDatabase().getDatabaseDialect();
    }

    @Override
    public int getConnectionDialect() throws SQLException {
        return this.gdsHelper.getCurrentDatabase().getConnectionDialect();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return GetClientInfoProperties.create(this.getDbMetadataMediator()).getClientInfoProperties();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return GetFunctionColumns.create(this.getDbMetadataMediator()).getFunctionColumns(functionNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return GetFunctions.create(this.getDbMetadataMediator()).getFunctions(functionNamePattern);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return GetSchemas.create(this.getDbMetadataMediator()).getSchemas(schemaPattern);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(FBDatabaseMetaData.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Unable to unwrap to class " + iface.getName());
        }
        return iface.cast(this);
    }

    public static String escapeWildcards(String objectName) {
        return MetadataPattern.escapeWildcards(objectName);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return GetPseudoColumns.create(this.getDbMetadataMediator()).getPseudoColumns(tableNamePattern, columnNamePattern);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public String getProcedureSourceCode(String procedureName) throws SQLException {
        String sResult = null;
        String sql = "Select RDB$PROCEDURE_SOURCE From RDB$PROCEDURES Where RDB$PROCEDURE_NAME = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(procedureName);
        try (ResultSet rs = this.doQuery(sql, params);){
            if (rs.next()) {
                sResult = rs.getString(1);
            }
        }
        return sResult;
    }

    @Override
    public String getTriggerSourceCode(String triggerName) throws SQLException {
        String sResult = null;
        String sql = "Select RDB$TRIGGER_SOURCE From RDB$TRIGGERS Where RDB$TRIGGER_NAME = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(triggerName);
        try (ResultSet rs = this.doQuery(sql, params);){
            if (rs.next()) {
                sResult = rs.getString(1);
            }
        }
        return sResult;
    }

    @Override
    public String getViewSourceCode(String viewName) throws SQLException {
        String sResult = null;
        String sql = "Select RDB$VIEW_SOURCE From RDB$RELATIONS Where RDB$RELATION_NAME = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(viewName);
        try (ResultSet rs = this.doQuery(sql, params);){
            if (rs.next()) {
                sResult = rs.getString(1);
            }
        }
        return sResult;
    }

    protected static byte[] getBytes(String value) {
        return value != null ? value.getBytes(StandardCharsets.UTF_8) : null;
    }

    private FBPreparedStatement getStatement(String sql, boolean standalone) throws SQLException {
        try (LockCloseable ignored = this.connection.withLock();){
            FBPreparedStatement cachedStatement;
            if (!standalone && (cachedStatement = this.statements.get(sql)) != null) {
                if (cachedStatement.isClosed()) {
                    this.statements.remove(sql);
                } else {
                    FBPreparedStatement fBPreparedStatement = cachedStatement;
                    return fBPreparedStatement;
                }
            }
            InternalTransactionCoordinator.MetaDataTransactionCoordinator metaDataTransactionCoordinator = new InternalTransactionCoordinator.MetaDataTransactionCoordinator(this.connection.txCoordinator);
            FBPreparedStatement newStatement = new FBPreparedStatement(this.gdsHelper, sql, 1004, 1007, 2, metaDataTransactionCoordinator, metaDataTransactionCoordinator, true, standalone, false);
            if (!standalone) {
                this.statements.put(sql, newStatement);
            }
            FBPreparedStatement fBPreparedStatement = newStatement;
            return fBPreparedStatement;
        }
    }

    protected ResultSet doQuery(String sql, List<String> params) throws SQLException {
        return this.doQuery(sql, params, false);
    }

    protected ResultSet doQuery(String sql, List<String> params, boolean standalone) throws SQLException {
        FBPreparedStatement s = this.getStatement(sql, standalone);
        for (int i = 0; i < params.size(); ++i) {
            s.setString(i + 1, params.get(i));
        }
        return s.executeMetaDataQuery();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_VALID_TRANSACTION;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return JDBC_MINOR_VERSION;
    }

    private static String getSystemPropertyPrivileged(String propertyName) {
        return AccessController.doPrivileged(() -> System.getProperty(propertyName));
    }

    protected DbMetadataMediator getDbMetadataMediator() {
        return new DbMetadataMediatorImpl();
    }

    static {
        int tempVersion;
        block5: {
            log = LoggerFactory.getLogger(FBDatabaseMetaData.class);
            try {
                int javaVersionMajor;
                String javaImplementation = FBDatabaseMetaData.getSystemPropertyPrivileged("java.specification.version");
                if (javaImplementation == null) {
                    tempVersion = 3;
                    break block5;
                }
                try {
                    javaVersionMajor = (int)Double.parseDouble(javaImplementation);
                }
                catch (NumberFormatException e) {
                    javaVersionMajor = 1;
                }
                tempVersion = javaVersionMajor >= 9 ? 3 : 2;
            }
            catch (RuntimeException ex) {
                tempVersion = 3;
            }
        }
        JDBC_MINOR_VERSION = tempVersion;
    }

    private class DbMetadataMediatorImpl
    extends DbMetadataMediator {
        private DbMetadataMediatorImpl() {
        }

        @Override
        protected FirebirdSupportInfo getFirebirdSupportInfo() {
            return FBDatabaseMetaData.this.firebirdSupportInfo;
        }

        @Override
        protected ResultSet performMetaDataQuery(DbMetadataMediator.MetadataQuery metadataQuery) throws SQLException {
            return FBDatabaseMetaData.this.doQuery(metadataQuery.getQueryText(), metadataQuery.getParameters(), metadataQuery.isStandalone());
        }

        @Override
        protected FBDatabaseMetaData getMetaData() {
            return FBDatabaseMetaData.this;
        }

        @Override
        protected GDSType getGDSType() {
            return FBDatabaseMetaData.this.getGDSType();
        }

        @Override
        protected int getOdsMajorVersion() {
            return FBDatabaseMetaData.this.getOdsMajorVersion();
        }

        @Override
        protected int getOdsMinorVersion() {
            return FBDatabaseMetaData.this.getOdsMinorVersion();
        }
    }

    private static class LruPreparedStatementCache
    extends LinkedHashMap<String, FBPreparedStatement> {
        private static final long serialVersionUID = -6600678461169652270L;
        private final int maxCapacity;

        private LruPreparedStatementCache(int maxCapacity) {
            super(16, 0.75f, true);
            this.maxCapacity = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, FBPreparedStatement> eldest) {
            if (this.size() <= this.maxCapacity) {
                return false;
            }
            try {
                FBPreparedStatement statement = eldest.getValue();
                statement.close();
            }
            catch (Exception e) {
                log.debug("Closing eldest cached metadata statement yielded an exception; ignored", e);
            }
            return true;
        }
    }
}

