/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.TransactionState;

public class TransactionHelper {
    public static final String NO_TRANSACTION_ACTIVE = "No transaction or transaction not ACTIVE";

    private TransactionHelper() {
    }

    public static void checkTransactionActive(FbTransaction transaction) throws SQLException {
        if (transaction == null || transaction.getState() != TransactionState.ACTIVE) {
            throw new SQLNonTransientException(NO_TRANSACTION_ACTIVE, "25000");
        }
    }

    public static void checkTransactionActive(FbTransaction transaction, int fbErrorCode) throws SQLException {
        if (transaction == null || transaction.getState() != TransactionState.ACTIVE) {
            throw new FbExceptionBuilder().nonTransientException(fbErrorCode).toSQLException();
        }
    }
}

