/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.util.Collection;
import org.firebirdsql.gds.BatchParameterBuffer;
import org.firebirdsql.gds.ng.BatchCompletion;
import org.firebirdsql.gds.ng.CursorFlag;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.FbBatchConfig;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.FetchType;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.SqlCountHolder;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.ExceptionListenable;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jdbc.FBDriverNotCapableException;

public interface FbStatement
extends ExceptionListenable,
AutoCloseable {
    public FbTransaction getTransaction();

    public FbDatabase getDatabase();

    public void setTransaction(FbTransaction var1) throws SQLException;

    public RowDescriptor getParameterDescriptor();

    public RowDescriptor getRowDescriptor();

    public StatementType getType();

    public StatementState getState();

    public int getHandle();

    @Override
    public void close() throws SQLException;

    public void closeCursor() throws SQLException;

    public void closeCursor(boolean var1) throws SQLException;

    public void prepare(String var1) throws SQLException;

    public void unprepare() throws SQLException;

    public void validateParameters(RowValue var1) throws SQLException;

    public void execute(RowValue var1) throws SQLException;

    public void fetchRows(int var1) throws SQLException;

    default public void fetchScroll(FetchType fetchType, int fetchSize, int position) throws SQLException {
        if (fetchType == FetchType.NEXT) {
            this.fetchRows(fetchSize);
            return;
        }
        throw new FBDriverNotCapableException("implementation does not support fetchScroll");
    }

    public boolean hasFetched();

    default public boolean supportsFetchScroll() {
        return false;
    }

    public void addStatementListener(StatementListener var1);

    public void removeStatementListener(StatementListener var1);

    public <T> T getSqlInfo(byte[] var1, int var2, InfoProcessor<T> var3) throws SQLException;

    public byte[] getSqlInfo(byte[] var1, int var2) throws SQLException;

    default public <T> T getCursorInfo(byte[] requestItems, int bufferLength, InfoProcessor<T> infoProcessor) throws SQLException {
        throw new FBDriverNotCapableException("implementation does not support getCursorInfo");
    }

    default public byte[] getCursorInfo(byte[] requestItems, int bufferLength) throws SQLException {
        throw new FBDriverNotCapableException("implementation does not support getCursorInfo");
    }

    default public boolean supportsCursorInfo() {
        return false;
    }

    public int getDefaultSqlInfoSize();

    public int getMaxSqlInfoSize();

    public String getExecutionPlan() throws SQLException;

    public String getExplainedExecutionPlan() throws SQLException;

    public SqlCountHolder getSqlCounts() throws SQLException;

    public void setCursorName(String var1) throws SQLException;

    public RowDescriptor emptyRowDescriptor();

    public void ensureClosedCursor(boolean var1) throws SQLException;

    public void setTimeout(long var1) throws SQLException;

    public long getTimeout() throws SQLException;

    default public void setCursorFlag(CursorFlag flag) {
    }

    default public void clearCursorFlag(CursorFlag flag) {
    }

    default public boolean isCursorFlagSet(CursorFlag flag) {
        return false;
    }

    default public boolean supportBatchUpdates() {
        return false;
    }

    default public void deferredBatchCreate(FbBatchConfig batchConfig, DeferredResponse<Void> onResponse) throws SQLException {
        throw new FBDriverNotCapableException("implementation does not support deferredBatchCreate");
    }

    default public void deferredBatchSend(Collection<RowValue> rowValues, DeferredResponse<Void> onResponse) throws SQLException {
        throw new FBDriverNotCapableException("implementation does not support deferredBatchSend");
    }

    default public BatchCompletion batchExecute() throws SQLException {
        throw new FBDriverNotCapableException("implementation does not support batchExecute");
    }

    default public void batchCancel() throws SQLException {
        throw new FBDriverNotCapableException("implementation does not support batchCancel");
    }

    default public void deferredBatchRelease(DeferredResponse<Void> onResponse) throws SQLException {
        throw new FBDriverNotCapableException("implementation does not support batchCancel");
    }

    default public BatchParameterBuffer createBatchParameterBuffer() throws SQLException {
        throw new FBDriverNotCapableException("implementation does not support createBatchParameterBuffer");
    }

    public LockCloseable withLock();
}

