
# 13 "plugins/ssr/ssrvernac.mlg"
 

open Names
module CoqConstr = Constr
open CoqConstr
open Constrexpr
open Constrexpr_ops
open Procq
open Procq.Prim
open Procq.Constr
open Pvernac.Vernac_
open Ltac_plugin
open Glob_term
open Stdarg
open Pp
open Ppconstr
open Printer
open Util
open Ssrprinters
open Ssrcommon


# 26 "plugins/ssr/ssrvernac.ml"

let _ = Mltop.add_known_module "rocq-runtime.plugins.ssreflect"

# 38 "plugins/ssr/ssrvernac.mlg"
 

(* Defining grammar rules with "xx" in it automatically declares keywords too,
 * we thus save the lexer to restore it at the end of the file *)
let frozen_lexer = ref None ;;
let () = Mltop.add_init_function "rocq-runtime.plugins.ssreflect" (fun () ->
    frozen_lexer := Some (Procq.freeze ()))

(* global syntactic changes and vernacular commands *)

(** Alternative notations for "match" and anonymous arguments. *)(* ************)

(* Syntax:                                                        *)
(*  if <term> is <pattern> then ... else ...                      *)
(*  if <term> is <pattern> [in ..] return ... then ... else ...   *)
(*  let: <pattern> := <term> in ...                               *)
(*  let: <pattern> [in ...] := <term> return ... in ...           *)
(* The scope of a top-level 'as' in the pattern extends over the  *)
(* 'return' type (dependent if/let).                              *)
(* Note that the optional "in ..." appears next to the <pattern>  *)
(* rather than the <term> in then "let:" syntax. The alternative  *)
(* would lead to ambiguities in, e.g.,                            *)
(* let: p1 := (*v---INNER LET:---v *)                             *)
(*   let: p2 := let: p3 := e3 in k return t in k2 in k1 return t' *)
(* in b       (*^--ALTERNATIVE INNER LET--------^ *)              *)

(* Caveat : There is no pretty-printing support, since this would *)
(* require a modification to the Rocq kernel (adding a new match  *)
(* display style -- why aren't these strings?); also, the v8.1    *)
(* pretty-printer only allows extension hooks for printing        *)
(* integer or string literals.                                    *)
(*   Also note that in the v8 grammar "is" needs to be a keyword; *)
(* as this can't be done from an ML extension file, the new       *)
(* syntax will only work when ssreflect.v is imported.            *)

let no_ct = None, None and no_rt = None
let aliasvar = function
  | [[{ CAst.v = CPatAlias (_, na); loc }]] -> Some na
  | _ -> None
let mk_cnotype mp = aliasvar mp, None
let mk_ctype mp t = aliasvar mp, Some t
let mk_rtype t = Some t
let mk_dthen ?loc (mp, ct, rt) c = (CAst.make ?loc (mp, c)), ct, rt
let mk_let ?loc rt ct mp c1 =
  CAst.make ?loc @@ CCases (LetPatternStyle, rt, ct, [CAst.make ?loc (mp, c1)])
let mk_pat c (na, t) = (c, na, t)


# 79 "plugins/ssr/ssrvernac.ml"

let _ =
  let ssr_rtype = Procq.Entry.make "ssr_rtype"
  and ssr_mpat = Procq.Entry.make "ssr_mpat"
  and ssr_dpat = Procq.Entry.make "ssr_dpat"
  and ssr_dthen = Procq.Entry.make "ssr_dthen"
  and ssr_elsepat = Procq.Entry.make "ssr_elsepat"
  and ssr_else = Procq.Entry.make "ssr_else"
  in
  let () = assert (Procq.Entry.is_empty ssr_rtype) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssreflect", "ssrvernac.mlg:0")
  ssr_rtype
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("return")))))
                             ((Procq.Symbol.nterml term ("100"))))
                            (fun t _ loc -> 
# 89 "plugins/ssr/ssrvernac.mlg"
                                                    mk_rtype t 
# 103 "plugins/ssr/ssrvernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ssr_mpat) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssreflect", "ssrvernac.mlg:1")
  ssr_mpat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm pattern)))
                            (fun p loc -> 
# 90 "plugins/ssr/ssrvernac.mlg"
                                [[p]] 
# 117 "plugins/ssr/ssrvernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ssr_dpat) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssreflect", "ssrvernac.mlg:2")
  ssr_dpat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ssr_mpat)))
                            (fun mp loc -> 
# 94 "plugins/ssr/ssrvernac.mlg"
                         mp, no_ct, no_rt 
# 131 "plugins/ssr/ssrvernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ssr_mpat)))
                            ((Procq.Symbol.nterm ssr_rtype)))
                           (fun rt mp loc -> 
# 93 "plugins/ssr/ssrvernac.mlg"
                                         mp, mk_cnotype mp, rt 
# 141 "plugins/ssr/ssrvernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm ssr_mpat)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                             ((Procq.Symbol.nterm pattern)))
                            ((Procq.Symbol.nterm ssr_rtype)))
                           (fun rt t _ mp loc -> 
# 92 "plugins/ssr/ssrvernac.mlg"
                                                            mp, mk_ctype mp t, rt 
# 155 "plugins/ssr/ssrvernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ssr_dthen) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssreflect", "ssrvernac.mlg:3")
  ssr_dthen
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm ssr_dpat)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("then")))))
                             ((Procq.Symbol.nterm lconstr)))
                            (fun c _ dp loc -> 
# 96 "plugins/ssr/ssrvernac.mlg"
                                                        mk_dthen ~loc dp c 
# 173 "plugins/ssr/ssrvernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ssr_elsepat) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssreflect", "ssrvernac.mlg:4")
  ssr_elsepat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("else")))))
                            (fun _ loc -> 
# 97 "plugins/ssr/ssrvernac.mlg"
                              [[CAst.make ~loc @@ CPatAtom None]] 
# 187 "plugins/ssr/ssrvernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ssr_else) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssreflect", "ssrvernac.mlg:5")
  ssr_else
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm ssr_elsepat)))
                             ((Procq.Symbol.nterm lconstr)))
                            (fun c mp loc -> 
# 98 "plugins/ssr/ssrvernac.mlg"
                                                  CAst.make ~loc (mp, c) 
# 203 "plugins/ssr/ssrvernac.ml"
)])]))
  in let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssreflect", "ssrvernac.mlg:6")
  binder_constr
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("let")))))
                                ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                               ((Procq.Symbol.nterm ssr_mpat)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                             ((Procq.Symbol.nterm pattern)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                           ((Procq.Symbol.nterm lconstr)))
                          ((Procq.Symbol.nterm ssr_rtype)))
                         ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                        ((Procq.Symbol.nterm lconstr)))
                       (fun c1 _ rt c _ t _ mp _ _ loc -> 
# 116 "plugins/ssr/ssrvernac.mlg"
        mk_let ~loc rt [mk_pat c (mk_ctype mp t)] mp c1 
# 232 "plugins/ssr/ssrvernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("let")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm ssr_mpat)))
                           ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                          ((Procq.Symbol.nterm lconstr)))
                         ((Procq.Symbol.nterm ssr_rtype)))
                        ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                       ((Procq.Symbol.nterm lconstr)))
                      (fun c1 _ rt c _ mp _ _ loc -> 
# 113 "plugins/ssr/ssrvernac.mlg"
        mk_let ~loc rt [mk_pat c (mk_cnotype mp)] mp c1 
# 254 "plugins/ssr/ssrvernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("let")))))
                            ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                           ((Procq.Symbol.nterm ssr_mpat)))
                          ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                         ((Procq.Symbol.nterm lconstr)))
                        ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                       ((Procq.Symbol.nterm lconstr)))
                      (fun c1 _ c _ mp _ _ loc -> 
# 110 "plugins/ssr/ssrvernac.mlg"
        mk_let ~loc no_rt [mk_pat c no_ct] mp c1 
# 274 "plugins/ssr/ssrvernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PKEYWORD ("if")))))
                          ((Procq.Symbol.nterml term ("200"))))
                         ((Procq.Symbol.token (Tok.PKEYWORD ("isn't")))))
                        ((Procq.Symbol.nterm ssr_dthen)))
                       ((Procq.Symbol.nterm ssr_else)))
                      (fun b2 db1 _ c _ loc -> 
# 103 "plugins/ssr/ssrvernac.mlg"
        let b1, ct, rt = db1 in
      let b1, b2 = let open CAst in
        let {loc=l1; v=(p1, r1)}, {loc=l2; v=(p2, r2)} = b1, b2 in
        (make ?loc:l1 (p1, r2), make ?loc:l2 (p2, r1))
      in
      CAst.make ~loc @@ CCases (MatchStyle, rt, [mk_pat c ct], [b1; b2]) 
# 295 "plugins/ssr/ssrvernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PKEYWORD ("if")))))
                          ((Procq.Symbol.nterml term ("200"))))
                         ((Procq.Symbol.token (Tok.PKEYWORD ("is")))))
                        ((Procq.Symbol.nterm ssr_dthen)))
                       ((Procq.Symbol.nterm ssr_else)))
                      (fun b2 db1 _ c _ loc -> 
# 101 "plugins/ssr/ssrvernac.mlg"
        let b1, ct, rt = db1 in CAst.make ~loc @@ CCases (MatchStyle, rt, [mk_pat c ct], [b1; b2]) 
# 311 "plugins/ssr/ssrvernac.ml"
)]))
  in ()

let _ = let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssreflect", "ssrvernac.mlg:7")
  closed_binder
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.next_norec
                                                                 (Procq.Rule.stop)
                                                                 ((Procq.Symbol.token (Tok.PKEYWORD ("&")))))
                                                                (fun _ loc ->
                                                                
# 123 "plugins/ssr/ssrvernac.mlg"
                                 () 
# 328 "plugins/ssr/ssrvernac.ml"
);
                                              Procq.Rules.make (Procq.Rule.next_norec
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.token (Tok.PKEYWORD ("of")))))
                                                               (fun _ loc ->
                                                               
# 123 "plugins/ssr/ssrvernac.mlg"
                 () 
# 337 "plugins/ssr/ssrvernac.ml"
)])))
                        ((Procq.Symbol.nterml term ("99"))))
                       (fun c _ loc -> 
# 124 "plugins/ssr/ssrvernac.mlg"
        [CLocalAssum ([CAst.make ~loc Anonymous], None, Default Explicit, c)] 
# 343 "plugins/ssr/ssrvernac.ml"
)]))
  in ()


# 142 "plugins/ssr/ssrvernac.mlg"
 

let declare_one_prenex_implicit locality f =
  let fref =
    try Smartlocate.global_with_alias f
    with e when CErrors.noncritical e -> errorstrm (pr_qualid f ++ str " is not declared") in
  let rec loop = function
  | a :: args' when Impargs.is_status_implicit a ->
    MaxImplicit :: loop args'
  | args' when List.exists Impargs.is_status_implicit args' ->
      errorstrm (str "Expected prenex implicits for " ++ pr_qualid f)
  | _ -> [] in
  let impls =
    match Impargs.implicits_of_global fref  with
    | [cond,impls] -> impls
    | [] -> errorstrm (str "Expected some implicits for " ++ pr_qualid f)
    | _ -> errorstrm (str "Multiple implicits not supported") in
  match loop impls  with
  | [] ->
    errorstrm (str "Expected some implicits for " ++ pr_qualid f)
  | impls ->
    Impargs.set_implicits locality fref [List.map (fun imp -> (Anonymous,imp)) impls]


# 373 "plugins/ssr/ssrvernac.ml"

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ssreflect") ~command:"Ssrpreneximplicits" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Prenex",
           Vernacextend.TyTerminal
           ("Implicits",
            Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_global)),
            Vernacextend.TyNil))),
          (let coqpp_body fl locality = Vernactypes.vtdefault (fun () -> 
# 169 "plugins/ssr/ssrvernac.mlg"
      
         let locality = Locality.make_section_locality locality in
         List.iter (declare_one_prenex_implicit locality) fl;
     
# 390 "plugins/ssr/ssrvernac.ml"
) in
            fun fl ?loc ~atts () -> coqpp_body fl (Attributes.parse 
# 168 "plugins/ssr/ssrvernac.mlg"
                   Attributes.locality
# 395 "plugins/ssr/ssrvernac.ml"
 atts)),
          None))]

let _ = let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssreflect", "ssrvernac.mlg:8")
  gallina_ext
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next (Procq.Rule.stop)
                          ((Procq.Symbol.token (Tok.PIDENT (Some
                          ("Import"))))))
                         ((Procq.Symbol.token (Tok.PIDENT (Some
                         ("Prenex"))))))
                        ((Procq.Symbol.token (Tok.PIDENT (Some
                        ("Implicits"))))))
                       (fun _ _ _ loc -> 
# 181 "plugins/ssr/ssrvernac.mlg"
        Vernacexpr.VernacSynterp (Vernacexpr.VernacSetOption (false, ["Printing"; "Implicit"; "Defensive"], Vernacexpr.OptionUnset)) 
# 415 "plugins/ssr/ssrvernac.ml"
)]))
  in ()


# 194 "plugins/ssr/ssrvernac.mlg"
 

let pr_raw_ssrhintref env sigma prc _ _ = let open CAst in function
  | { v = CAppExpl ((r,x), args) } when isCHoles args ->
    prc env sigma (CAst.make @@ CRef (r,x)) ++ str "|" ++ int (List.length args)
  | { v = CApp ({ v = CRef _ }, _) } as c -> prc env sigma c
  | { v = CApp (c, args) } when isCxHoles args ->
    prc env sigma c ++ str "|" ++ int (List.length args)
  | c -> prc env sigma c

let pr_rawhintref env sigma c =
  match DAst.get c with
  | GApp (f, args) when isRHoles args ->
    pr_glob_constr_env env sigma f ++ str "|" ++ int (List.length args)
  | _ -> pr_glob_constr_env env sigma c

let pr_glob_ssrhintref env sigma _ _ _ (c, _) = pr_rawhintref env sigma c

let pr_ssrhintref env sigma prc _ _ = prc env sigma

let mkhintref ?loc c n = match c.CAst.v with
  | CRef (r,x) -> CAst.make ?loc @@ CAppExpl ((r, x), mkCHoles ?loc n)
  | _ -> mkAppC (c, mkCHoles ?loc n)


# 446 "plugins/ssr/ssrvernac.ml"

let (wit_ssrhintref, ssrhintref) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ssreflect" ~name:"ssrhintref" 
                                   {
                                   Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                            ([(Procq.Production.make
                                                               (Procq.Rule.next
                                                                (Procq.Rule.next
                                                                 (Procq.Rule.next
                                                                  (Procq.Rule.stop)
                                                                  ((Procq.Symbol.nterm constr)))
                                                                 ((Procq.Symbol.token (Procq.terminal "|"))))
                                                                ((Procq.Symbol.nterm natural)))
                                                               (fun n _ c
                                                               loc -> 
                                                               
# 226 "plugins/ssr/ssrvernac.mlg"
                                       mkhintref ~loc c n  
# 464 "plugins/ssr/ssrvernac.ml"
));
                                                             (Procq.Production.make
                                                              (Procq.Rule.next
                                                               (Procq.Rule.stop)
                                                               ((Procq.Symbol.nterm constr)))
                                                              (fun c loc -> 
# 225 "plugins/ssr/ssrvernac.mlg"
                        c  
# 473 "plugins/ssr/ssrvernac.ml"
))]);
                                   Tacentries.arg_tag = Some
                                                        (Geninterp.val_tag (Genarg.topwit wit_constr));
                                   Tacentries.arg_intern = Tacentries.ArgInternWit (wit_constr);
                                   Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_constr);
                                   Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_constr);
                                   Tacentries.arg_printer = ((fun env sigma -> 
                                                            
# 223 "plugins/ssr/ssrvernac.mlg"
                   pr_raw_ssrhintref env sigma 
# 484 "plugins/ssr/ssrvernac.ml"
), (fun env sigma -> 
                                                            
# 224 "plugins/ssr/ssrvernac.mlg"
                    pr_glob_ssrhintref env sigma 
# 489 "plugins/ssr/ssrvernac.ml"
), (fun env sigma -> 
                                                            
# 222 "plugins/ssr/ssrvernac.mlg"
               pr_ssrhintref env sigma 
# 494 "plugins/ssr/ssrvernac.ml"
));
                                   }
let _ = (wit_ssrhintref, ssrhintref)


# 229 "plugins/ssr/ssrvernac.mlg"
 

(* View purpose *)

let pr_viewpos = function
  | Some Ssrview.AdaptorDb.Forward -> str " for move/"
  | Some Ssrview.AdaptorDb.Backward -> str " for apply/"
  | Some Ssrview.AdaptorDb.Equivalence -> str " for apply//"
  | None -> mt ()

let pr_ssrviewpos _ _ _ = pr_viewpos


# 514 "plugins/ssr/ssrvernac.ml"

let (wit_ssrviewpos, ssrviewpos) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ssreflect" ~name:"ssrviewpos" 
                                   {
                                   Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                            ([(Procq.Production.make
                                                               (Procq.Rule.stop)
                                                               (fun loc -> 
# 248 "plugins/ssr/ssrvernac.mlg"
              None  
# 524 "plugins/ssr/ssrvernac.ml"
));
                                                             (Procq.Production.make
                                                              (Procq.Rule.next
                                                               (Procq.Rule.next
                                                                (Procq.Rule.next
                                                                 (Procq.Rule.stop)
                                                                 ((Procq.Symbol.token (Procq.terminal "for"))))
                                                                ((Procq.Symbol.token (Procq.terminal "apply"))))
                                                               ((Procq.Symbol.token (Procq.terminal "//"))))
                                                              (fun _ _ _
                                                              loc -> 
                                                              
# 247 "plugins/ssr/ssrvernac.mlg"
                                 Some Ssrview.AdaptorDb.Equivalence  
# 539 "plugins/ssr/ssrvernac.ml"
));
                                                             (Procq.Production.make
                                                              (Procq.Rule.next
                                                               (Procq.Rule.next
                                                                (Procq.Rule.next
                                                                 (Procq.Rule.next
                                                                  (Procq.Rule.stop)
                                                                  ((Procq.Symbol.token (Procq.terminal "for"))))
                                                                 ((Procq.Symbol.token (Procq.terminal "apply"))))
                                                                ((Procq.Symbol.token (Procq.terminal "/"))))
                                                               ((Procq.Symbol.token (Procq.terminal "/"))))
                                                              (fun _ _ _ _
                                                              loc -> 
                                                              
# 246 "plugins/ssr/ssrvernac.mlg"
                                    Some Ssrview.AdaptorDb.Equivalence  
# 556 "plugins/ssr/ssrvernac.ml"
));
                                                             (Procq.Production.make
                                                              (Procq.Rule.next
                                                               (Procq.Rule.next
                                                                (Procq.Rule.next
                                                                 (Procq.Rule.stop)
                                                                 ((Procq.Symbol.token (Procq.terminal "for"))))
                                                                ((Procq.Symbol.token (Procq.terminal "apply"))))
                                                               ((Procq.Symbol.token (Procq.terminal "/"))))
                                                              (fun _ _ _
                                                              loc -> 
                                                              
# 245 "plugins/ssr/ssrvernac.mlg"
                                Some Ssrview.AdaptorDb.Backward  
# 571 "plugins/ssr/ssrvernac.ml"
));
                                                             (Procq.Production.make
                                                              (Procq.Rule.next
                                                               (Procq.Rule.next
                                                                (Procq.Rule.next
                                                                 (Procq.Rule.stop)
                                                                 ((Procq.Symbol.token (Procq.terminal "for"))))
                                                                ((Procq.Symbol.token (Procq.terminal "move"))))
                                                               ((Procq.Symbol.token (Procq.terminal "/"))))
                                                              (fun _ _ _
                                                              loc -> 
                                                              
# 244 "plugins/ssr/ssrvernac.mlg"
                               Some Ssrview.AdaptorDb.Forward  
# 586 "plugins/ssr/ssrvernac.ml"
))]);
                                   Tacentries.arg_tag = None;
                                   Tacentries.arg_intern = Tacentries.ArgInternFun (fun ist v -> (ist, v));
                                   Tacentries.arg_subst = Tacentries.ArgSubstFun (fun s v -> v);
                                   Tacentries.arg_interp = Tacentries.ArgInterpRet;
                                   Tacentries.arg_printer = ((fun env sigma -> 
                                                            
# 243 "plugins/ssr/ssrvernac.mlg"
                                        pr_ssrviewpos 
# 596 "plugins/ssr/ssrvernac.ml"
), (fun env sigma -> 
                                                            
# 243 "plugins/ssr/ssrvernac.mlg"
                                        pr_ssrviewpos 
# 601 "plugins/ssr/ssrvernac.ml"
), (fun env sigma -> 
                                                            
# 243 "plugins/ssr/ssrvernac.mlg"
                                        pr_ssrviewpos 
# 606 "plugins/ssr/ssrvernac.ml"
));
                                   }
let _ = (wit_ssrviewpos, ssrviewpos)


# 251 "plugins/ssr/ssrvernac.mlg"
 

let pr_ssrviewposspc _ _ _ i = pr_viewpos i ++ spc ()


# 618 "plugins/ssr/ssrvernac.ml"

let (wit_ssrviewposspc, ssrviewposspc) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ssreflect" ~name:"ssrviewposspc" 
                                         {
                                         Tacentries.arg_parsing = Vernacextend.Arg_alias
                                                                  (ssrviewpos);
                                         Tacentries.arg_tag = Some
                                                              (Geninterp.val_tag (Genarg.topwit wit_ssrviewpos));
                                         Tacentries.arg_intern = Tacentries.ArgInternWit (wit_ssrviewpos);
                                         Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_ssrviewpos);
                                         Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_ssrviewpos);
                                         Tacentries.arg_printer = ((fun env sigma -> 
                                                                  
# 257 "plugins/ssr/ssrvernac.mlg"
                                                               pr_ssrviewposspc 
# 633 "plugins/ssr/ssrvernac.ml"
), (fun env sigma -> 
                                                                  
# 257 "plugins/ssr/ssrvernac.mlg"
                                                               pr_ssrviewposspc 
# 638 "plugins/ssr/ssrvernac.ml"
), (fun env sigma -> 
                                                                  
# 257 "plugins/ssr/ssrvernac.mlg"
                                                               pr_ssrviewposspc 
# 643 "plugins/ssr/ssrvernac.ml"
));
                                         }
let _ = (wit_ssrviewposspc, ssrviewposspc)


# 261 "plugins/ssr/ssrvernac.mlg"
 

let print_view_hints env sigma kind l =
  let pp_viewname = str "Hint View" ++ pr_viewpos (Some kind) ++ str " " in
  let pp_hints = pr_list spc (pr_rawhintref env sigma) l in
  Feedback.msg_notice  (pp_viewname ++ hov 0 pp_hints ++ Pp.cut ())


# 658 "plugins/ssr/ssrvernac.ml"

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ssreflect") ~command:"PrintView" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Print",
           Vernacextend.TyTerminal
           ("Hint",
            Vernacextend.TyTerminal
            ("View",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ssrviewpos),
             Vernacextend.TyNil)))),
          (let coqpp_body i () = Vernactypes.vtdefault (fun () -> 
# 272 "plugins/ssr/ssrvernac.mlg"
   
    let env = Global.env () in
    let sigma = Evd.from_env env in
    (match i with
    | Some k ->
      print_view_hints env sigma k (Ssrview.AdaptorDb.get k)
    | None ->
        List.iter (fun k -> print_view_hints env sigma k (Ssrview.AdaptorDb.get k))
          [ Ssrview.AdaptorDb.Forward;
            Ssrview.AdaptorDb.Backward;
            Ssrview.AdaptorDb.Equivalence ])
  
# 685 "plugins/ssr/ssrvernac.ml"
) in
            fun i ?loc ~atts () ->
            coqpp_body i (Attributes.unsupported_attributes atts)),
          None))]


# 286 "plugins/ssr/ssrvernac.mlg"
 

let glob_view_hints lvh =
  List.map (Constrintern.intern_constr (Global.env ()) (Evd.from_env (Global.env ()))) lvh


# 699 "plugins/ssr/ssrvernac.ml"

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ssreflect") ~command:"HintView" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Hint",
           Vernacextend.TyTerminal
           ("View",
            Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ssrviewposspc),
            Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_ssrhintref)),
            Vernacextend.TyNil)))),
          (let coqpp_body n lvh () = Vernactypes.vtdefault (fun () -> 
# 295 "plugins/ssr/ssrvernac.mlg"
       let hints = glob_view_hints lvh in
       match n with
       | None ->
          Ssrview.AdaptorDb.declare Ssrview.AdaptorDb.Forward hints;
          Ssrview.AdaptorDb.declare Ssrview.AdaptorDb.Backward hints
       | Some k ->
          Ssrview.AdaptorDb.declare k hints 
# 720 "plugins/ssr/ssrvernac.ml"
) in
            fun n lvh ?loc ~atts () ->
            coqpp_body n lvh (Attributes.unsupported_attributes atts)),
          None))]


# 306 "plugins/ssr/ssrvernac.mlg"
 

open G_vernac

# 732 "plugins/ssr/ssrvernac.ml"

let _ = let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssreflect", "ssrvernac.mlg:9")
  query_command
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PIDENT (Some
                           ("Search"))))))
                          ((Procq.Symbol.nterm search_query)))
                         ((Procq.Symbol.nterm search_queries)))
                        ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                       (fun _ l s _ loc -> 
# 316 "plugins/ssr/ssrvernac.mlg"
            let (sl,m) = l in
            fun g ->
              Vernacexpr.VernacSearch (Vernacexpr.Search (s::sl),g, m) 
# 752 "plugins/ssr/ssrvernac.ml"
)]))
  in ()


# 337 "plugins/ssr/ssrvernac.mlg"
 

open Pltac


# 763 "plugins/ssr/ssrvernac.ml"

let _ = let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssreflect", "ssrvernac.mlg:10")
  hypident
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                           ((Procq.Symbol.token (Tok.PIDENT (Some
                           ("value"))))))
                          ((Procq.Symbol.token (Tok.PKEYWORD ("of")))))
                         ((Procq.Symbol.nterm Prim.identref)))
                        ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                       (fun _ id _ _ _ loc -> 
# 347 "plugins/ssr/ssrvernac.mlg"
                                                           id, Locus.InHypValueOnly 
# 783 "plugins/ssr/ssrvernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                          ((Procq.Symbol.token (Tok.PIDENT (Some ("type"))))))
                         ((Procq.Symbol.token (Tok.PKEYWORD ("of")))))
                        ((Procq.Symbol.nterm Prim.identref)))
                       ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                      (fun _ id _ _ _ loc -> 
# 346 "plugins/ssr/ssrvernac.mlg"
                                                          id, Locus.InHypTypeOnly 
# 799 "plugins/ssr/ssrvernac.ml"
)]))
  in ()

let _ = let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ssreflect", "ssrvernac.mlg:11")
  constr_eval
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next (Procq.Rule.stop)
                          ((Procq.Symbol.token (Tok.PIDENT (Some ("type"))))))
                         ((Procq.Symbol.token (Tok.PKEYWORD ("of")))))
                        ((Procq.Symbol.nterm Constr.constr)))
                       (fun c _ _ loc -> 
# 354 "plugins/ssr/ssrvernac.mlg"
                                                 Tacexpr.ConstrTypeOf c 
# 816 "plugins/ssr/ssrvernac.ml"
)]))
  in ()


# 358 "plugins/ssr/ssrvernac.mlg"
 

(* We wipe out all the keywords generated by the grammar rules we defined. *)
(* The user is supposed to Require Import ssreflect or Require ssreflect   *)
(* and Import ssreflect.SsrSyntax to obtain these keywords and as a         *)
(* consequence the extended ssreflect grammar.                             *)
let () = Mltop.add_init_function "rocq-runtime.plugins.ssreflect" (fun () ->
      Procq.unfreeze_only_keywords (Option.get !frozen_lexer);
      frozen_lexer := None) ;;


# 833 "plugins/ssr/ssrvernac.ml"

