# This file has been autogenerated by the pywayland scanner

# Copyright © 2015-2016 Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSurface


class ZxdgImportedV1(Interface):
    """An imported surface handle

    An xdg_imported object represents an imported reference to surface exported
    by some client. A client can use this interface to manipulate relationships
    between its own surfaces and the imported surface.
    """

    name = "zxdg_imported_v1"
    version = 1


class ZxdgImportedV1Proxy(Proxy[ZxdgImportedV1]):
    interface = ZxdgImportedV1

    @ZxdgImportedV1.request()
    def destroy(self) -> None:
        """Destroy the xdg_imported object

        Notify the compositor that it will no longer use the xdg_imported
        object. Any relationship that may have been set up will at this point
        be invalidated.
        """
        self._marshal(0)
        self._destroy()

    @ZxdgImportedV1.request(
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def set_parent_of(self, surface: WlSurface) -> None:
        """Set as the parent of some surface

        Set the imported surface as the parent of some surface of the client.
        The passed surface must be a toplevel
        :class:`~pywayland.protocol.xdg_shell.XdgSurface`. Calling this
        function sets up a surface to surface relation with the same stacking
        and positioning semantics as :func:`XdgSurface.set_parent()
        <pywayland.protocol.xdg_shell.XdgSurface.set_parent>`.

        :param surface:
            the child surface
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        """
        self._marshal(1, surface)


class ZxdgImportedV1Resource(Resource):
    interface = ZxdgImportedV1

    @ZxdgImportedV1.event()
    def destroyed(self) -> None:
        """The imported surface handle has been destroyed

        The imported surface handle has been destroyed and any relationship set
        up has been invalidated. This may happen for various reasons, for
        example if the exported surface or the exported surface handle has been
        destroyed, if the handle used for importing was invalid.
        """
        self._post_event(0)


class ZxdgImportedV1Global(Global):
    interface = ZxdgImportedV1


ZxdgImportedV1._gen_c()
ZxdgImportedV1.proxy_class = ZxdgImportedV1Proxy
ZxdgImportedV1.resource_class = ZxdgImportedV1Resource
ZxdgImportedV1.global_class = ZxdgImportedV1Global
