/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.hand;

import java.util.Random;
import net.sourceforge.plantuml.klimt.Shadowable;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UPolygon;

public class UEllipseHand {
    private Shadowable poly;
    private final Random rnd;

    private double randomMe() {
        return this.rnd.nextDouble();
    }

    public UEllipseHand(UEllipse source, Random rnd) {
        this.rnd = rnd;
        if (source.getStart() != 0.0 || source.getExtend() != 0.0) {
            this.poly = source;
            return;
        }
        this.poly = new UPolygon();
        double width = source.getWidth();
        double height = source.getHeight();
        double angle = 0.0;
        if (width == height) {
            while (angle < Math.PI * 2) {
                double variation = 1.0 + (this.randomMe() - 0.5) / 8.0;
                double x = width / 2.0 + Math.cos(angle += (10.0 + this.randomMe() * 10.0) * Math.PI / 180.0) * width * variation / 2.0;
                double y = height / 2.0 + Math.sin(angle) * height * variation / 2.0;
                ((UPolygon)this.poly).addPoint(x, y);
            }
        } else {
            while (angle < Math.PI * 2) {
                XPoint2D pt = this.getPoint(width, height, angle += 0.15707963267948966);
                ((UPolygon)this.poly).addPoint(pt.getX(), pt.getY());
            }
        }
        this.poly.setDeltaShadow(source.getDeltaShadow());
    }

    private XPoint2D getPoint(double width, double height, double angle) {
        double x = width / 2.0 + Math.cos(angle) * width / 2.0;
        double y = height / 2.0 + Math.sin(angle) * height / 2.0;
        double variation = (this.randomMe() - 0.5) / 50.0;
        return new XPoint2D(x + variation * width, y + variation * height);
    }

    public Shadowable getHanddrawn() {
        return this.poly;
    }
}

