/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometryMerger;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class FtileGeometry
extends XDimension2D {
    private final double left;
    private final double inY;
    private final double outY;

    public XPoint2D getPointA() {
        return new XPoint2D(this.left, this.inY);
    }

    public XPoint2D getPointIn() {
        return new XPoint2D(this.left, this.inY);
    }

    public XPoint2D getPointB() {
        if (this.outY == Double.MIN_NORMAL) {
            throw new UnsupportedOperationException();
        }
        return new XPoint2D(this.getWidth(), (this.inY + this.outY) / 2.0);
    }

    public XPoint2D getPointC() {
        if (this.outY == Double.MIN_NORMAL) {
            throw new UnsupportedOperationException();
        }
        return new XPoint2D(this.left, this.outY);
    }

    public XPoint2D getPointD() {
        if (this.outY == Double.MIN_NORMAL) {
            throw new UnsupportedOperationException();
        }
        return new XPoint2D(0.0, (this.inY + this.outY) / 2.0);
    }

    public XPoint2D getPointOut() {
        if (this.outY == Double.MIN_NORMAL) {
            throw new UnsupportedOperationException();
        }
        return new XPoint2D(this.left, this.outY);
    }

    public FtileGeometry(XDimension2D dim, double left, double inY) {
        this(dim.getWidth(), dim.getHeight(), left, inY);
    }

    public FtileGeometry(double width, double height, double left, double inY) {
        this(width, height, left, inY, Double.MIN_NORMAL);
    }

    @Override
    public String toString() {
        return "[" + this.getWidth() + "x" + this.getHeight() + " left=" + this.left + "]";
    }

    public FtileGeometry(double width, double height, double left, double inY, double outY) {
        super(width, height);
        this.left = left;
        this.inY = inY;
        this.outY = outY;
    }

    public FtileGeometry incHeight(double northHeight) {
        return new FtileGeometry(this.getWidth(), this.getHeight() + northHeight, this.left, this.inY, this.outY);
    }

    public FtileGeometry addTop(double northHeight) {
        if (this.hasPointOut()) {
            return new FtileGeometry(this.getWidth(), this.getHeight() + northHeight, this.left, this.inY + northHeight, this.outY + northHeight);
        }
        return new FtileGeometry(this.getWidth(), this.getHeight() + northHeight, this.left, this.inY + northHeight, Double.MIN_NORMAL);
    }

    public FtileGeometry addBottom(double southHeight) {
        if (this.hasPointOut()) {
            return new FtileGeometry(this.getWidth(), this.getHeight() + southHeight, this.left, this.inY, this.outY);
        }
        return new FtileGeometry(this.getWidth(), this.getHeight() + southHeight, this.left, this.inY, Double.MIN_NORMAL);
    }

    public FtileGeometry incRight(double missing) {
        return new FtileGeometry(this.getWidth() + missing, this.getHeight(), this.left, this.inY, this.outY);
    }

    public FtileGeometry incLeft(double missing) {
        return new FtileGeometry(this.getWidth() + missing, this.getHeight(), this.left + missing, this.inY, this.outY);
    }

    public FtileGeometry incVertically(double missing1, double missing2) {
        return new FtileGeometry(this.getWidth(), this.getHeight() + missing1 + missing2, this.left, this.inY + missing1, this.hasPointOut() ? this.outY + missing1 : this.outY);
    }

    public FtileGeometry incInY(double missing) {
        return new FtileGeometry(this.getWidth(), this.getHeight(), this.left, this.inY + missing, this.outY);
    }

    public FtileGeometry(XDimension2D dim, double left, double inY, double outY) {
        this(dim.getWidth(), dim.getHeight(), left, inY, outY);
    }

    public boolean hasPointOut() {
        return this.outY != Double.MIN_NORMAL;
    }

    public FtileGeometry withoutPointOut() {
        return new FtileGeometry(this.getWidth(), this.getHeight(), this.left, this.inY);
    }

    public FtileGeometry translate(UTranslate translate) {
        double dx = translate.getDx();
        double dy = translate.getDy();
        if (this.outY == Double.MIN_NORMAL) {
            return new FtileGeometry(this.getWidth(), this.getHeight(), this.left + dx, this.inY + dy);
        }
        return new FtileGeometry(this.getWidth(), this.getHeight(), this.left + dx, this.inY + dy, this.outY + dy);
    }

    public final double getInY() {
        return this.inY;
    }

    public final double getLeft() {
        return this.left;
    }

    public final double getRight() {
        return this.getWidth() - this.left;
    }

    public double getOutY() {
        return this.outY;
    }

    public FtileGeometry addDim(double deltaWidth, double deltaHeight) {
        return new FtileGeometry(this.getWidth() + deltaWidth, this.getHeight() + deltaHeight, this.left, this.inY, this.outY + deltaHeight);
    }

    public FtileGeometry addMarginX(double marginx) {
        return new FtileGeometry(this.getWidth() + 2.0 * marginx, this.getHeight(), this.left + marginx, this.inY, this.outY);
    }

    public FtileGeometry addMarginX(double margin1, double margin2) {
        return new FtileGeometry(this.getWidth() + margin1 + margin2, this.getHeight(), this.left + margin1, this.inY, this.outY);
    }

    public FtileGeometry fixedHeight(double fixedHeight) {
        return new FtileGeometry(this.getWidth(), fixedHeight, this.left, this.inY, this.outY);
    }

    public FtileGeometry appendBottom(FtileGeometry other) {
        return new FtileGeometryMerger(this, other).getResult();
    }

    public FtileGeometry ensureHeight(double newHeight) {
        if (this.getHeight() > newHeight) {
            return this;
        }
        return this.fixedHeight(newHeight);
    }
}

