-- Copyright © 2008-2025 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

local CultureName = require './common'

local male = {
	'Adrian',
	'Albert',
	'Alexander',
	'Alfred',
	'Andreas',
	'Anton',
	'Armin',
	'Arnold',
	'Arthur',
	'August',
	'Axel',
	'Bastian',
	'Benedikt',
	'Benjamin',
	'Bernd',
	'Bernhard',
	'Björn',
	'Bruno',
	'Burkhard',
	'Carsten',
	'Christian',
	'Christoph',
	'Claudius',
	'Clemens',
	'Corbinian',
	'Cornelius',
	'Daniel',
	'David',
	'Dennis',
	'Detlev',
	'Dieter',
	'Dietmar',
	'Dietrich',
	'Dirk',
	'Dominik',
	'Eberhard',
	'Eckard',
	'Edmund',
	'Eduard',
	'Elmar',
	'Emanuel',
	'Emil',
	'Erhard',
	'Erich',
	'Erik',
	'Ernst',
	'Erwin',
	'Eugen',
	'Ewald',
	'Fabian',
	'Falk',
	'Felix',
	'Ferdinand',
	'Florian',
	'Frank',
	'Franz',
	'Friedrich',
	'Gabriel',
	'Georg',
	'Gerald',
	'Gerd',
	'Gerhard',
	'Gernot',
	'Gero',
	'Gregor',
	'Guido',
	'Gunnar',
	'Gustav',
	'Günther',
	'Hagen',
	'Hans',
	'Harald',
	'Hartmut',
	'Heiko',
	'Heinrich',
	'Heinz',
	'Helge',
	'Helmut',
	'Hendrik',
	'Henning',
	'Herbert',
	'Hermann',
	'Hilmar',
	'Holger',
	'Horst',
	'Hubert',
	'Hugo',
	'Ingo',
	'Ingolf',
	'Isaak',
	'Jakob',
	'Jan',
	'Jasper',
	'Jens',
	'Jeremias',
	'Joachim',
	'Jochen',
	'Joel',
	'Johannes',
	'Jonas',
	'Jonathan',
	'Joseph',
	'Josua',
	'Julian',
	'Julius',
	'Justus',
	'Jörg',
	'Kai',
	'Karl',
	'Kevin',
	'Klaus',
	'Knut',
	'Konrad',
	'Konstantin',
	'Kurt',
	'Lars',
	'Leif',
	'Leo',
	'Leonhard',
	'Levi',
	'Linus',
	'Lorenz',
	'Lothar',
	'Ludger',
	'Ludwig',
	'Lukas',
	'Magnus',
	'Malte',
	'Manfred',
	'Manuel',
	'Marcel',
	'Marko',
	'Markus',
	'Martin',
	'Matthias',
	'Max',
	'Maximilian',
	'Maximus',
	'Michael',
	'Moritz',
	'Niklas',
	'Nils',
	'Norbert',
	'Olaf',
	'Ole',
	'Oliver',
	'Oskar',
	'Oswald',
	'Ottmar',
	'Otto',
	'Pascal',
	'Patrick',
	'Paul',
	'Peter',
	'Philipp',
	'Quintus',
	'Raimund',
	'Rainer',
	'Ralf',
	'Raphael',
	'Reiner',
	'Reinhard',
	'Renatus',
	'Richard',
	'Robert',
	'Robin',
	'Roland',
	'Rolf',
	'Roman',
	'Ronald',
	'Rudolf',
	'Rüdiger',
	'Sascha',
	'Sebastian',
	'Siegfried',
	'Simon',
	'Stefan',
	'Steffen',
	'Sven',
	'Theodor',
	'Theophil',
	'Thomas',
	'Thorsten',
	'Tilo',
	'Tim',
	'Timo',
	'Titus',
	'Tobias',
	'Tom',
	'Torben',
	'Torsten',
	'Udo',
	'Ulf',
	'Ulrich',
	'Uwe',
	'Waldemar',
	'Valentin',
	'Walter',
	'Werner',
	'Viktor',
	'Wilhelm',
	'Winfried',
	'Vitus',
	'Wolfgang',
	'Volker',
	'Yannik',
	'Zacharias'
}

local female = {
	'Agnes',
	'Alessa',
	'Alexa',
	'Alexandra',
	'Alina',
	'Andrea',
	'Angela',
	'Angelika',
	'Anika',
	'Anita',
	'Anja',
	'Anke',
	'Anna',
	'Annabella',
	'Annalena',
	'Annette',
	'Annkathrin',
	'Antje',
	'Antonia',
	'Arabella',
	'Ariane',
	'Astrid',
	'Barbara',
	'Bea',
	'Beate',
	'Beatrice',
	'Bettina',
	'Bianca',
	'Birgit',
	'Brigitte',
	'Britta',
	'Carina',
	'Carmen',
	'Carola',
	'Caroline',
	'Charlotte',
	'Christiane',
	'Christine',
	'Claudia',
	'Constanze',
	'Cordelia',
	'Cordula',
	'Corinna',
	'Cornelia',
	'Cosima',
	'Dagmar',
	'Dana',
	'Daniela',
	'Daphne',
	'Deborah',
	'Diana',
	'Doris',
	'Dorkas',
	'Dorothea',
	'Dunja',
	'Edith',
	'Elfie',
	'Elisabeth',
	'Elke',
	'Ella',
	'Ellen',
	'Elvira',
	'Emanuela',
	'Emilia',
	'Emma',
	'Erika',
	'Esther',
	'Eva',
	'Evelyn',
	'Felicitas',
	'Fiona',
	'Franka',
	'Franziska',
	'Frederike',
	'Gabriele',
	'Genoveva',
	'Gerda',
	'Gina',
	'Gisela',
	'Gloria',
	'Gudrun',
	'Gwendolin',
	'Hanka',
	'Hannah',
	'Heike',
	'Helena',
	'Helene',
	'Helga',
	'Hera',
	'Hilde',
	'Ilona',
	'Ina',
	'Ines',
	'Inge',
	'Ingrid',
	'Irene',
	'Iris',
	'Irma',
	'Isabelle',
	'Jana',
	'Janine',
	'Jasmin',
	'Jeanette',
	'Jennifer',
	'Jessica',
	'Johanna',
	'Jolanda',
	'Josefine',
	'Judith',
	'Jule',
	'Julia',
	'Juliana',
	'Juliane',
	'Karin',
	'Katharina',
	'Kathleen',
	'Katja',
	'Katrin',
	'Kerstin',
	'Kirsten',
	'Lara',
	'Larissa',
	'Laura',
	'Lea',
	'Lena',
	'Leoni',
	'Leonore',
	'Liane',
	'Lilly',
	'Linda',
	'Lisa',
	'Luise',
	'Magdalena',
	'Maike',
	'Maja',
	'Manuela',
	'Mara',
	'Mareike',
	'Maren',
	'Margarete',
	'Margit',
	'Maria',
	'Marianne',
	'Marie',
	'Marina',
	'Marion',
	'Marita',
	'Marlene',
	'Martha',
	'Martina',
	'Mathilda',
	'Maya',
	'Melanie',
	'Melissa',
	'Meret',
	'Michaela',
	'Miriam',
	'Mona',
	'Monika',
	'Muriel',
	'Nadine',
	'Nadja',
	'Natalie',
	'Natascha',
	'Nicole',
	'Nikola',
	'Nina',
	'Nora',
	'Olga',
	'Patricia',
	'Paula',
	'Pauline',
	'Petra',
	'Pia',
	'Ramona',
	'Raphaela',
	'Rebecca',
	'Regina',
	'Renate',
	'Rita',
	'Roberta',
	'Romina',
	'Rose',
	'Roxana',
	'Sabine',
	'Sabrina',
	'Sandra',
	'Sarah',
	'Saskia',
	'Selma',
	'Sibylle',
	'Silke',
	'Silvia',
	'Simone',
	'Sonja',
	'Sophie',
	'Stefanie',
	'Susanne',
	'Svenja',
	'Tabea',
	'Tamara',
	'Tanja',
	'Tatjana',
	'Theresa',
	'Ulla',
	'Ulrike',
	'Ursula',
	'Uta',
	'Ute',
	'Valerie',
	'Vanessa',
	'Vera',
	'Verena',
	'Verona',
	'Veronika',
	'Viktoria',
	'Viola',
	'Violetta',
	'Viviane',
	'Yvonne'
}

local surname = {
	'Albrecht',
	'Althaus',
	'Altmann',
	'Arnold',
	'Aschenbach',
	'Bauer',
	'Baumann',
	'Baumbach',
	'Baumgärtner',
	'Beck',
	'Becker',
	'Berg',
	'Berger',
	'Bergmann',
	'Biedermann',
	'Brandt',
	'Braun',
	'Brinkmeyer',
	'Busch',
	'Böhm',
	'Denkendorfer',
	'Dietrich',
	'Dunder',
	'Ebenberger',
	'Edelstein',
	'Engel',
	'Engels',
	'Falk',
	'Feuerbach',
	'Fischer',
	'Frank',
	'Franke',
	'Freund',
	'Friedemann',
	'Friedrich',
	'Fuchs',
	'Gantz',
	'Geiger',
	'Gerlach',
	'Graf',
	'Groß',
	'Günther',
	'Haas',
	'Hahn',
	'Hartmann',
	'Haupt',
	'Heinrich',
	'Hempel',
	'Herrmann',
	'Hoffmann',
	'Hofmann',
	'Horn',
	'Huber',
	'Jung',
	'Jäger',
	'Kaiser',
	'Keller',
	'Klein',
	'Koch',
	'Kraus',
	'Krause',
	'Krüger',
	'Krämer',
	'Kuhn',
	'Kurz',
	'Kühn',
	'Köhler',
	'König',
	'Lang',
	'Lange',
	'Laurentius',
	'Lehmann',
	'Lehrer',
	'Lorenz',
	'Ludwig',
	'Mahlberg',
	'Maier',
	'Martin',
	'Mayer',
	'Meier',
	'Meissner',
	'Metzger',
	'Meyer',
	'Moltke',
	'Müler',
	'Müller',
	'Möller',
	'Neubauer',
	'Neumann',
	'Niemeyer',
	'Obenauer',
	'Otto',
	'Pappenheim',
	'Peters',
	'Pfeiffer',
	'Pohl',
	'Probst',
	'Reichmann',
	'Richter',
	'Rohde',
	'Rosenbach',
	'Roth',
	'Rothmann',
	'Sacher',
	'Sauer',
	'Schmid',
	'Schmidt',
	'Schmitt',
	'Schmitz',
	'Schneider',
	'Scholz',
	'Schreiber',
	'Schröder',
	'Schubert',
	'Schulte',
	'Schulz',
	'Schulze',
	'Schumacher',
	'Schuster',
	'Schwarz',
	'Schäfe',
	'Schäfer',
	'Seidel',
	'Simon',
	'Sohn',
	'Sommer',
	'Stein',
	'Steiner',
	'Thalberg',
	'Thomas',
	'Unger',
	'Wagner',
	'Walter',
	'Weber',
	'Weiß',
	'Werner',
	'Winkler',
	'Winter',
	'Vogel',
	'Vogt',
	'Voigt',
	'Wolf',
	'Wolff',
	'Ziegler',
	'Zimmermann'
}

local German = CultureName.New(
{
	male = male,
	female = female,
	surname = surname,
	name = "German",
	code = "de",
	replace = {
		["ä"] = "a", ["Ä"] = "A",
		["ö"] = "o", ["Ö"] = "O",
		["ü"] = "u", ["Ü"] = "U",
		["ß"] = "ss", ["ẞ"] = "Ss",
	}
})

return German
