/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.handlers;

import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.ast.tree.MinSpanBin;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.utils.binning.BinHandler;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;

public class MinSpanBinHandler
implements BinHandler {
    @Override
    public RexNode createExpression(Bin node, RexNode fieldExpr, CalcitePlanContext context, CalciteRexNodeVisitor visitor2) {
        MinSpanBin minSpanBin = (MinSpanBin)node;
        RexNode minspanValue = visitor2.analyze(minSpanBin.getMinspan(), context);
        if (!minspanValue.isA(SqlKind.LITERAL)) {
            throw new IllegalArgumentException("Minspan must be a literal value");
        }
        Number minspanNum = (Number)((Object)((RexLiteral)minspanValue).getValue());
        double minspan = minspanNum.doubleValue();
        RexNode minValue = context.relBuilder.min(fieldExpr).over().toRex();
        RexNode maxValue = context.relBuilder.max(fieldExpr).over().toRex();
        RexNode dataRange = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.MINUS, maxValue, minValue);
        RexNode startValue = this.convertParameter(minSpanBin.getStart(), context);
        RexNode endValue = this.convertParameter(minSpanBin.getEnd(), context);
        RexLiteral minSpanParam = context.relBuilder.literal(minspan);
        return context.rexBuilder.makeCall(PPLBuiltinOperators.MINSPAN_BUCKET, fieldExpr, minSpanParam, dataRange, maxValue);
    }

    private RexNode convertParameter(UnresolvedExpression expr, CalcitePlanContext context) {
        if (expr == null) {
            return context.relBuilder.literal(-1);
        }
        if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            Object value = literal.getValue();
            if (value instanceof Number) {
                return context.relBuilder.literal(((Number)value).doubleValue());
            }
            return context.relBuilder.literal(value);
        }
        throw new IllegalArgumentException("Expected literal expression, got: " + String.valueOf(expr.getClass()));
    }
}

