/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector.functions.preprocess;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.ml.common.connector.functions.preprocess.ConnectorPreProcessFunction;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.script.ScriptService;

public class RemoteInferencePreProcessFunction
extends ConnectorPreProcessFunction {
    public static final String CONVERT_REMOTE_INFERENCE_PARAM_TO_OBJECT = "pre_process_function.convert_remote_inference_param_to_object";
    private final ScriptService scriptService;
    private final String preProcessFunction;
    private final Map<String, String> params;

    public RemoteInferencePreProcessFunction(ScriptService scriptService, String preProcessFunction, Map<String, String> params) {
        this.returnDirectlyForRemoteInferenceInput = false;
        this.scriptService = scriptService;
        this.preProcessFunction = preProcessFunction;
        this.params = params;
    }

    @Override
    public void validate(MLInput mlInput) {
        if (!(mlInput.getInputDataset() instanceof RemoteInferenceInputDataSet)) {
            throw new IllegalArgumentException("This pre_process_function can only support RemoteInferenceInputDataSet");
        }
    }

    @Override
    public RemoteInferenceInputDataSet process(MLInput mlInput) {
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        Map<String, String> parameters2 = ((RemoteInferenceInputDataSet)mlInput.getInputDataset()).getParameters();
        if (this.params.containsKey(CONVERT_REMOTE_INFERENCE_PARAM_TO_OBJECT) && Boolean.parseBoolean(this.params.get(CONVERT_REMOTE_INFERENCE_PARAM_TO_OBJECT))) {
            for (String key : parameters2.keySet()) {
                if (StringUtils.isJson(parameters2.get(key))) {
                    inputParams.put(key, StringUtils.gson.fromJson(parameters2.get(key), Object.class));
                    continue;
                }
                inputParams.put(key, parameters2.get(key));
            }
        } else {
            inputParams.putAll(parameters2);
        }
        String processedInput = this.executeScript(this.scriptService, this.preProcessFunction, inputParams);
        if (processedInput == null) {
            throw new IllegalArgumentException("Preprocess function output is null");
        }
        Map map = StringUtils.gson.fromJson(processedInput, Map.class);
        return RemoteInferenceInputDataSet.builder().parameters(StringUtils.convertScriptStringToJsonString(map)).build();
    }

    @Generated
    public static RemoteInferencePreProcessFunctionBuilder builder() {
        return new RemoteInferencePreProcessFunctionBuilder();
    }

    @Generated
    public static class RemoteInferencePreProcessFunctionBuilder {
        @Generated
        private ScriptService scriptService;
        @Generated
        private String preProcessFunction;
        @Generated
        private Map<String, String> params;

        @Generated
        RemoteInferencePreProcessFunctionBuilder() {
        }

        @Generated
        public RemoteInferencePreProcessFunctionBuilder scriptService(ScriptService scriptService) {
            this.scriptService = scriptService;
            return this;
        }

        @Generated
        public RemoteInferencePreProcessFunctionBuilder preProcessFunction(String preProcessFunction) {
            this.preProcessFunction = preProcessFunction;
            return this;
        }

        @Generated
        public RemoteInferencePreProcessFunctionBuilder params(Map<String, String> params) {
            this.params = params;
            return this;
        }

        @Generated
        public RemoteInferencePreProcessFunction build() {
            return new RemoteInferencePreProcessFunction(this.scriptService, this.preProcessFunction, this.params);
        }

        @Generated
        public String toString() {
            return "RemoteInferencePreProcessFunction.RemoteInferencePreProcessFunctionBuilder(scriptService=" + String.valueOf(this.scriptService) + ", preProcessFunction=" + this.preProcessFunction + ", params=" + String.valueOf(this.params) + ")";
        }
    }
}

