/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.util;

import java.util.Objects;
import org.apache.calcite.sql.SqlDialect;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import shaded.com.google.common.collect.ImmutableList;

public class SqlString {
    private final String sql;
    private final SqlDialect dialect;
    private final @Nullable ImmutableList<Integer> dynamicParameters;

    public SqlString(SqlDialect dialect, String sql) {
        this(dialect, sql, ImmutableList.of());
    }

    public SqlString(SqlDialect dialect, String sql, @Nullable ImmutableList<Integer> dynamicParameters) {
        this.dialect = Objects.requireNonNull(dialect, "dialect");
        this.sql = Objects.requireNonNull(sql, "sql");
        this.dynamicParameters = dynamicParameters;
    }

    public int hashCode() {
        return this.sql.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof SqlString && this.sql.equals(((SqlString)obj).sql);
    }

    public String toString() {
        return this.sql;
    }

    public String getSql() {
        return this.sql;
    }

    @Pure
    public @Nullable ImmutableList<Integer> getDynamicParameters() {
        return this.dynamicParameters;
    }

    public SqlDialect getDialect() {
        return this.dialect;
    }
}

