/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import java.lang.reflect.Type;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.materialize.MaterializationKey;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MaterializedViewTable
extends ViewTable {
    private final MaterializationKey key;
    public static final CalciteConnection MATERIALIZATION_CONNECTION;

    public MaterializedViewTable(Type elementType, RelProtoDataType relDataType, String viewSql, List<String> viewSchemaPath, @Nullable List<String> viewPath, MaterializationKey key) {
        super(elementType, relDataType, viewSql, viewSchemaPath, viewPath);
        this.key = key;
    }

    public static MaterializedViewTableMacro create(CalciteSchema schema, String viewSql, @Nullable List<String> viewSchemaPath, List<String> viewPath, @Nullable String suggestedTableName, boolean existing) {
        return new MaterializedViewTableMacro(schema, viewSql, viewSchemaPath, viewPath, suggestedTableName, existing);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        Table materializeTable;
        CalciteSchema.TableEntry tableEntry = MaterializationService.instance().checkValid(this.key);
        if (tableEntry != null && (materializeTable = tableEntry.getTable()) instanceof TranslatableTable) {
            TranslatableTable table = (TranslatableTable)materializeTable;
            return table.toRel(context, relOptTable);
        }
        return super.toRel(context, relOptTable);
    }

    static {
        try {
            MATERIALIZATION_CONNECTION = DriverManager.getConnection("jdbc:calcite:").unwrap(CalciteConnection.class);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static class MaterializedViewTableMacro
    extends ViewTableMacro {
        private final MaterializationKey key;

        private MaterializedViewTableMacro(CalciteSchema schema, String viewSql, @Nullable List<String> viewSchemaPath, List<String> viewPath, @Nullable String suggestedTableName, boolean existing) {
            super(schema, viewSql, viewSchemaPath != null ? viewSchemaPath : schema.path(null), viewPath, Boolean.TRUE);
            this.key = Objects.requireNonNull(MaterializationService.instance().defineMaterialization(schema, null, viewSql, this.schemaPath, suggestedTableName, true, existing));
        }

        @Override
        public TranslatableTable apply(List<? extends @Nullable Object> arguments2) {
            assert (arguments2.isEmpty());
            CalcitePrepare.ParseResult parsed = Schemas.parse(MATERIALIZATION_CONNECTION, this.schema, this.schemaPath, this.viewSql);
            List<String> schemaPath1 = this.schemaPath != null ? this.schemaPath : this.schema.path(null);
            JavaTypeFactory typeFactory = MATERIALIZATION_CONNECTION.getTypeFactory();
            return new MaterializedViewTable(typeFactory.getJavaClass(parsed.rowType), RelDataTypeImpl.proto(parsed.rowType), this.viewSql, schemaPath1, this.viewPath, this.key);
        }
    }
}

