/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth;

import java.util.Objects;
import org.opensearch.security.auth.AuthenticationBackend;
import org.opensearch.security.auth.HTTPAuthenticator;

public class AuthDomain
implements Comparable<AuthDomain> {
    private final AuthenticationBackend backend;
    private final HTTPAuthenticator httpAuthenticator;
    private final int order;
    private final boolean challenge;

    public AuthDomain(AuthenticationBackend backend, HTTPAuthenticator httpAuthenticator, boolean challenge, int order) {
        this.backend = Objects.requireNonNull(backend);
        this.httpAuthenticator = httpAuthenticator;
        this.order = order;
        this.challenge = challenge;
    }

    public boolean isChallenge() {
        return this.challenge;
    }

    public AuthenticationBackend getBackend() {
        return this.backend;
    }

    public HTTPAuthenticator getHttpAuthenticator() {
        return this.httpAuthenticator;
    }

    public int getOrder() {
        return this.order;
    }

    public String toString() {
        return "AuthDomain [backend=" + String.valueOf(this.backend) + ", httpAuthenticator=" + String.valueOf(this.httpAuthenticator) + ", order=" + this.order + ", challenge=" + this.challenge + "]";
    }

    @Override
    public int compareTo(AuthDomain o) {
        return Integer.compare(this.order, o.order);
    }
}

