/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.util.VersionInfo;

final class ViaCacheGenerator {
    static final ViaCacheGenerator INSTANCE = new ViaCacheGenerator();
    final ConcurrentMap<ProtocolVersion, String> internalCache = new ConcurrentHashMap<ProtocolVersion, String>(4);

    ViaCacheGenerator() {
    }

    String generateViaHeader(VersionInfo vi, ProtocolVersion pv) {
        StringBuilder buf = new StringBuilder();
        if (!URIScheme.HTTP.same(pv.getProtocol())) {
            buf.append(pv.getProtocol()).append('/');
        }
        buf.append(pv.getMajor()).append('.').append(pv.getMinor());
        buf.append(' ').append("localhost").append(' ');
        buf.append("(Apache-HttpClient/");
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        buf.append(release).append(" (cache))");
        return buf.toString();
    }

    String lookup(ProtocolVersion pv) {
        return this.internalCache.computeIfAbsent(pv, v -> {
            VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.hc.client5", (ClassLoader)this.getClass().getClassLoader());
            return this.generateViaHeader(vi, (ProtocolVersion)v);
        });
    }
}

