/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.greenrobot.eventbus.Logger;

public class ExceptionToResourceMapping {
    public final Map<Class<? extends Throwable>, Integer> throwableToMsgIdMap = new HashMap<Class<? extends Throwable>, Integer>();

    public Integer mapThrowable(Throwable throwable) {
        Throwable throwableToCheck = throwable;
        int depthToGo = 20;
        do {
            Integer resId;
            if ((resId = this.mapThrowableFlat(throwableToCheck)) != null) {
                return resId;
            }
            throwableToCheck = throwableToCheck.getCause();
        } while (--depthToGo > 0 && throwableToCheck != throwable && throwableToCheck != null);
        Logger logger = Logger.Default.get();
        logger.log(Level.FINE, "No specific message resource ID found for " + throwable);
        return null;
    }

    protected Integer mapThrowableFlat(Throwable throwable) {
        Class<?> throwableClass = throwable.getClass();
        Integer resId = this.throwableToMsgIdMap.get(throwableClass);
        if (resId == null) {
            Class<? extends Throwable> closestClass = null;
            Set<Map.Entry<Class<? extends Throwable>, Integer>> mappings = this.throwableToMsgIdMap.entrySet();
            for (Map.Entry<Class<? extends Throwable>, Integer> mapping : mappings) {
                Class<? extends Throwable> candidate = mapping.getKey();
                if (!candidate.isAssignableFrom(throwableClass) || closestClass != null && !closestClass.isAssignableFrom(candidate)) continue;
                closestClass = candidate;
                resId = mapping.getValue();
            }
        }
        return resId;
    }

    public ExceptionToResourceMapping addMapping(Class<? extends Throwable> clazz, int msgId) {
        this.throwableToMsgIdMap.put(clazz, msgId);
        return this;
    }
}

