/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.ldaptive.ssl.AbstractTLSSocketFactory;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.DefaultHostnameVerifier;
import org.ldaptive.ssl.DefaultSSLContextInitializer;
import org.ldaptive.ssl.DefaultTrustManager;
import org.ldaptive.ssl.HostnameVerifierConfig;
import org.ldaptive.ssl.HostnameVerifyingTrustManager;
import org.ldaptive.ssl.SSLContextInitializer;
import org.ldaptive.ssl.SslConfig;

public class TLSSocketFactory
extends AbstractTLSSocketFactory {
    @Override
    public void initialize() throws GeneralSecurityException {
        SSLContextInitializer contextInitializer = this.createSSLContextInitializer();
        this.logger.trace("Using SSLContextInitializer={}", (Object)contextInitializer);
        SSLContext ctx = contextInitializer.initSSLContext("TLS");
        this.factory = ctx.getSocketFactory();
    }

    protected SSLContextInitializer createSSLContextInitializer() throws GeneralSecurityException {
        SSLContextInitializer contextInitializer;
        SslConfig sslConfig = this.getSslConfig();
        if (sslConfig != null) {
            CredentialConfig credConfig = sslConfig.getCredentialConfig();
            TrustManager[] managers = sslConfig.getTrustManagers();
            HostnameVerifierConfig verifierConfig = sslConfig.getHostnameVerifierConfig();
            contextInitializer = credConfig != null ? credConfig.createSSLContextInitializer() : (managers != null ? new DefaultSSLContextInitializer(false) : new DefaultSSLContextInitializer(true));
            if (managers != null) {
                contextInitializer.setTrustManagers(managers);
            }
            if (verifierConfig != null) {
                contextInitializer.setHostnameVerifierConfig(verifierConfig);
            }
        } else {
            contextInitializer = new DefaultSSLContextInitializer();
        }
        return contextInitializer;
    }

    public static SocketFactory getDefault() {
        TLSSocketFactory sf = new TLSSocketFactory();
        try {
            sf.initialize();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Error initializing socket factory", e);
        }
        return sf;
    }

    public static SSLSocketFactory getHostnameVerifierFactory(SslConfig config, String[] names) {
        TLSSocketFactory sf = new TLSSocketFactory();
        if (config != null && !config.isEmpty()) {
            sf.setSslConfig(SslConfig.newSslConfig(config));
        } else {
            sf.setSslConfig(new SslConfig());
        }
        CertificateHostnameVerifier verifier = sf.getSslConfig().getHostnameVerifier();
        if (verifier == null) {
            sf.getSslConfig().setHostnameVerifierConfig(new HostnameVerifierConfig(new DefaultHostnameVerifier(), names));
        } else {
            sf.getSslConfig().setHostnameVerifierConfig(new HostnameVerifierConfig(verifier, names));
        }
        try {
            sf.initialize();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
        return sf;
    }

    @Deprecated
    protected static void addHostnameVerifyingTrustManager(SslConfig config, String[] names) {
        if (config.getTrustManagers() == null) {
            if (config.getCredentialConfig() == null) {
                config.setTrustManagers(new DefaultTrustManager(), new HostnameVerifyingTrustManager(new DefaultHostnameVerifier(), names));
            } else {
                config.setTrustManagers(new HostnameVerifyingTrustManager(new DefaultHostnameVerifier(), names));
            }
        }
    }

    public String toString() {
        return String.format("[%s@%d::factory=%s, sslConfig=%s]", this.getClass().getName(), this.hashCode(), this.getFactory(), this.getSslConfig());
    }
}

