/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources.api.share;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.resources.api.share.ShareAction;
import org.opensearch.security.resources.api.share.ShareRequest;
import org.opensearch.transport.client.node.NodeClient;

public class ShareRestAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(ShareRestAction.class);

    public List<RestHandler.Route> routes() {
        return Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, "/share"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/share"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/share")), "/_plugins/_security/api/resource");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String resourceId = request.param("resource_id");
        String resourceIndex = request.param("resource_type");
        ShareRequest.Builder builder = new ShareRequest.Builder();
        builder.method(request.method());
        if (resourceId != null) {
            builder.resourceIndex(resourceIndex);
        }
        if (resourceIndex != null) {
            builder.resourceId(resourceId);
        }
        if (request.hasContent()) {
            builder.parseContent(request.contentParser());
        }
        ShareRequest shareRequest = builder.build();
        return channel -> client.executeLocally((ActionType)ShareAction.INSTANCE, (ActionRequest)shareRequest, ActionListener.wrap(resp -> Responses.ok(channel, resp::toXContent), e -> this.handleError((RestChannel)channel, (Exception)e)));
    }

    private void handleError(RestChannel channel, Exception e) {
        LOGGER.error("Error while processing request", (Throwable)e);
        String message = e.getMessage();
        if (e instanceof OpenSearchStatusException) {
            OpenSearchStatusException ex = (OpenSearchStatusException)e;
            Responses.response(channel, ex.status(), message);
        } else {
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, message));
        }
    }
}

