/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

import com.selectivem.collections.CheckTableImpl;
import java.util.Set;
import java.util.function.Predicate;

public interface CheckTable<R, C> {
    public static <R, C> CheckTable<R, C> create(R row, Set<C> columns) {
        return CheckTableImpl.create(row, columns);
    }

    public static <R, C> CheckTable<R, C> create(Set<R> rows, C column) {
        return CheckTableImpl.create(rows, column);
    }

    public static <R, C> CheckTable<R, C> create(Set<R> rows, Set<C> columns) {
        return CheckTableImpl.create(rows, columns);
    }

    public boolean check(R var1, C var2);

    public boolean checkIf(R var1, Predicate<C> var2);

    public boolean checkIf(Iterable<R> var1, Predicate<C> var2);

    public boolean checkIf(Predicate<R> var1, C var2);

    public void uncheck(R var1, C var2);

    public void uncheckIf(R var1, Predicate<C> var2);

    public void uncheckIf(Iterable<R> var1, Predicate<C> var2);

    public void uncheckIf(Predicate<R> var1, C var2);

    public void uncheckIf(Predicate<R> var1, Iterable<C> var2);

    public void uncheckRow(R var1);

    public void uncheckRowIfPresent(R var1);

    public void uncheckRowIf(Predicate<R> var1);

    public void uncheckAll();

    public boolean isChecked(R var1, C var2);

    public boolean isRowComplete(R var1);

    public boolean isColumnComplete(C var1);

    public boolean isRowIncomplete(R var1);

    public boolean isColumnIncomplete(C var1);

    public boolean isComplete();

    public boolean isBlank();

    public boolean containsCellFor(R var1, C var2);

    public String toString();

    public String toString(String var1, String var2);

    public String toTableString();

    public String toTableString(String var1, String var2);

    public Set<R> getRows();

    public Set<C> getColumns();

    public Set<R> getCompleteRows();

    public Set<C> getCompleteColumns();

    public Set<R> getIncompleteRows();

    public Set<C> getIncompleteColumns();

    public Set<R> getCheckedRows(C var1);

    public Set<C> getCheckedColumns(R var1);

    public Iterable<R> iterateCheckedRows(C var1);

    public Iterable<C> iterateCheckedColumns(R var1);

    public Iterable<R> iterateUncheckedRows(C var1);

    public Iterable<C> iterateUncheckedColumns(R var1);
}

