/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import io.jsonwebtoken.impl.security.DefaultOctetPublicJwk;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.UnsupportedKeyException;
import java.security.Key;
import java.util.Set;

public abstract class OctetJwkFactory<K extends Key, J extends Jwk<K>>
extends AbstractFamilyJwkFactory<K, J> {
    OctetJwkFactory(Class<K> keyType, Set<Parameter<?>> params) {
        super("OKP", keyType, params);
    }

    @Override
    public boolean supports(Key key) {
        return super.supports(key) && EdwardsCurve.isEdwards(key);
    }

    protected static EdwardsCurve getCurve(ParameterReadable reader) throws UnsupportedKeyException {
        Parameter<String> param = DefaultOctetPublicJwk.CRV;
        String crvId = reader.get(param);
        EdwardsCurve curve = EdwardsCurve.findById(crvId);
        if (curve == null) {
            String msg = "Unrecognized OKP JWK " + param + " value '" + crvId + "'";
            throw new UnsupportedKeyException(msg);
        }
        return curve;
    }
}

