/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.io;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.DOMTypeSupport;
import net.shibboleth.shared.xml.QNameSupport;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class UnmarshallerFactory {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UnmarshallerFactory.class);
    @Nonnull
    private final Map<QName, Unmarshaller> unmarshallers = new ConcurrentHashMap<QName, Unmarshaller>();

    @Nullable
    public Unmarshaller getUnmarshaller(@Nonnull QName key) {
        return this.unmarshallers.get(key);
    }

    @Nullable
    public Unmarshaller getUnmarshaller(@Nonnull Element domElement) {
        Unmarshaller unmarshaller = null;
        QName xsitype = DOMTypeSupport.getXSIType(domElement);
        if (xsitype != null) {
            unmarshaller = this.getUnmarshaller(xsitype);
        }
        if (unmarshaller == null) {
            unmarshaller = this.getUnmarshaller(QNameSupport.getNodeQName(domElement));
        }
        return unmarshaller;
    }

    @Nonnull
    public Unmarshaller ensureUnmarshaller(@Nonnull QName key) {
        Unmarshaller m = this.getUnmarshaller(key);
        if (m != null) {
            return m;
        }
        throw new XMLRuntimeException("Unable to obtain unmarshaller for " + key.toString());
    }

    @Nonnull
    public Unmarshaller ensureUnmarshaller(@Nonnull Element domElement) {
        Unmarshaller m = this.getUnmarshaller(domElement);
        if (m != null) {
            return m;
        }
        throw new XMLRuntimeException("Unable to obtain unmarshaller for " + QNameSupport.getNodeQName(domElement).toString());
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<QName, Unmarshaller> getUnmarshallers() {
        return CollectionSupport.copyToMap(this.unmarshallers);
    }

    public void registerUnmarshaller(@Nonnull QName key, @Nonnull Unmarshaller unmarshaller) {
        Constraint.isNotNull(key, "Unmarshaller key cannot be null");
        Constraint.isNotNull(unmarshaller, "Unmarshaller cannot be null");
        this.log.debug("Registering unmarshaller, {}, for object type, {}", (Object)unmarshaller.getClass().getName(), (Object)key);
        this.unmarshallers.put(key, unmarshaller);
    }

    @Nullable
    public Unmarshaller deregisterUnmarshaller(@Nonnull QName key) {
        this.log.debug("Deregistering marshaller for object type {}", (Object)key);
        return this.unmarshallers.remove(key);
    }
}

