/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.repositories.s3.S3BlobStore;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;

public class S3AsyncDeleteHelper {
    private static final Logger logger = LogManager.getLogger(S3AsyncDeleteHelper.class);

    public static CompletableFuture<Void> executeDeleteChain(S3AsyncClient s3AsyncClient, S3BlobStore blobStore, List<String> objectsToDelete, CompletableFuture<Void> currentChain, Runnable afterDeleteAction) {
        logger.debug("Starting delete chain execution for {} objects", (Object)objectsToDelete.size());
        List<List<String>> batches = S3AsyncDeleteHelper.createDeleteBatches(objectsToDelete, blobStore.getBulkDeletesSize());
        logger.debug("Created {} delete batches", (Object)batches.size());
        CompletionStage newChain = currentChain.thenCompose(v -> S3AsyncDeleteHelper.executeDeleteBatches(s3AsyncClient, blobStore, batches));
        if (afterDeleteAction != null) {
            logger.debug("Adding post-delete action to the chain");
            newChain = ((CompletableFuture)newChain).thenRun(afterDeleteAction);
        }
        return newChain;
    }

    static List<List<String>> createDeleteBatches(List<String> keys, int bulkDeleteSize) {
        ArrayList<List<String>> batches = new ArrayList<List<String>>();
        for (int i = 0; i < keys.size(); i += bulkDeleteSize) {
            int batchSize = Math.min(keys.size() - i, bulkDeleteSize);
            batches.add(keys.subList(i, i + batchSize));
            logger.debug("Created delete batch of size {} starting at index {}", (Object)batchSize, (Object)i);
        }
        return batches;
    }

    static CompletableFuture<Void> executeDeleteBatches(S3AsyncClient s3AsyncClient, S3BlobStore blobStore, List<List<String>> batches) {
        logger.debug("Starting execution of {} delete batches", (Object)batches.size());
        CompletionStage<Object> allDeletesFuture = CompletableFuture.completedFuture(null);
        for (int i = 0; i < batches.size(); ++i) {
            List<String> batch = batches.get(i);
            logger.debug("Queueing batch {} of {} with {} objects", (Object)(i + 1), (Object)batches.size(), (Object)batch.size());
            allDeletesFuture = allDeletesFuture.thenCompose(v -> S3AsyncDeleteHelper.executeSingleDeleteBatch(s3AsyncClient, blobStore, batch));
        }
        return allDeletesFuture.whenComplete((v, throwable) -> {
            if (throwable != null) {
                logger.error("Failed to complete delete batches execution", throwable);
            } else {
                logger.debug("Completed execution of all delete batches");
            }
        });
    }

    static CompletableFuture<Void> executeSingleDeleteBatch(S3AsyncClient s3AsyncClient, S3BlobStore blobStore, List<String> batch) {
        logger.debug("Executing delete batch of {} objects", (Object)batch.size());
        DeleteObjectsRequest deleteRequest = S3AsyncDeleteHelper.bulkDelete(blobStore.bucket(), batch, blobStore);
        return s3AsyncClient.deleteObjects(deleteRequest).thenApply(response -> {
            logger.debug("Received delete response for batch of {} objects", (Object)batch.size());
            return S3AsyncDeleteHelper.processDeleteResponse(response);
        });
    }

    static Void processDeleteResponse(DeleteObjectsResponse deleteObjectsResponse) {
        if (deleteObjectsResponse.errors().isEmpty()) {
            logger.debug("Successfully processed delete response with no errors");
        } else {
            List errorDetails = deleteObjectsResponse.errors().stream().map(s3Error -> "[" + s3Error.key() + "][" + s3Error.code() + "][" + s3Error.message() + "]").collect(Collectors.toList());
            logger.warn(() -> new ParameterizedMessage("Failed to delete {} objects: {}", (Object)deleteObjectsResponse.errors().size(), (Object)errorDetails));
        }
        return null;
    }

    static DeleteObjectsRequest bulkDelete(String bucket, List<String> blobs, S3BlobStore blobStore) {
        logger.debug("Creating bulk delete request for {} objects in bucket {}", (Object)blobs.size(), (Object)bucket);
        return (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete((Delete)Delete.builder().objects((Collection)blobs.stream().map(blob -> (ObjectIdentifier)ObjectIdentifier.builder().key(blob).build()).collect(Collectors.toList())).quiet(Boolean.valueOf(true)).build()).overrideConfiguration(o -> o.addMetricPublisher(blobStore.getStatsMetricPublisher().getDeleteObjectsMetricPublisher())).expectedBucketOwner(blobStore.expectedBucketOwner()).build();
    }
}

