/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.ResourceTypeInfo;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceTypeInfoPBImpl
extends ResourceTypeInfo {
    YarnProtos.ResourceTypeInfoProto proto = YarnProtos.ResourceTypeInfoProto.getDefaultInstance();
    YarnProtos.ResourceTypeInfoProto.Builder builder = null;
    boolean viaProto = false;
    private String name = null;
    private String defaultUnit = null;
    private ResourceTypes resourceTypes = null;

    public ResourceTypeInfoPBImpl() {
        this.builder = YarnProtos.ResourceTypeInfoProto.newBuilder();
    }

    public ResourceTypeInfoPBImpl(YarnProtos.ResourceTypeInfoProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ResourceTypeInfoProto getProto() {
        this.mergeLocalToProto();
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.name != null) {
            this.builder.setName(this.name);
        }
        if (this.defaultUnit != null) {
            this.builder.setUnits(this.defaultUnit);
        }
        if (this.resourceTypes != null) {
            this.builder.setType(ResourceTypeInfoPBImpl.convertToProtoFormat(this.resourceTypes));
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceTypeInfoProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        YarnProtos.ResourceTypeInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getName();
    }

    @Override
    public void setName(String rName) {
        this.maybeInitBuilder();
        if (rName == null) {
            this.builder.clearName();
        }
        this.name = rName;
    }

    @Override
    public String getDefaultUnit() {
        if (this.defaultUnit != null) {
            return this.defaultUnit;
        }
        YarnProtos.ResourceTypeInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getUnits();
    }

    @Override
    public void setDefaultUnit(String rUnits) {
        this.maybeInitBuilder();
        if (rUnits == null) {
            this.builder.clearUnits();
        }
        this.defaultUnit = rUnits;
    }

    @Override
    public ResourceTypes getResourceType() {
        if (this.resourceTypes != null) {
            return this.resourceTypes;
        }
        YarnProtos.ResourceTypeInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return ResourceTypeInfoPBImpl.convertFromProtoFormat(p.getType());
    }

    @Override
    public void setResourceType(ResourceTypes type) {
        this.maybeInitBuilder();
        if (type == null) {
            this.builder.clearType();
        }
        this.resourceTypes = type;
    }

    public static YarnProtos.ResourceTypesProto convertToProtoFormat(ResourceTypes e) {
        return YarnProtos.ResourceTypesProto.valueOf(e.name());
    }

    public static ResourceTypes convertFromProtoFormat(YarnProtos.ResourceTypesProto e) {
        return ResourceTypes.valueOf(e.name());
    }
}

