/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.debugging;

import java.io.PrintStream;
import org.mockito.invocation.DescribedInvocation;
import org.mockito.listeners.InvocationListener;
import org.mockito.listeners.MethodInvocationReport;

public class VerboseMockInvocationLogger
implements InvocationListener {
    final PrintStream printStream;
    private int mockInvocationsCounter = 0;

    public VerboseMockInvocationLogger() {
        this(System.out);
    }

    public VerboseMockInvocationLogger(PrintStream printStream) {
        this.printStream = printStream;
    }

    @Override
    public void reportInvocation(MethodInvocationReport methodInvocationReport) {
        this.printHeader();
        this.printStubInfo(methodInvocationReport);
        this.printInvocation(methodInvocationReport.getInvocation());
        this.printReturnedValueOrThrowable(methodInvocationReport);
        this.printFooter();
    }

    private void printReturnedValueOrThrowable(MethodInvocationReport methodInvocationReport) {
        if (methodInvocationReport.threwException()) {
            String message = methodInvocationReport.getThrowable().getMessage() == null ? "" : " with message " + methodInvocationReport.getThrowable().getMessage();
            this.printlnIndented("has thrown: " + methodInvocationReport.getThrowable().getClass() + message);
        } else {
            String type = methodInvocationReport.getReturnedValue() == null ? "" : " (" + methodInvocationReport.getReturnedValue().getClass().getName() + ")";
            this.printlnIndented("has returned: \"" + methodInvocationReport.getReturnedValue() + "\"" + type);
        }
    }

    private void printStubInfo(MethodInvocationReport methodInvocationReport) {
        if (methodInvocationReport.getLocationOfStubbing() != null) {
            this.printlnIndented("stubbed: " + methodInvocationReport.getLocationOfStubbing());
        }
    }

    private void printHeader() {
        ++this.mockInvocationsCounter;
        this.printStream.println("############ Logging method invocation #" + this.mockInvocationsCounter + " on mock/spy ########");
    }

    private void printInvocation(DescribedInvocation invocation) {
        this.printStream.println(invocation.toString());
        this.printlnIndented("invoked: " + invocation.getLocation().toString());
    }

    private void printFooter() {
        this.printStream.println("");
    }

    private void printlnIndented(String message) {
        this.printStream.println("   " + message);
    }
}

