/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.MessageDigest;
import org.bouncycastle.crypto.OutputDigestCalculator;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsDigestOperatorFactory;
import org.bouncycastle.crypto.fips.FipsSHS;

final class BaseMessageDigest
extends MessageDigest
implements Cloneable {
    private static FipsDigestOperatorFactory<FipsSHS.Parameters> fipsFactory = new FipsSHS.OperatorFactory<FipsSHS.Parameters>();
    private final OutputDigestCalculator digestCalculator;
    private final UpdateOutputStream digestStream;

    protected BaseMessageDigest(FipsSHS.Parameters parameters) {
        this(fipsFactory.createOutputDigestCalculator(parameters));
    }

    BaseMessageDigest(OutputDigestCalculator outputDigestCalculator) {
        super(((Parameters)outputDigestCalculator.getParameters()).getAlgorithm().getName());
        this.digestCalculator = outputDigestCalculator;
        this.digestStream = outputDigestCalculator.getDigestStream();
    }

    @Override
    protected void engineReset() {
        this.digestCalculator.reset();
    }

    @Override
    protected void engineUpdate(byte by) {
        this.digestStream.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.digestStream.update(byArray, n, n2);
    }

    @Override
    protected byte[] engineDigest() {
        byte[] byArray = this.digestCalculator.getDigest();
        this.engineReset();
        return byArray;
    }

    @Override
    protected int engineGetDigestLength() {
        return this.digestCalculator.getDigestSize();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new BaseMessageDigest(this.digestCalculator.clone());
    }
}

