/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import java.security.Permission;
import java.util.HashSet;
import java.util.Set;

public class CryptoServicesPermission
extends Permission {
    public static final String FIPS_EXPORT_KEYS = "exportKeys";
    public static final String FIPS_TLS_ALGORITHMS_ENABLED = "tlsAlgorithmsEnabled";
    public static final String FIPS_MODE_UNAPPROVED_MODE_ENABLED = "unapprovedModeEnabled";
    public static final String FIPS_MODE_CHANGE_TO_APPROVED_MODE_ENABLED = "changeToApprovedModeEnabled";
    public static final String FIPS_MODE_EXPORT_PRIVATE_KEY = "exportPrivateKey";
    public static final String FIPS_MODE_EXPORT_SECRET_KEY = "exportSecretKey";
    public static final String FIPS_MODE_TLS_NULL_DIGEST_ENABLED = "tlsNullDigestEnabled";
    public static final String FIPS_MODE_TLS_PKCS15_KEY_WRAP_ENABLED = "tlsPKCS15KeyWrapEnabled";
    public static final String GLOBAL_CONFIG = "globalConfig";
    public static final String THREAD_LOCAL_CONFIG = "threadLocalConfig";
    public static final String DEFAULT_RANDOM = "defaultRandomConfig";
    private final Set<String> actions = new HashSet<String>();

    public CryptoServicesPermission(String string) {
        super(string);
        if (string.equals(FIPS_EXPORT_KEYS)) {
            this.actions.add(FIPS_MODE_EXPORT_PRIVATE_KEY);
            this.actions.add(FIPS_MODE_EXPORT_SECRET_KEY);
        } else if (string.equals(FIPS_TLS_ALGORITHMS_ENABLED)) {
            this.actions.add(FIPS_MODE_TLS_NULL_DIGEST_ENABLED);
            this.actions.add(FIPS_MODE_TLS_PKCS15_KEY_WRAP_ENABLED);
        } else {
            this.actions.add(string);
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission instanceof CryptoServicesPermission) {
            CryptoServicesPermission cryptoServicesPermission = (CryptoServicesPermission)permission;
            if (this.getName().equals(cryptoServicesPermission.getName())) {
                return true;
            }
            if (this.actions.containsAll(cryptoServicesPermission.actions)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CryptoServicesPermission) {
            CryptoServicesPermission cryptoServicesPermission = (CryptoServicesPermission)object;
            if (this.actions.equals(cryptoServicesPermission.actions)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.actions.hashCode();
    }

    @Override
    public String getActions() {
        return this.actions.toString();
    }
}

