/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.jooq.Configuration;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteType;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.Parameter;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Routine;
import org.jooq.VisitContext;
import org.jooq.VisitListenerProvider;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultVisitListener;
import org.jooq.impl.DefaultVisitListenerProvider;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public class LoggerListener
extends DefaultExecuteListener {
    private static final long serialVersionUID = 7399239846062763212L;
    private static final JooqLogger log = JooqLogger.getLogger(LoggerListener.class);
    private static final int maxLength = 2000;

    @Override
    public void renderEnd(ExecuteContext ctx) {
        if (log.isDebugEnabled()) {
            String newline;
            Configuration configuration = ctx.configuration();
            String string = newline = Boolean.TRUE.equals(configuration.settings().isRenderFormatted()) ? "\n" : "";
            if (!log.isTraceEnabled()) {
                configuration = this.abbreviateBindVariables(configuration);
            }
            String[] batchSQL = ctx.batchSQL();
            if (ctx.query() != null) {
                log.debug((Object)"Executing query", newline + ctx.sql());
                String inlined = DSL.using(configuration).renderInlined(ctx.query());
                if (!ctx.sql().equals(inlined)) {
                    log.debug((Object)"-> with bind values", newline + inlined);
                }
            } else if (ctx.routine() != null) {
                log.debug((Object)"Calling routine", newline + ctx.sql());
                String inlined = DSL.using(configuration).renderInlined(ctx.routine());
                if (!ctx.sql().equals(inlined)) {
                    log.debug((Object)"-> with bind values", newline + inlined);
                }
            } else if (!StringUtils.isBlank(ctx.sql())) {
                if (ctx.type() == ExecuteType.BATCH) {
                    log.debug((Object)"Executing batch query", newline + ctx.sql());
                } else {
                    log.debug((Object)"Executing query", newline + ctx.sql());
                }
            } else if (batchSQL.length > 0 && batchSQL[batchSQL.length - 1] != null) {
                for (String sql : batchSQL) {
                    log.debug((Object)"Executing batch query", newline + sql);
                }
            }
        }
    }

    @Override
    public void recordEnd(ExecuteContext ctx) {
        if (log.isTraceEnabled() && ctx.record() != null) {
            this.logMultiline("Record fetched", ctx.record().toString(), Level.FINER);
        }
    }

    @Override
    public void resultEnd(ExecuteContext ctx) {
        if (ctx.result() != null) {
            if (log.isTraceEnabled()) {
                this.logMultiline("Fetched result", ctx.result().format(500), Level.FINE);
            } else if (log.isDebugEnabled()) {
                this.logMultiline("Fetched result", ctx.result().format(5), Level.FINE);
            }
        }
    }

    @Override
    public void executeEnd(ExecuteContext ctx) {
        if (ctx.rows() >= 0 && log.isDebugEnabled()) {
            log.debug((Object)"Affected row(s)", ctx.rows());
        }
    }

    @Override
    public void outEnd(ExecuteContext ctx) {
        if (ctx.routine() != null && log.isDebugEnabled()) {
            this.logMultiline("Fetched OUT parameters", "" + StringUtils.defaultIfNull(this.record(ctx.configuration(), ctx.routine()), "N/A"), Level.FINE);
        }
    }

    @Override
    public void exception(ExecuteContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exception", ctx.exception());
        }
    }

    private Record record(Configuration configuration, Routine<?> routine) {
        Record result = null;
        ArrayList fields = new ArrayList();
        Parameter<?> returnParam = routine.getReturnParameter();
        if (returnParam != null) {
            fields.add(DSL.field(DSL.name(returnParam.getName()), returnParam.getDataType()));
        }
        for (Parameter<?> param : routine.getOutParameters()) {
            fields.add(DSL.field(DSL.name(param.getName()), param.getDataType()));
        }
        if (fields.size() > 0) {
            result = DSL.using(configuration).newRecord(fields.toArray(new Field[0]));
            int i = 0;
            if (returnParam != null) {
                result.setValue((Field)fields.get(i++), routine.getValue(returnParam));
            }
            for (Parameter<?> param : routine.getOutParameters()) {
                result.setValue((Field)fields.get(i++), routine.getValue(param));
            }
            result.changed(false);
        }
        return result;
    }

    private void logMultiline(String comment, String message, Level level) {
        for (String line : message.split("\n")) {
            if (level == Level.FINE) {
                log.debug((Object)comment, line);
            } else {
                log.trace((Object)comment, line);
            }
            comment = "";
        }
    }

    private final Configuration abbreviateBindVariables(Configuration configuration) {
        VisitListenerProvider[] oldProviders = configuration.visitListenerProviders();
        VisitListenerProvider[] newProviders = new VisitListenerProvider[oldProviders.length + 1];
        System.arraycopy(oldProviders, 0, newProviders, 0, oldProviders.length);
        newProviders[newProviders.length - 1] = new DefaultVisitListenerProvider(new BindValueAbbreviator());
        return configuration.derive(newProviders);
    }

    private static class BindValueAbbreviator
    extends DefaultVisitListener {
        private boolean anyAbbreviations = false;

        private BindValueAbbreviator() {
        }

        @Override
        public void visitStart(VisitContext context) {
            QueryPart part;
            if (context.renderContext() != null && (part = context.queryPart()) instanceof Param) {
                Param param = (Param)part;
                Object value = param.getValue();
                if (value instanceof String && ((String)value).length() > 2000) {
                    this.anyAbbreviations = true;
                    context.queryPart(DSL.val(StringUtils.abbreviate((String)value, 2000)));
                } else if (value instanceof byte[] && ((byte[])value).length > 2000) {
                    this.anyAbbreviations = true;
                    context.queryPart(DSL.val(Arrays.copyOf((byte[])value, 2000)));
                }
            }
        }

        @Override
        public void visitEnd(VisitContext context) {
            if (this.anyAbbreviations && context.queryPartsLength() == 1) {
                context.renderContext().sql(" -- Bind values may have been abbreviated for DEBUG logging. Use TRACE logging for very large bind variables.");
            }
        }
    }
}

