/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Method;
import javax.persistence.AttributeConverter;
import org.jooq.exception.MappingException;
import org.jooq.impl.AbstractConverter;
import org.jooq.tools.reflect.Reflect;

public final class JPAConverter<T, U>
extends AbstractConverter<T, U> {
    private static final long serialVersionUID = -8359212595180862077L;
    private final AttributeConverter<U, T> delegate;

    public JPAConverter(Class<? extends AttributeConverter<U, T>> klass) {
        super(JPAConverter.fromType(klass), JPAConverter.toType(klass));
        try {
            this.delegate = (AttributeConverter)Reflect.on(klass).create().get();
        }
        catch (Exception e) {
            throw new MappingException("Cannot instanciate AttributeConverter", e);
        }
    }

    private static final <T> Class<T> fromType(Class<? extends AttributeConverter<?, T>> klass) {
        for (Method method : klass.getMethods()) {
            if (!"convertToDatabaseColumn".equals(method.getName())) continue;
            return method.getReturnType();
        }
        throw new IllegalArgumentException();
    }

    private static final <U> Class<U> toType(Class<? extends AttributeConverter<U, ?>> klass) {
        for (Method method : klass.getMethods()) {
            if (!"convertToEntityAttribute".equals(method.getName())) continue;
            return method.getReturnType();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final U from(T t) {
        return (U)this.delegate.convertToEntityAttribute(t);
    }

    @Override
    public final T to(U u) {
        return (T)this.delegate.convertToDatabaseColumn(u);
    }
}

