/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.metrics;

import org.jooq.Field;
import org.jooq.Name;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.commons.metrics.MetricDimension;
import org.opensearch.performanceanalyzer.commons.metrics.MetricValue;
import org.opensearch.performanceanalyzer.commons.stats.JooqFieldValue;

public class RTFMetrics {

    public static enum OSMetrics {
        CPU_UTILIZATION("cpu_utilization"),
        HEAP_ALLOCATED("heap_allocated");

        private final String value;

        private OSMetrics(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String CPU_VALUE = "cpu_utilization";
            public static final String HEAP_ALLOCATED = "heap_allocated";
        }
    }

    public static enum MetricUnits {
        CORES("cores"),
        COUNT_PER_SEC("count/s"),
        COUNT("count"),
        PAGES("pages"),
        SEC_PER_CONTEXT_SWITCH("s/ctxswitch"),
        BYTE_PER_SEC("B/s"),
        SEC_PER_EVENT("s/event"),
        MILLISECOND("ms"),
        BYTE("B"),
        PERCENT("%"),
        MEGABYTE_PER_SEC("MB/s"),
        SEGMENT_PER_FLOW("segments/flow"),
        BYTE_PER_FLOW("B/flow"),
        PACKET_PER_SEC("packets/s"),
        RATE("rate");

        private final String value;

        private MetricUnits(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String CORES_VALUE = "cores";
            public static final String COUNT_PER_SEC_VALUE = "count/s";
            public static final String COUNT_VALUE = "count";
            public static final String PAGES_VALUE = "pages";
            public static final String SEC_PER_CONTEXT_SWITCH_VALUE = "s/ctxswitch";
            public static final String BYTE_PER_SEC_VALUE = "B/s";
            public static final String SEC_PER_EVENT_VALUE = "s/event";
            public static final String MILLISECOND_VALUE = "ms";
            public static final String BYTE_VALUE = "B";
            public static final String PERCENT_VALUE = "%";
            public static final String MEGABYTE_PER_SEC_VALUE = "MB/s";
            public static final String SEGMENT_PER_FLOW_VALUE = "segments/flow";
            public static final String BYTE_PER_FLOW_VALUE = "B/flow";
            public static final String PACKET_PER_SEC_VALUE = "packets/s";
            public static final String RATE = "rate";
        }
    }

    public static enum CacheConfigValue implements MetricValue
    {
        CACHE_MAX_SIZE("cache_max_size");

        private final String value;

        private CacheConfigValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String CACHE_MAX_SIZE_VALUE = "cache_max_size";
        }
    }

    public static enum CacheConfigDimension implements MetricDimension,
    JooqFieldValue
    {
        CACHE_TYPE("cache_type");

        private final String value;

        private CacheConfigDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public Field<String> getField() {
            return DSL.field((Name)DSL.name((String)this.value), String.class);
        }

        @Override
        public String getName() {
            return this.value;
        }

        public static class Constants {
            public static final String TYPE_VALUE = "cache_type";
        }
    }

    public static enum ThreadPoolDimension implements MetricDimension,
    JooqFieldValue
    {
        THREAD_POOL_TYPE("threadpool_type");

        private final String value;

        private ThreadPoolDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public Field<String> getField() {
            return DSL.field((Name)DSL.name((String)this.value), String.class);
        }

        @Override
        public String getName() {
            return this.value;
        }

        public static class Constants {
            public static final String TYPE_VALUE = "threadpool_type";
        }
    }

    public static enum CommonDimension implements MetricDimension
    {
        INDEX_NAME("index_name"),
        INDEX_UUID("index_uuid"),
        OPERATION("operation"),
        SHARD_ROLE("shard_role"),
        SHARD_ID("shard_id"),
        EXCEPTION("exception"),
        THREAD_NAME("thread_name"),
        FAILED("failed");

        private final String value;

        private CommonDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String INDEX_NAME_VALUE = "index_name";
            public static final String INDEX_UUID_VALUE = "index_uuid";
            public static final String SHARD_ID_VALUE = "shard_id";
            public static final String OPERATION_VALUE = "operation";
            public static final String SHARD_ROLE_VALUE = "shard_role";
            public static final String EXCEPTION_VALUE = "exception";
            public static final String FAILED_VALUE = "failed";
            public static final String THREAD_NAME = "thread_name";
        }
    }

    public static enum DiskDimension implements MetricDimension
    {
        DISK_NAME("disk_name");

        private final String value;

        private DiskDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String NAME_VALUE = "disk_name";
        }
    }

    public static enum HeapDimension implements MetricDimension,
    JooqFieldValue
    {
        MEM_TYPE("mem_type");

        private final String value;

        private HeapDimension(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public Field<String> getField() {
            return DSL.field((Name)DSL.name((String)this.value), String.class);
        }

        @Override
        public String getName() {
            return this.value;
        }

        public static class Constants {
            public static final String TYPE_VALUE = "mem_type";
        }
    }

    public static enum ShardStatsValue implements MetricValue
    {
        INDEXING_THROTTLE_TIME("indexing_throttle_time"),
        CACHE_QUERY_HIT("cache_query_hit"),
        CACHE_QUERY_MISS("cache_query_miss"),
        CACHE_QUERY_SIZE("cache_query_size"),
        CACHE_FIELDDATA_EVICTION("cache_field_data_eviction"),
        CACHE_FIELDDATA_SIZE("cache_field_data_size"),
        CACHE_REQUEST_HIT("cache_request_hit"),
        CACHE_REQUEST_MISS("cache_request_miss"),
        CACHE_REQUEST_EVICTION("cache_request_eviction"),
        CACHE_REQUEST_SIZE("cache_request_size");

        private final String value;

        private ShardStatsValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String INDEXING_THROTTLE_TIME_VALUE = "indexing_throttle_time";
            public static final String QUEY_CACHE_HIT_COUNT_VALUE = "cache_query_hit";
            public static final String QUERY_CACHE_MISS_COUNT_VALUE = "cache_query_miss";
            public static final String QUERY_CACHE_IN_BYTES_VALUE = "cache_query_size";
            public static final String FIELDDATA_EVICTION_VALUE = "cache_field_data_eviction";
            public static final String FIELD_DATA_IN_BYTES_VALUE = "cache_field_data_size";
            public static final String REQUEST_CACHE_HIT_COUNT_VALUE = "cache_request_hit";
            public static final String REQUEST_CACHE_MISS_COUNT_VALUE = "cache_request_miss";
            public static final String REQUEST_CACHE_EVICTION_VALUE = "cache_request_eviction";
            public static final String REQUEST_CACHE_IN_BYTES_VALUE = "cache_request_size";
        }
    }

    public static enum ThreadPoolValue implements MetricValue
    {
        THREADPOOL_QUEUE_SIZE("threadpool_queue_size"),
        THREADPOOL_REJECTED_REQS("threadpool_rejected_reqs"),
        THREADPOOL_TOTAL_THREADS("threadpool_total_threads"),
        THREADPOOL_ACTIVE_THREADS("threadpool_active_threads"),
        THREADPOOL_QUEUE_LATENCY("threadpool_queue_latency"),
        THREADPOOL_QUEUE_CAPACITY("threadpool_queue_capacity");

        private final String value;

        private ThreadPoolValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String QUEUE_SIZE_VALUE = "threadpool_queue_size";
            public static final String REJECTED_VALUE = "threadpool_rejected_reqs";
            public static final String THREADS_COUNT_VALUE = "threadpool_total_threads";
            public static final String THREADS_ACTIVE_VALUE = "threadpool_active_threads";
            public static final String QUEUE_LATENCY_VALUE = "threadpool_queue_latency";
            public static final String QUEUE_CAPACITY_VALUE = "threadpool_queue_capacity";
        }
    }

    public static enum DiskValue implements MetricValue
    {
        DISK_UTILIZATION("disk_utilization"),
        DISK_WAITTIME("disk_wait_time"),
        DISK_SERVICE_RATE("disk_service_rate");

        private final String value;

        private DiskValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String UTIL_VALUE = "disk_utilization";
            public static final String WAIT_VALUE = "disk_wait_time";
            public static final String SRATE_VALUE = "disk_service_rate";
        }
    }

    public static enum HeapValue implements MetricValue
    {
        GC_COLLECTION_EVENT("gc_collection_event"),
        GC_COLLECTION_TIME("gc_collection_time"),
        HEAP_COMMITTED("heap_committed"),
        HEAP_INIT("heap_init"),
        HEAP_MAX("heap_max"),
        HEAP_USED("heap_used");

        private final String value;

        private HeapValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String COLLECTION_COUNT_VALUE = "gc_collection_event";
            public static final String COLLECTION_TIME_VALUE = "gc_collection_time";
            public static final String COMMITTED_VALUE = "heap_committed";
            public static final String INIT_VALUE = "heap_init";
            public static final String MAX_VALUE = "heap_max";
            public static final String USED_VALUE = "heap_used";
        }
    }

    public static enum GCType {
        TOT_YOUNG_GC("total_young_gc"),
        TOT_FULL_GC("total_full_gc"),
        SURVIVOR("survivor"),
        PERM_GEN("perm_gen"),
        OLD_GEN("old_gen"),
        EDEN("eden"),
        NON_HEAP("non_heap"),
        HEAP("heap");

        private final String value;

        private GCType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static class Constants {
            public static final String TOT_YOUNG_GC_VALUE = "total_young_gc";
            public static final String TOT_FULL_GC_VALUE = "total_full_gc";
            public static final String SURVIVOR_VALUE = "survivor";
            public static final String PERM_GEN_VALUE = "perm_gen";
            public static final String OLD_GEN_VALUE = "old_gen";
            public static final String EDEN_VALUE = "eden";
            public static final String NON_HEAP_VALUE = "non_heap";
            public static final String HEAP_VALUE = "heap";
        }
    }
}

