/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.reindex_rethrottle;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Retries;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ReindexStatus
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ReindexStatus> {
    private final long batches;
    private final long created;
    private final long deleted;
    private final long noops;
    private final float requestsPerSecond;
    @Nonnull
    private final Retries retries;
    @Nullable
    private final Time throttled;
    private final long throttledMillis;
    @Nullable
    private final Time throttledUntil;
    private final long throttledUntilMillis;
    private final long total;
    private final long updated;
    private final long versionConflicts;
    public static final JsonpDeserializer<ReindexStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexStatus::setupReindexStatusDeserializer);

    private ReindexStatus(Builder builder) {
        this.batches = ApiTypeHelper.requireNonNull(builder.batches, this, "batches");
        this.created = ApiTypeHelper.requireNonNull(builder.created, this, "created");
        this.deleted = ApiTypeHelper.requireNonNull(builder.deleted, this, "deleted");
        this.noops = ApiTypeHelper.requireNonNull(builder.noops, this, "noops");
        this.requestsPerSecond = ApiTypeHelper.requireNonNull(builder.requestsPerSecond, this, "requestsPerSecond").floatValue();
        this.retries = ApiTypeHelper.requireNonNull(builder.retries, this, "retries");
        this.throttled = builder.throttled;
        this.throttledMillis = ApiTypeHelper.requireNonNull(builder.throttledMillis, this, "throttledMillis");
        this.throttledUntil = builder.throttledUntil;
        this.throttledUntilMillis = ApiTypeHelper.requireNonNull(builder.throttledUntilMillis, this, "throttledUntilMillis");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.updated = ApiTypeHelper.requireNonNull(builder.updated, this, "updated");
        this.versionConflicts = ApiTypeHelper.requireNonNull(builder.versionConflicts, this, "versionConflicts");
    }

    public static ReindexStatus of(Function<Builder, ObjectBuilder<ReindexStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long batches() {
        return this.batches;
    }

    public final long created() {
        return this.created;
    }

    public final long deleted() {
        return this.deleted;
    }

    public final long noops() {
        return this.noops;
    }

    public final float requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nonnull
    public final Retries retries() {
        return this.retries;
    }

    @Nullable
    public final Time throttled() {
        return this.throttled;
    }

    public final long throttledMillis() {
        return this.throttledMillis;
    }

    @Nullable
    public final Time throttledUntil() {
        return this.throttledUntil;
    }

    public final long throttledUntilMillis() {
        return this.throttledUntilMillis;
    }

    public final long total() {
        return this.total;
    }

    public final long updated() {
        return this.updated;
    }

    public final long versionConflicts() {
        return this.versionConflicts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("batches");
        generator.write(this.batches);
        generator.writeKey("created");
        generator.write(this.created);
        generator.writeKey("deleted");
        generator.write(this.deleted);
        generator.writeKey("noops");
        generator.write(this.noops);
        generator.writeKey("requests_per_second");
        generator.write((double)this.requestsPerSecond);
        generator.writeKey("retries");
        this.retries.serialize(generator, mapper);
        if (this.throttled != null) {
            generator.writeKey("throttled");
            this.throttled.serialize(generator, mapper);
        }
        generator.writeKey("throttled_millis");
        generator.write(this.throttledMillis);
        if (this.throttledUntil != null) {
            generator.writeKey("throttled_until");
            this.throttledUntil.serialize(generator, mapper);
        }
        generator.writeKey("throttled_until_millis");
        generator.write(this.throttledUntilMillis);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("updated");
        generator.write(this.updated);
        generator.writeKey("version_conflicts");
        generator.write(this.versionConflicts);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupReindexStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::batches, JsonpDeserializer.longDeserializer(), "batches");
        op.add(Builder::created, JsonpDeserializer.longDeserializer(), "created");
        op.add(Builder::deleted, JsonpDeserializer.longDeserializer(), "deleted");
        op.add(Builder::noops, JsonpDeserializer.longDeserializer(), "noops");
        op.add(Builder::requestsPerSecond, JsonpDeserializer.floatDeserializer(), "requests_per_second");
        op.add(Builder::retries, Retries._DESERIALIZER, "retries");
        op.add(Builder::throttled, Time._DESERIALIZER, "throttled");
        op.add(Builder::throttledMillis, JsonpDeserializer.longDeserializer(), "throttled_millis");
        op.add(Builder::throttledUntil, Time._DESERIALIZER, "throttled_until");
        op.add(Builder::throttledUntilMillis, JsonpDeserializer.longDeserializer(), "throttled_until_millis");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::updated, JsonpDeserializer.longDeserializer(), "updated");
        op.add(Builder::versionConflicts, JsonpDeserializer.longDeserializer(), "version_conflicts");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this.batches);
        result = 31 * result + Long.hashCode(this.created);
        result = 31 * result + Long.hashCode(this.deleted);
        result = 31 * result + Long.hashCode(this.noops);
        result = 31 * result + Float.hashCode(this.requestsPerSecond);
        result = 31 * result + this.retries.hashCode();
        result = 31 * result + Objects.hashCode(this.throttled);
        result = 31 * result + Long.hashCode(this.throttledMillis);
        result = 31 * result + Objects.hashCode(this.throttledUntil);
        result = 31 * result + Long.hashCode(this.throttledUntilMillis);
        result = 31 * result + Long.hashCode(this.total);
        result = 31 * result + Long.hashCode(this.updated);
        result = 31 * result + Long.hashCode(this.versionConflicts);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReindexStatus other = (ReindexStatus)o;
        return this.batches == other.batches && this.created == other.created && this.deleted == other.deleted && this.noops == other.noops && this.requestsPerSecond == other.requestsPerSecond && this.retries.equals(other.retries) && Objects.equals(this.throttled, other.throttled) && this.throttledMillis == other.throttledMillis && Objects.equals(this.throttledUntil, other.throttledUntil) && this.throttledUntilMillis == other.throttledUntilMillis && this.total == other.total && this.updated == other.updated && this.versionConflicts == other.versionConflicts;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ReindexStatus> {
        private Long batches;
        private Long created;
        private Long deleted;
        private Long noops;
        private Float requestsPerSecond;
        private Retries retries;
        @Nullable
        private Time throttled;
        private Long throttledMillis;
        @Nullable
        private Time throttledUntil;
        private Long throttledUntilMillis;
        private Long total;
        private Long updated;
        private Long versionConflicts;

        public Builder() {
        }

        private Builder(ReindexStatus o) {
            this.batches = o.batches;
            this.created = o.created;
            this.deleted = o.deleted;
            this.noops = o.noops;
            this.requestsPerSecond = Float.valueOf(o.requestsPerSecond);
            this.retries = o.retries;
            this.throttled = o.throttled;
            this.throttledMillis = o.throttledMillis;
            this.throttledUntil = o.throttledUntil;
            this.throttledUntilMillis = o.throttledUntilMillis;
            this.total = o.total;
            this.updated = o.updated;
            this.versionConflicts = o.versionConflicts;
        }

        private Builder(Builder o) {
            this.batches = o.batches;
            this.created = o.created;
            this.deleted = o.deleted;
            this.noops = o.noops;
            this.requestsPerSecond = o.requestsPerSecond;
            this.retries = o.retries;
            this.throttled = o.throttled;
            this.throttledMillis = o.throttledMillis;
            this.throttledUntil = o.throttledUntil;
            this.throttledUntilMillis = o.throttledUntilMillis;
            this.total = o.total;
            this.updated = o.updated;
            this.versionConflicts = o.versionConflicts;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder batches(long value) {
            this.batches = value;
            return this;
        }

        @Nonnull
        public final Builder created(long value) {
            this.created = value;
            return this;
        }

        @Nonnull
        public final Builder deleted(long value) {
            this.deleted = value;
            return this;
        }

        @Nonnull
        public final Builder noops(long value) {
            this.noops = value;
            return this;
        }

        @Nonnull
        public final Builder requestsPerSecond(float value) {
            this.requestsPerSecond = Float.valueOf(value);
            return this;
        }

        @Nonnull
        public final Builder retries(Retries value) {
            this.retries = value;
            return this;
        }

        @Nonnull
        public final Builder retries(Function<Retries.Builder, ObjectBuilder<Retries>> fn) {
            return this.retries(fn.apply(new Retries.Builder()).build());
        }

        @Nonnull
        public final Builder throttled(@Nullable Time value) {
            this.throttled = value;
            return this;
        }

        @Nonnull
        public final Builder throttled(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttled(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder throttledMillis(long value) {
            this.throttledMillis = value;
            return this;
        }

        @Nonnull
        public final Builder throttledUntil(@Nullable Time value) {
            this.throttledUntil = value;
            return this;
        }

        @Nonnull
        public final Builder throttledUntil(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttledUntil(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder throttledUntilMillis(long value) {
            this.throttledUntilMillis = value;
            return this;
        }

        @Nonnull
        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder updated(long value) {
            this.updated = value;
            return this;
        }

        @Nonnull
        public final Builder versionConflicts(long value) {
            this.versionConflicts = value;
            return this;
        }

        @Override
        @Nonnull
        public ReindexStatus build() {
            this._checkSingleUse();
            return new ReindexStatus(this);
        }
    }
}

