/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Conflicts;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.SearchType;
import org.opensearch.client.opensearch._types.SlicedScroll;
import org.opensearch.client.opensearch._types.Slices;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.WaitForActiveShards;
import org.opensearch.client.opensearch._types.query_dsl.Operator;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.UpdateByQueryResponse;
import org.opensearch.client.opensearch.core.search.SourceConfigParam;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class UpdateByQueryRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, UpdateByQueryRequest> {
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Conflicts conflicts;
    @Nullable
    private final Operator defaultOperator;
    @Nullable
    private final String df;
    @Nonnull
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Integer from;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nonnull
    private final List<String> index;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final Integer maxDocs;
    @Nullable
    private final String pipeline;
    @Nullable
    private final String preference;
    @Nullable
    private final String q;
    @Nullable
    private final Query query;
    @Nullable
    private final Refresh refresh;
    @Nullable
    private final Boolean requestCache;
    @Nullable
    private final Float requestsPerSecond;
    @Nonnull
    private final List<String> routing;
    @Nullable
    private final Script script;
    @Nullable
    private final Time scroll;
    @Nullable
    private final Integer scrollSize;
    @Nullable
    private final Time searchTimeout;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final Integer size;
    @Nullable
    private final SlicedScroll slice;
    @Nullable
    private final Slices slices;
    @Nonnull
    private final List<String> sort;
    @Nullable
    private final SourceConfigParam source;
    @Nonnull
    private final List<String> sourceExcludes;
    @Nonnull
    private final List<String> sourceIncludes;
    @Nonnull
    private final List<String> stats;
    @Nullable
    private final Integer terminateAfter;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Boolean version;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    @Nullable
    private final Boolean waitForCompletion;
    public static final JsonpDeserializer<UpdateByQueryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateByQueryRequest::setupUpdateByQueryRequestDeserializer);
    public static final Endpoint<UpdateByQueryRequest, UpdateByQueryResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateByQueryRequest, UpdateByQueryResponse>(request -> "POST", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/");
        SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
        buf.append("/_update_by_query");
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateByQueryResponse._DESERIALIZER);

    private UpdateByQueryRequest(Builder builder) {
        super(builder);
        this.allowNoIndices = builder.allowNoIndices;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.analyzer = builder.analyzer;
        this.conflicts = builder.conflicts;
        this.defaultOperator = builder.defaultOperator;
        this.df = builder.df;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.from = builder.from;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.lenient = builder.lenient;
        this.maxDocs = builder.maxDocs;
        this.pipeline = builder.pipeline;
        this.preference = builder.preference;
        this.q = builder.q;
        this.query = builder.query;
        this.refresh = builder.refresh;
        this.requestCache = builder.requestCache;
        this.requestsPerSecond = builder.requestsPerSecond;
        this.routing = ApiTypeHelper.unmodifiable(builder.routing);
        this.script = builder.script;
        this.scroll = builder.scroll;
        this.scrollSize = builder.scrollSize;
        this.searchTimeout = builder.searchTimeout;
        this.searchType = builder.searchType;
        this.size = builder.size;
        this.slice = builder.slice;
        this.slices = builder.slices;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
        this.source = builder.source;
        this.sourceExcludes = ApiTypeHelper.unmodifiable(builder.sourceExcludes);
        this.sourceIncludes = ApiTypeHelper.unmodifiable(builder.sourceIncludes);
        this.stats = ApiTypeHelper.unmodifiable(builder.stats);
        this.terminateAfter = builder.terminateAfter;
        this.timeout = builder.timeout;
        this.version = builder.version;
        this.waitForActiveShards = builder.waitForActiveShards;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static UpdateByQueryRequest of(Function<Builder, ObjectBuilder<UpdateByQueryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Conflicts conflicts() {
        return this.conflicts;
    }

    @Nullable
    public final Operator defaultOperator() {
        return this.defaultOperator;
    }

    @Nullable
    public final String df() {
        return this.df;
    }

    @Nonnull
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public final Integer maxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final String q() {
        return this.q;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Nullable
    public final Boolean requestCache() {
        return this.requestCache;
    }

    @Nullable
    public final Float requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nonnull
    public final List<String> routing() {
        return this.routing;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Time scroll() {
        return this.scroll;
    }

    @Nullable
    public final Integer scrollSize() {
        return this.scrollSize;
    }

    @Nullable
    public final Time searchTimeout() {
        return this.searchTimeout;
    }

    @Nullable
    public final SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final SlicedScroll slice() {
        return this.slice;
    }

    @Nullable
    public final Slices slices() {
        return this.slices;
    }

    @Nonnull
    public final List<String> sort() {
        return this.sort;
    }

    @Nullable
    public final SourceConfigParam source() {
        return this.source;
    }

    @Nonnull
    public final List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    @Nonnull
    public final List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    @Nonnull
    public final List<String> stats() {
        return this.stats;
    }

    @Nullable
    public final Integer terminateAfter() {
        return this.terminateAfter;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Boolean version() {
        return this.version;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.conflicts != null) {
            generator.writeKey("conflicts");
            this.conflicts.serialize(generator, mapper);
        }
        if (this.maxDocs != null) {
            generator.writeKey("max_docs");
            generator.write(this.maxDocs.intValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.slice != null) {
            generator.writeKey("slice");
            this.slice.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUpdateByQueryRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::conflicts, Conflicts._DESERIALIZER, "conflicts");
        op.add(Builder::maxDocs, JsonpDeserializer.integerDeserializer(), "max_docs");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::slice, SlicedScroll._DESERIALIZER, "slice");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(this.allowNoIndices));
        }
        if (this.analyzeWildcard != null) {
            params.put("analyze_wildcard", String.valueOf(this.analyzeWildcard));
        }
        if (this.analyzer != null) {
            params.put("analyzer", this.analyzer);
        }
        if (this.defaultOperator != null) {
            params.put("default_operator", this.defaultOperator.jsonValue());
        }
        if (this.df != null) {
            params.put("df", this.df);
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            params.put("expand_wildcards", this.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (this.from != null) {
            params.put("from", String.valueOf(this.from));
        }
        if (this.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(this.ignoreUnavailable));
        }
        if (this.lenient != null) {
            params.put("lenient", String.valueOf(this.lenient));
        }
        if (this.pipeline != null) {
            params.put("pipeline", this.pipeline);
        }
        if (this.preference != null) {
            params.put("preference", this.preference);
        }
        if (this.q != null) {
            params.put("q", this.q);
        }
        if (this.refresh != null) {
            params.put("refresh", this.refresh.jsonValue());
        }
        if (this.requestCache != null) {
            params.put("request_cache", String.valueOf(this.requestCache));
        }
        if (this.requestsPerSecond != null) {
            params.put("requests_per_second", String.valueOf(this.requestsPerSecond));
        }
        if (ApiTypeHelper.isDefined(this.routing)) {
            params.put("routing", String.join((CharSequence)",", this.routing));
        }
        if (this.scroll != null) {
            params.put("scroll", this.scroll._toJsonString());
        }
        if (this.scrollSize != null) {
            params.put("scroll_size", String.valueOf(this.scrollSize));
        }
        if (this.searchTimeout != null) {
            params.put("search_timeout", this.searchTimeout._toJsonString());
        }
        if (this.searchType != null) {
            params.put("search_type", this.searchType.jsonValue());
        }
        if (this.size != null) {
            params.put("size", String.valueOf(this.size));
        }
        if (this.slices != null) {
            params.put("slices", this.slices._toJsonString());
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            params.put("sort", String.join((CharSequence)",", this.sort));
        }
        if (this.source != null) {
            params.put("_source", this.source._toJsonString());
        }
        if (ApiTypeHelper.isDefined(this.sourceExcludes)) {
            params.put("_source_excludes", String.join((CharSequence)",", this.sourceExcludes));
        }
        if (ApiTypeHelper.isDefined(this.sourceIncludes)) {
            params.put("_source_includes", String.join((CharSequence)",", this.sourceIncludes));
        }
        if (ApiTypeHelper.isDefined(this.stats)) {
            params.put("stats", String.join((CharSequence)",", this.stats));
        }
        if (this.terminateAfter != null) {
            params.put("terminate_after", String.valueOf(this.terminateAfter));
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
        if (this.version != null) {
            params.put("version", String.valueOf(this.version));
        }
        if (this.waitForActiveShards != null) {
            params.put("wait_for_active_shards", this.waitForActiveShards._toJsonString());
        }
        if (this.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(this.waitForCompletion));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowNoIndices);
        result = 31 * result + Objects.hashCode(this.analyzeWildcard);
        result = 31 * result + Objects.hashCode(this.analyzer);
        result = 31 * result + Objects.hashCode(this.conflicts);
        result = 31 * result + Objects.hashCode(this.defaultOperator);
        result = 31 * result + Objects.hashCode(this.df);
        result = 31 * result + Objects.hashCode(this.expandWildcards);
        result = 31 * result + Objects.hashCode(this.from);
        result = 31 * result + Objects.hashCode(this.ignoreUnavailable);
        result = 31 * result + this.index.hashCode();
        result = 31 * result + Objects.hashCode(this.lenient);
        result = 31 * result + Objects.hashCode(this.maxDocs);
        result = 31 * result + Objects.hashCode(this.pipeline);
        result = 31 * result + Objects.hashCode(this.preference);
        result = 31 * result + Objects.hashCode(this.q);
        result = 31 * result + Objects.hashCode(this.query);
        result = 31 * result + Objects.hashCode(this.refresh);
        result = 31 * result + Objects.hashCode(this.requestCache);
        result = 31 * result + Objects.hashCode(this.requestsPerSecond);
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.script);
        result = 31 * result + Objects.hashCode(this.scroll);
        result = 31 * result + Objects.hashCode(this.scrollSize);
        result = 31 * result + Objects.hashCode(this.searchTimeout);
        result = 31 * result + Objects.hashCode(this.searchType);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.slice);
        result = 31 * result + Objects.hashCode(this.slices);
        result = 31 * result + Objects.hashCode(this.sort);
        result = 31 * result + Objects.hashCode(this.source);
        result = 31 * result + Objects.hashCode(this.sourceExcludes);
        result = 31 * result + Objects.hashCode(this.sourceIncludes);
        result = 31 * result + Objects.hashCode(this.stats);
        result = 31 * result + Objects.hashCode(this.terminateAfter);
        result = 31 * result + Objects.hashCode(this.timeout);
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.waitForActiveShards);
        result = 31 * result + Objects.hashCode(this.waitForCompletion);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateByQueryRequest other = (UpdateByQueryRequest)o;
        return Objects.equals(this.allowNoIndices, other.allowNoIndices) && Objects.equals(this.analyzeWildcard, other.analyzeWildcard) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.conflicts, other.conflicts) && Objects.equals(this.defaultOperator, other.defaultOperator) && Objects.equals(this.df, other.df) && Objects.equals(this.expandWildcards, other.expandWildcards) && Objects.equals(this.from, other.from) && Objects.equals(this.ignoreUnavailable, other.ignoreUnavailable) && this.index.equals(other.index) && Objects.equals(this.lenient, other.lenient) && Objects.equals(this.maxDocs, other.maxDocs) && Objects.equals(this.pipeline, other.pipeline) && Objects.equals(this.preference, other.preference) && Objects.equals(this.q, other.q) && Objects.equals(this.query, other.query) && Objects.equals(this.refresh, other.refresh) && Objects.equals(this.requestCache, other.requestCache) && Objects.equals(this.requestsPerSecond, other.requestsPerSecond) && Objects.equals(this.routing, other.routing) && Objects.equals(this.script, other.script) && Objects.equals(this.scroll, other.scroll) && Objects.equals(this.scrollSize, other.scrollSize) && Objects.equals(this.searchTimeout, other.searchTimeout) && Objects.equals(this.searchType, other.searchType) && Objects.equals(this.size, other.size) && Objects.equals(this.slice, other.slice) && Objects.equals(this.slices, other.slices) && Objects.equals(this.sort, other.sort) && Objects.equals(this.source, other.source) && Objects.equals(this.sourceExcludes, other.sourceExcludes) && Objects.equals(this.sourceIncludes, other.sourceIncludes) && Objects.equals(this.stats, other.stats) && Objects.equals(this.terminateAfter, other.terminateAfter) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.version, other.version) && Objects.equals(this.waitForActiveShards, other.waitForActiveShards) && Objects.equals(this.waitForCompletion, other.waitForCompletion);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, UpdateByQueryRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private String analyzer;
        @Nullable
        private Conflicts conflicts;
        @Nullable
        private Operator defaultOperator;
        @Nullable
        private String df;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Integer from;
        @Nullable
        private Boolean ignoreUnavailable;
        private List<String> index;
        @Nullable
        private Boolean lenient;
        @Nullable
        private Integer maxDocs;
        @Nullable
        private String pipeline;
        @Nullable
        private String preference;
        @Nullable
        private String q;
        @Nullable
        private Query query;
        @Nullable
        private Refresh refresh;
        @Nullable
        private Boolean requestCache;
        @Nullable
        private Float requestsPerSecond;
        @Nullable
        private List<String> routing;
        @Nullable
        private Script script;
        @Nullable
        private Time scroll;
        @Nullable
        private Integer scrollSize;
        @Nullable
        private Time searchTimeout;
        @Nullable
        private SearchType searchType;
        @Nullable
        private Integer size;
        @Nullable
        private SlicedScroll slice;
        @Nullable
        private Slices slices;
        @Nullable
        private List<String> sort;
        @Nullable
        private SourceConfigParam source;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        @Nullable
        private List<String> stats;
        @Nullable
        private Integer terminateAfter;
        @Nullable
        private Time timeout;
        @Nullable
        private Boolean version;
        @Nullable
        private WaitForActiveShards waitForActiveShards;
        @Nullable
        private Boolean waitForCompletion;

        public Builder() {
        }

        private Builder(UpdateByQueryRequest o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.analyzeWildcard = o.analyzeWildcard;
            this.analyzer = o.analyzer;
            this.conflicts = o.conflicts;
            this.defaultOperator = o.defaultOperator;
            this.df = o.df;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.from = o.from;
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.lenient = o.lenient;
            this.maxDocs = o.maxDocs;
            this.pipeline = o.pipeline;
            this.preference = o.preference;
            this.q = o.q;
            this.query = o.query;
            this.refresh = o.refresh;
            this.requestCache = o.requestCache;
            this.requestsPerSecond = o.requestsPerSecond;
            this.routing = Builder._listCopy(o.routing);
            this.script = o.script;
            this.scroll = o.scroll;
            this.scrollSize = o.scrollSize;
            this.searchTimeout = o.searchTimeout;
            this.searchType = o.searchType;
            this.size = o.size;
            this.slice = o.slice;
            this.slices = o.slices;
            this.sort = Builder._listCopy(o.sort);
            this.source = o.source;
            this.sourceExcludes = Builder._listCopy(o.sourceExcludes);
            this.sourceIncludes = Builder._listCopy(o.sourceIncludes);
            this.stats = Builder._listCopy(o.stats);
            this.terminateAfter = o.terminateAfter;
            this.timeout = o.timeout;
            this.version = o.version;
            this.waitForActiveShards = o.waitForActiveShards;
            this.waitForCompletion = o.waitForCompletion;
        }

        private Builder(Builder o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.analyzeWildcard = o.analyzeWildcard;
            this.analyzer = o.analyzer;
            this.conflicts = o.conflicts;
            this.defaultOperator = o.defaultOperator;
            this.df = o.df;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.from = o.from;
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.lenient = o.lenient;
            this.maxDocs = o.maxDocs;
            this.pipeline = o.pipeline;
            this.preference = o.preference;
            this.q = o.q;
            this.query = o.query;
            this.refresh = o.refresh;
            this.requestCache = o.requestCache;
            this.requestsPerSecond = o.requestsPerSecond;
            this.routing = Builder._listCopy(o.routing);
            this.script = o.script;
            this.scroll = o.scroll;
            this.scrollSize = o.scrollSize;
            this.searchTimeout = o.searchTimeout;
            this.searchType = o.searchType;
            this.size = o.size;
            this.slice = o.slice;
            this.slices = o.slices;
            this.sort = Builder._listCopy(o.sort);
            this.source = o.source;
            this.sourceExcludes = Builder._listCopy(o.sourceExcludes);
            this.sourceIncludes = Builder._listCopy(o.sourceIncludes);
            this.stats = Builder._listCopy(o.stats);
            this.terminateAfter = o.terminateAfter;
            this.timeout = o.timeout;
            this.version = o.version;
            this.waitForActiveShards = o.waitForActiveShards;
            this.waitForCompletion = o.waitForCompletion;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        @Nonnull
        public final Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        @Nonnull
        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        @Nonnull
        public final Builder conflicts(@Nullable Conflicts value) {
            this.conflicts = value;
            return this;
        }

        @Nonnull
        public final Builder defaultOperator(@Nullable Operator value) {
            this.defaultOperator = value;
            return this;
        }

        @Nonnull
        public final Builder df(@Nullable String value) {
            this.df = value;
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Nonnull
        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Nonnull
        public final Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        @Nonnull
        public final Builder maxDocs(@Nullable Integer value) {
            this.maxDocs = value;
            return this;
        }

        @Nonnull
        public final Builder pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        @Nonnull
        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        @Nonnull
        public final Builder q(@Nullable String value) {
            this.q = value;
            return this;
        }

        @Nonnull
        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        @Nonnull
        public final Builder requestCache(@Nullable Boolean value) {
            this.requestCache = value;
            return this;
        }

        @Nonnull
        public final Builder requestsPerSecond(@Nullable Float value) {
            this.requestsPerSecond = value;
            return this;
        }

        @Nonnull
        public final Builder routing(List<String> list) {
            this.routing = Builder._listAddAll(this.routing, list);
            return this;
        }

        @Nonnull
        public final Builder routing(String value, String ... values) {
            this.routing = Builder._listAdd(this.routing, value, values);
            return this;
        }

        @Nonnull
        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Nonnull
        public final Builder scroll(@Nullable Time value) {
            this.scroll = value;
            return this;
        }

        @Nonnull
        public final Builder scroll(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.scroll(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder scrollSize(@Nullable Integer value) {
            this.scrollSize = value;
            return this;
        }

        @Nonnull
        public final Builder searchTimeout(@Nullable Time value) {
            this.searchTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder searchTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.searchTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        @Nonnull
        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder slice(@Nullable SlicedScroll value) {
            this.slice = value;
            return this;
        }

        @Nonnull
        public final Builder slice(Function<SlicedScroll.Builder, ObjectBuilder<SlicedScroll>> fn) {
            return this.slice(fn.apply(new SlicedScroll.Builder()).build());
        }

        @Nonnull
        public final Builder slices(@Nullable Slices value) {
            this.slices = value;
            return this;
        }

        @Nonnull
        public final Builder slices(Function<Slices.Builder, ObjectBuilder<Slices>> fn) {
            return this.slices(fn.apply(new Slices.Builder()).build());
        }

        @Nonnull
        public final Builder sort(List<String> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        @Nonnull
        public final Builder sort(String value, String ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        @Nonnull
        public final Builder source(@Nullable SourceConfigParam value) {
            this.source = value;
            return this;
        }

        @Nonnull
        public final Builder source(Function<SourceConfigParam.Builder, ObjectBuilder<SourceConfigParam>> fn) {
            return this.source(fn.apply(new SourceConfigParam.Builder()).build());
        }

        @Nonnull
        public final Builder sourceExcludes(List<String> list) {
            this.sourceExcludes = Builder._listAddAll(this.sourceExcludes, list);
            return this;
        }

        @Nonnull
        public final Builder sourceExcludes(String value, String ... values) {
            this.sourceExcludes = Builder._listAdd(this.sourceExcludes, value, values);
            return this;
        }

        @Nonnull
        public final Builder sourceIncludes(List<String> list) {
            this.sourceIncludes = Builder._listAddAll(this.sourceIncludes, list);
            return this;
        }

        @Nonnull
        public final Builder sourceIncludes(String value, String ... values) {
            this.sourceIncludes = Builder._listAdd(this.sourceIncludes, value, values);
            return this;
        }

        @Nonnull
        public final Builder stats(List<String> list) {
            this.stats = Builder._listAddAll(this.stats, list);
            return this;
        }

        @Nonnull
        public final Builder stats(String value, String ... values) {
            this.stats = Builder._listAdd(this.stats, value, values);
            return this;
        }

        @Nonnull
        public final Builder terminateAfter(@Nullable Integer value) {
            this.terminateAfter = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder version(@Nullable Boolean value) {
            this.version = value;
            return this;
        }

        @Nonnull
        public final Builder waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        @Nonnull
        public final Builder waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        @Nonnull
        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        @Nonnull
        public UpdateByQueryRequest build() {
            this._checkSingleUse();
            return new UpdateByQueryRequest(this);
        }
    }
}

