/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.cluster.PutComponentTemplateResponse;
import org.opensearch.client.opensearch.indices.IndexState;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PutComponentTemplateRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PutComponentTemplateRequest> {
    @Nullable
    private final Boolean allowAutoCreate;
    @Nullable
    private final Time clusterManagerTimeout;
    @Nullable
    private final Boolean create;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nonnull
    private final Map<String, JsonData> meta;
    @Nonnull
    private final String name;
    @Nonnull
    private final IndexState template;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<PutComponentTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutComponentTemplateRequest::setupPutComponentTemplateRequestDeserializer);
    public static final Endpoint<PutComponentTemplateRequest, PutComponentTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutComponentTemplateRequest, PutComponentTemplateResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_component_template/");
        SimpleEndpoint.pathEncode(request.name, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutComponentTemplateResponse._DESERIALIZER);

    private PutComponentTemplateRequest(Builder builder) {
        super(builder);
        this.allowAutoCreate = builder.allowAutoCreate;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.create = builder.create;
        this.masterTimeout = builder.masterTimeout;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.template = ApiTypeHelper.requireNonNull(builder.template, this, "template");
        this.timeout = builder.timeout;
        this.version = builder.version;
    }

    public static PutComponentTemplateRequest of(Function<Builder, ObjectBuilder<PutComponentTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowAutoCreate() {
        return this.allowAutoCreate;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nullable
    public final Boolean create() {
        return this.create;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nonnull
    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nonnull
    public final IndexState template() {
        return this.template;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowAutoCreate != null) {
            generator.writeKey("allow_auto_create");
            generator.write(this.allowAutoCreate.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("template");
        this.template.serialize(generator, mapper);
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPutComponentTemplateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowAutoCreate, JsonpDeserializer.booleanDeserializer(), "allow_auto_create");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::template, IndexState._DESERIALIZER, "template");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.create != null) {
            params.put("create", String.valueOf(this.create));
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowAutoCreate);
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.create);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.meta);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.template.hashCode();
        result = 31 * result + Objects.hashCode(this.timeout);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutComponentTemplateRequest other = (PutComponentTemplateRequest)o;
        return Objects.equals(this.allowAutoCreate, other.allowAutoCreate) && Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.create, other.create) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.meta, other.meta) && this.name.equals(other.name) && this.template.equals(other.template) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PutComponentTemplateRequest> {
        @Nullable
        private Boolean allowAutoCreate;
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private Boolean create;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Map<String, JsonData> meta;
        private String name;
        private IndexState template;
        @Nullable
        private Time timeout;
        @Nullable
        private Long version;

        public Builder() {
        }

        private Builder(PutComponentTemplateRequest o) {
            super(o);
            this.allowAutoCreate = o.allowAutoCreate;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.create = o.create;
            this.masterTimeout = o.masterTimeout;
            this.meta = Builder._mapCopy(o.meta);
            this.name = o.name;
            this.template = o.template;
            this.timeout = o.timeout;
            this.version = o.version;
        }

        private Builder(Builder o) {
            super(o);
            this.allowAutoCreate = o.allowAutoCreate;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.create = o.create;
            this.masterTimeout = o.masterTimeout;
            this.meta = Builder._mapCopy(o.meta);
            this.name = o.name;
            this.template = o.template;
            this.timeout = o.timeout;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder allowAutoCreate(@Nullable Boolean value) {
            this.allowAutoCreate = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder create(@Nullable Boolean value) {
            this.create = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        @Nonnull
        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder template(IndexState value) {
            this.template = value;
            return this;
        }

        @Nonnull
        public final Builder template(Function<IndexState.Builder, ObjectBuilder<IndexState>> fn) {
            return this.template(fn.apply(new IndexState.Builder()).build());
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public PutComponentTemplateRequest build() {
            this._checkSingleUse();
            return new PutComponentTemplateRequest(this);
        }
    }
}

