/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.KnnQueryRescore;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class KnnQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, KnnQuery> {
    @Nullable
    private final Boolean expandNestedDocs;
    @Nonnull
    private final String field;
    @Nullable
    private final Query filter;
    @Nullable
    private final Integer k;
    @Nullable
    private final Float maxDistance;
    @Nonnull
    private final Map<String, JsonData> methodParameters;
    @Nullable
    private final Float minScore;
    @Nullable
    private final KnnQueryRescore rescore;
    @Nonnull
    private final List<Float> vector;
    public static final JsonpDeserializer<KnnQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnQuery::setupKnnQueryDeserializer);

    private KnnQuery(Builder builder) {
        super(builder);
        this.expandNestedDocs = builder.expandNestedDocs;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.filter = builder.filter;
        this.k = builder.k;
        this.maxDistance = builder.maxDistance;
        this.methodParameters = ApiTypeHelper.unmodifiable(builder.methodParameters);
        this.minScore = builder.minScore;
        this.rescore = builder.rescore;
        this.vector = ApiTypeHelper.unmodifiableRequired(builder.vector, (Object)this, "vector");
    }

    public static KnnQuery of(Function<Builder, ObjectBuilder<KnnQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Knn;
    }

    @Nullable
    public final Boolean expandNestedDocs() {
        return this.expandNestedDocs;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Nullable
    public final Integer k() {
        return this.k;
    }

    @Nullable
    public final Float maxDistance() {
        return this.maxDistance;
    }

    @Nonnull
    public final Map<String, JsonData> methodParameters() {
        return this.methodParameters;
    }

    @Nullable
    public final Float minScore() {
        return this.minScore;
    }

    @Nullable
    public final KnnQueryRescore rescore() {
        return this.rescore;
    }

    @Nonnull
    public final List<Float> vector() {
        return this.vector;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.expandNestedDocs != null) {
            generator.writeKey("expand_nested_docs");
            generator.write(this.expandNestedDocs.booleanValue());
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.k != null) {
            generator.writeKey("k");
            generator.write(this.k.intValue());
        }
        if (this.maxDistance != null) {
            generator.writeKey("max_distance");
            generator.write((double)this.maxDistance.floatValue());
        }
        if (ApiTypeHelper.isDefined(this.methodParameters)) {
            generator.writeKey("method_parameters");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.methodParameters.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write((double)this.minScore.floatValue());
        }
        if (this.rescore != null) {
            generator.writeKey("rescore");
            this.rescore.serialize(generator, mapper);
        }
        generator.writeKey("vector");
        generator.writeStartArray();
        for (Float f : this.vector) {
            generator.write((double)f.floatValue());
        }
        generator.writeEnd();
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupKnnQueryDeserializer(ObjectDeserializer<Builder> op) {
        KnnQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::expandNestedDocs, JsonpDeserializer.booleanDeserializer(), "expand_nested_docs");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::k, JsonpDeserializer.integerDeserializer(), "k");
        op.add(Builder::maxDistance, JsonpDeserializer.floatDeserializer(), "max_distance");
        op.add(Builder::methodParameters, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "method_parameters");
        op.add(Builder::minScore, JsonpDeserializer.floatDeserializer(), "min_score");
        op.add(Builder::rescore, KnnQueryRescore._DESERIALIZER, "rescore");
        op.add(Builder::vector, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.floatDeserializer()), "vector");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.expandNestedDocs);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.filter);
        result = 31 * result + Objects.hashCode(this.k);
        result = 31 * result + Objects.hashCode(this.maxDistance);
        result = 31 * result + Objects.hashCode(this.methodParameters);
        result = 31 * result + Objects.hashCode(this.minScore);
        result = 31 * result + Objects.hashCode(this.rescore);
        result = 31 * result + this.vector.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnnQuery other = (KnnQuery)o;
        return Objects.equals(this.expandNestedDocs, other.expandNestedDocs) && this.field.equals(other.field) && Objects.equals(this.filter, other.filter) && Objects.equals(this.k, other.k) && Objects.equals(this.maxDistance, other.maxDistance) && Objects.equals(this.methodParameters, other.methodParameters) && Objects.equals(this.minScore, other.minScore) && Objects.equals(this.rescore, other.rescore) && this.vector.equals(other.vector);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, KnnQuery> {
        @Nullable
        private Boolean expandNestedDocs;
        private String field;
        @Nullable
        private Query filter;
        @Nullable
        private Integer k;
        @Nullable
        private Float maxDistance;
        @Nullable
        private Map<String, JsonData> methodParameters;
        @Nullable
        private Float minScore;
        @Nullable
        private KnnQueryRescore rescore;
        private List<Float> vector;

        public Builder() {
        }

        private Builder(KnnQuery o) {
            super(o);
            this.expandNestedDocs = o.expandNestedDocs;
            this.field = o.field;
            this.filter = o.filter;
            this.k = o.k;
            this.maxDistance = o.maxDistance;
            this.methodParameters = Builder._mapCopy(o.methodParameters);
            this.minScore = o.minScore;
            this.rescore = o.rescore;
            this.vector = Builder._listCopy(o.vector);
        }

        private Builder(Builder o) {
            super(o);
            this.expandNestedDocs = o.expandNestedDocs;
            this.field = o.field;
            this.filter = o.filter;
            this.k = o.k;
            this.maxDistance = o.maxDistance;
            this.methodParameters = Builder._mapCopy(o.methodParameters);
            this.minScore = o.minScore;
            this.rescore = o.rescore;
            this.vector = Builder._listCopy(o.vector);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder expandNestedDocs(@Nullable Boolean value) {
            this.expandNestedDocs = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        @Nonnull
        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder k(@Nullable Integer value) {
            this.k = value;
            return this;
        }

        @Nonnull
        public final Builder maxDistance(@Nullable Float value) {
            this.maxDistance = value;
            return this;
        }

        @Nonnull
        public final Builder methodParameters(Map<String, JsonData> map) {
            this.methodParameters = Builder._mapPutAll(this.methodParameters, map);
            return this;
        }

        @Nonnull
        public final Builder methodParameters(String key, JsonData value) {
            this.methodParameters = Builder._mapPut(this.methodParameters, key, value);
            return this;
        }

        @Nonnull
        public final Builder minScore(@Nullable Float value) {
            this.minScore = value;
            return this;
        }

        @Nonnull
        public final Builder rescore(@Nullable KnnQueryRescore value) {
            this.rescore = value;
            return this;
        }

        @Nonnull
        public final Builder rescore(Function<KnnQueryRescore.Builder, ObjectBuilder<KnnQueryRescore>> fn) {
            return this.rescore(fn.apply(new KnnQueryRescore.Builder()).build());
        }

        @Nonnull
        public final Builder vector(List<Float> list) {
            this.vector = Builder._listAddAll(this.vector, list);
            return this;
        }

        @Nonnull
        public final Builder vector(Float value, Float ... values) {
            this.vector = Builder._listAdd(this.vector, value, values);
            return this;
        }

        @Override
        @Nonnull
        public KnnQuery build() {
            this._checkSingleUse();
            return new KnnQuery(this);
        }
    }
}

