/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ScriptField
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ScriptField> {
    @Nullable
    private final Boolean ignoreFailure;
    @Nonnull
    private final Script script;
    public static final JsonpDeserializer<ScriptField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptField::setupScriptFieldDeserializer);

    private ScriptField(Builder builder) {
        this.ignoreFailure = builder.ignoreFailure;
        this.script = ApiTypeHelper.requireNonNull(builder.script, this, "script");
    }

    public static ScriptField of(Function<Builder, ObjectBuilder<ScriptField>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    @Nonnull
    public final Script script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure.booleanValue());
        }
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupScriptFieldDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure");
        op.add(Builder::script, Script._DESERIALIZER, "script");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.ignoreFailure);
        result = 31 * result + this.script.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptField other = (ScriptField)o;
        return Objects.equals(this.ignoreFailure, other.ignoreFailure) && this.script.equals(other.script);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ScriptField> {
        @Nullable
        private Boolean ignoreFailure;
        private Script script;

        public Builder() {
        }

        private Builder(ScriptField o) {
            this.ignoreFailure = o.ignoreFailure;
            this.script = o.script;
        }

        private Builder(Builder o) {
            this.ignoreFailure = o.ignoreFailure;
            this.script = o.script;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return this;
        }

        @Nonnull
        public final Builder script(Script value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        @Nonnull
        public ScriptField build() {
            this._checkSingleUse();
            return new ScriptField(this);
        }
    }
}

