/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN80Codec;

import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.search.DocIdSetIterator;
import org.opensearch.common.StopWatch;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.KNN80Codec.KNN80DocValuesReader;
import org.opensearch.knn.index.codec.nativeindex.NativeIndexWriter;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesFactory;
import org.opensearch.knn.plugin.stats.KNNGraphValue;

class KNN80DocValuesConsumer
extends DocValuesConsumer {
    @Generated
    private static final Logger log = LogManager.getLogger(KNN80DocValuesConsumer.class);
    private final Logger logger = LogManager.getLogger(KNN80DocValuesConsumer.class);
    private final DocValuesConsumer delegatee;
    private final SegmentWriteState state;

    KNN80DocValuesConsumer(DocValuesConsumer delegatee, SegmentWriteState state) {
        this.delegatee = delegatee;
        this.state = state;
    }

    public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addBinaryField(field, valuesProducer);
        if (this.isKNNBinaryFieldRequired(field)) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            this.addKNNBinaryField(field, valuesProducer, false);
            stopWatch.stop();
            long time_in_millis = stopWatch.totalTime().millis();
            KNNGraphValue.REFRESH_TOTAL_TIME_IN_MILLIS.set(KNNGraphValue.REFRESH_TOTAL_TIME_IN_MILLIS.getValue() + time_in_millis);
            this.logger.warn("Refresh operation complete in " + time_in_millis + " ms");
        }
    }

    private boolean isKNNBinaryFieldRequired(FieldInfo field) {
        KNNEngine knnEngine = FieldInfoExtractor.extractKNNEngine(field);
        log.debug(String.format("Read engine [%s] for field [%s]", knnEngine.getName(), field.getName()));
        return field.attributes().containsKey("knn_field") && KNNEngine.getEnginesThatCreateCustomSegmentFiles().stream().anyMatch(engine -> engine == knnEngine);
    }

    public void addKNNBinaryField(FieldInfo field, DocValuesProducer valuesProducer, boolean isMerge) throws IOException {
        VectorDataType vectorDataType = FieldInfoExtractor.extractVectorDataType(field);
        KNNVectorValues knnVectorValues = KNNVectorValuesFactory.getVectorValues(vectorDataType, (DocIdSetIterator)valuesProducer.getBinary(field));
        if (isMerge) {
            NativeIndexWriter.getWriter(field, this.state).mergeIndex(() -> knnVectorValues, (int)knnVectorValues.totalLiveDocs());
        } else {
            NativeIndexWriter.getWriter(field, this.state).flushIndex(() -> knnVectorValues, (int)knnVectorValues.totalLiveDocs());
        }
    }

    public void merge(MergeState mergeState) {
        try {
            this.delegatee.merge(mergeState);
            assert (mergeState != null);
            assert (mergeState.mergeFieldInfos != null);
            for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
                DocValuesType type = fieldInfo.getDocValuesType();
                if (type != DocValuesType.BINARY || !fieldInfo.attributes().containsKey("knn_field")) continue;
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                this.addKNNBinaryField(fieldInfo, (DocValuesProducer)new KNN80DocValuesReader(mergeState), true);
                stopWatch.stop();
                long time_in_millis = stopWatch.totalTime().millis();
                KNNGraphValue.MERGE_TOTAL_TIME_IN_MILLIS.set(KNNGraphValue.MERGE_TOTAL_TIME_IN_MILLIS.getValue() + time_in_millis);
                this.logger.warn("Merge operation complete in " + time_in_millis + " ms");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSortedSetField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addSortedSetField(field, valuesProducer);
    }

    public void addSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addSortedNumericField(field, valuesProducer);
    }

    public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addSortedField(field, valuesProducer);
    }

    public void addNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegatee.addNumericField(field, valuesProducer);
    }

    public void close() throws IOException {
        this.delegatee.close();
    }
}

