/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.ngram;

import com.optimaize.langdetect.ngram.NgramFilter;

public class BackwardsCompatibleNgramFilter
implements NgramFilter {
    private static final BackwardsCompatibleNgramFilter INSTANCE = new BackwardsCompatibleNgramFilter();

    public static NgramFilter getInstance() {
        return INSTANCE;
    }

    private BackwardsCompatibleNgramFilter() {
    }

    @Override
    public boolean use(String ngram) {
        switch (ngram.length()) {
            case 1: {
                return ngram.charAt(0) != ' ';
            }
            case 2: {
                return !Character.isUpperCase(ngram.charAt(0)) || !Character.isUpperCase(ngram.charAt(1));
            }
            case 3: {
                if (Character.isUpperCase(ngram.charAt(0)) && Character.isUpperCase(ngram.charAt(1)) && Character.isUpperCase(ngram.charAt(2))) {
                    return false;
                }
                return ngram.charAt(1) != ' ';
            }
        }
        throw new UnsupportedOperationException("Unsupported n-gram length: " + ngram.length());
    }
}

