/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.util;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsModule;
import org.opensearch.common.util.BigArrays;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.index.Index;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.similarity.SimilarityService;
import org.opensearch.indices.IndicesModule;
import org.opensearch.indices.analysis.AnalysisModule;
import org.opensearch.indices.mapper.MapperRegistry;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.PluginsService;
import org.opensearch.script.ScriptService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010(\u001a\u00020)2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#J*\u0010*\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010,\u0012\u0006\u0012\u0004\u0018\u00010-\u0012\u0006\u0012\u0004\u0018\u00010.0+2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u0010\u00101\u001a\u0002022\b\u0010/\u001a\u0004\u0018\u000100J(\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u00010,2\b\u00106\u001a\u0004\u0018\u00010-2\b\u00107\u001a\u0004\u0018\u000108H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00069"}, d2={"Lorg/opensearch/indexmanagement/rollup/util/QueryShardContextFactory;", "", "<init>", "()V", "client", "Lorg/opensearch/transport/client/Client;", "getClient", "()Lorg/opensearch/transport/client/Client;", "setClient", "(Lorg/opensearch/transport/client/Client;)V", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "setClusterService", "(Lorg/opensearch/cluster/service/ClusterService;)V", "scriptService", "Lorg/opensearch/script/ScriptService;", "getScriptService", "()Lorg/opensearch/script/ScriptService;", "setScriptService", "(Lorg/opensearch/script/ScriptService;)V", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "setXContentRegistry", "(Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "getNamedWriteableRegistry", "()Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "setNamedWriteableRegistry", "(Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;)V", "environment", "Lorg/opensearch/env/Environment;", "getEnvironment", "()Lorg/opensearch/env/Environment;", "setEnvironment", "(Lorg/opensearch/env/Environment;)V", "init", "", "getIndexSettingsAndMetadata", "Lkotlin/Triple;", "Lorg/opensearch/core/index/Index;", "Lorg/opensearch/common/settings/Settings;", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "indexName", "", "createShardContext", "Lorg/opensearch/index/query/QueryShardContext;", "newIndexSettings", "Lorg/opensearch/index/IndexSettings;", "index", "settings", "indexScopedSettings", "Lorg/opensearch/common/settings/IndexScopedSettings;", "opensearch-index-management"})
public final class QueryShardContextFactory {
    @NotNull
    public static final QueryShardContextFactory INSTANCE = new QueryShardContextFactory();
    public static Client client;
    public static ClusterService clusterService;
    public static ScriptService scriptService;
    public static NamedXContentRegistry xContentRegistry;
    public static NamedWriteableRegistry namedWriteableRegistry;
    public static Environment environment;

    private QueryShardContextFactory() {
    }

    @NotNull
    public final Client getClient() {
        Client client = QueryShardContextFactory.client;
        if (client != null) {
            return client;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        return null;
    }

    public final void setClient(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"<set-?>");
        QueryShardContextFactory.client = client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        ClusterService clusterService = QueryShardContextFactory.clusterService;
        if (clusterService != null) {
            return clusterService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
        return null;
    }

    public final void setClusterService(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"<set-?>");
        QueryShardContextFactory.clusterService = clusterService;
    }

    @NotNull
    public final ScriptService getScriptService() {
        ScriptService scriptService = QueryShardContextFactory.scriptService;
        if (scriptService != null) {
            return scriptService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scriptService");
        return null;
    }

    public final void setScriptService(@NotNull ScriptService scriptService) {
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"<set-?>");
        QueryShardContextFactory.scriptService = scriptService;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        NamedXContentRegistry namedXContentRegistry = xContentRegistry;
        if (namedXContentRegistry != null) {
            return namedXContentRegistry;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"xContentRegistry");
        return null;
    }

    public final void setXContentRegistry(@NotNull NamedXContentRegistry namedXContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)namedXContentRegistry, (String)"<set-?>");
        xContentRegistry = namedXContentRegistry;
    }

    @NotNull
    public final NamedWriteableRegistry getNamedWriteableRegistry() {
        NamedWriteableRegistry namedWriteableRegistry = QueryShardContextFactory.namedWriteableRegistry;
        if (namedWriteableRegistry != null) {
            return namedWriteableRegistry;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"namedWriteableRegistry");
        return null;
    }

    public final void setNamedWriteableRegistry(@NotNull NamedWriteableRegistry namedWriteableRegistry) {
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"<set-?>");
        QueryShardContextFactory.namedWriteableRegistry = namedWriteableRegistry;
    }

    @NotNull
    public final Environment getEnvironment() {
        Environment environment = QueryShardContextFactory.environment;
        if (environment != null) {
            return environment;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
        return null;
    }

    public final void setEnvironment(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"<set-?>");
        QueryShardContextFactory.environment = environment;
    }

    public final void init(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull ScriptService scriptService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull NamedWriteableRegistry namedWriteableRegistry, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.setClient(client);
        this.setClusterService(clusterService);
        this.setScriptService(scriptService);
        this.setXContentRegistry(xContentRegistry);
        this.setNamedWriteableRegistry(namedWriteableRegistry);
        this.setEnvironment(environment);
    }

    private final Triple<Index, Settings, IndexMetadata> getIndexSettingsAndMetadata(String indexName) {
        Index index2 = null;
        Settings indexSettings = null;
        IndexMetadata indexMetadata = this.getClusterService().state().getMetadata().index(indexName);
        if (indexMetadata == null) {
            throw new IllegalArgumentException("Can't find IndexMetadata for index: [" + indexName + "]");
        }
        IndexMetadata indexMetadata2 = indexMetadata;
        index2 = indexMetadata2.getIndex();
        indexSettings = indexMetadata2.getSettings();
        return new Triple((Object)index2, (Object)indexSettings, (Object)indexMetadata2);
    }

    @NotNull
    public final QueryShardContext createShardContext(@Nullable String indexName) {
        Triple<Index, Settings, IndexMetadata> triple = this.getIndexSettingsAndMetadata(indexName);
        Index index2 = (Index)triple.component1();
        Settings indexSettings = (Settings)triple.component2();
        IndexMetadata indexMetadata = (IndexMetadata)triple.component3();
        Settings nodeSettings = Settings.builder().put("node.name", "dummyNodeName").put(Environment.PATH_HOME_SETTING.getKey(), this.getEnvironment().tmpDir()).build();
        PluginsService pluginsService = new PluginsService(nodeSettings, null, null, null, (Collection)CollectionsKt.emptyList());
        List additionalSettings = pluginsService.getPluginSettings();
        SettingsModule settingsModule = new SettingsModule(nodeSettings, additionalSettings, pluginsService.getPluginSettingsFilter(), SetsKt.emptySet());
        IndexScopedSettings indexScopedSettings = settingsModule.getIndexScopedSettings();
        Intrinsics.checkNotNullExpressionValue((Object)indexScopedSettings, (String)"getIndexScopedSettings(...)");
        IndexScopedSettings indexScopedSettings2 = indexScopedSettings;
        IndexSettings idxSettings = this.newIndexSettings(index2, indexSettings, indexScopedSettings2);
        IndicesModule indicesModule = new IndicesModule(pluginsService.filterPlugins(MapperPlugin.class));
        MapperRegistry mapperRegistry = indicesModule.getMapperRegistry();
        AnalysisModule analysisModule = new AnalysisModule(this.getEnvironment(), CollectionsKt.emptyList());
        IndexAnalyzers indexAnalyzers = analysisModule.getAnalysisRegistry().build(idxSettings);
        SimilarityService similarityService = new SimilarityService(idxSettings, null, MapsKt.emptyMap());
        MapperService mapperService = new MapperService(idxSettings, indexAnalyzers, this.getXContentRegistry(), similarityService, mapperRegistry, QueryShardContextFactory::createShardContext$lambda$0, QueryShardContextFactory::createShardContext$lambda$1, this.getScriptService());
        IndexMetadata indexMetadata2 = indexMetadata;
        mapperService.merge("_doc", indexMetadata2 != null && (indexMetadata2 = indexMetadata2.mapping()) != null ? indexMetadata2.source() : null, MapperService.MergeReason.MAPPING_UPDATE);
        return new QueryShardContext(0, idxSettings, BigArrays.NON_RECYCLING_INSTANCE, null, null, mapperService, null, this.getScriptService(), this.getXContentRegistry(), this.getNamedWriteableRegistry(), null, null, QueryShardContextFactory::createShardContext$lambda$2, null, arg_0 -> QueryShardContextFactory.createShardContext$lambda$3(index2, arg_0), QueryShardContextFactory::createShardContext$lambda$4, null);
    }

    private final IndexSettings newIndexSettings(Index index2, Settings settings, IndexScopedSettings indexScopedSettings) {
        Settings build = Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 1).put("index.number_of_shards", 1).put(settings).build();
        Index index3 = index2;
        IndexMetadata metadata2 = IndexMetadata.builder((String)(index3 != null ? index3.getName() : null)).settings(build).build();
        return new IndexSettings(metadata2, Settings.EMPTY, indexScopedSettings);
    }

    private static final QueryShardContext createShardContext$lambda$0() {
        return INSTANCE.createShardContext(null);
    }

    private static final boolean createShardContext$lambda$1() {
        return false;
    }

    private static final long createShardContext$lambda$2() {
        return Instant.now().toEpochMilli();
    }

    private static final boolean createShardContext$lambda$3(Index $index, String pattern) {
        Index index2 = $index;
        return Regex.simpleMatch((String)pattern, (String)(index2 != null ? index2.getName() : null));
    }

    private static final boolean createShardContext$lambda$4() {
        return true;
    }
}

