/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5.packets;

import java.util.List;
import software.amazon.awssdk.crt.mqtt5.packets.PublishPacket;
import software.amazon.awssdk.crt.mqtt5.packets.UserProperty;

public class ConnectPacket {
    private Long keepAliveIntervalSeconds;
    private String clientId;
    private String username;
    private byte[] password;
    private Long sessionExpiryIntervalSeconds;
    private Boolean requestResponseInformation;
    private Boolean requestProblemInformation;
    private Long receiveMaximum;
    private Long maximumPacketSizeBytes;
    private Long willDelayIntervalSeconds;
    private PublishPacket will;
    private List<UserProperty> userProperties;

    private ConnectPacket(ConnectPacketBuilder builder) {
        this.keepAliveIntervalSeconds = builder.keepAliveIntervalSeconds;
        this.clientId = builder.clientId;
        this.username = builder.username;
        this.password = builder.password;
        this.sessionExpiryIntervalSeconds = builder.sessionExpiryIntervalSeconds;
        this.requestResponseInformation = builder.requestResponseInformation;
        this.requestProblemInformation = builder.requestProblemInformation;
        this.receiveMaximum = builder.receiveMaximum;
        this.maximumPacketSizeBytes = builder.maximumPacketSizeBytes;
        this.willDelayIntervalSeconds = builder.willDelayIntervalSeconds;
        this.will = builder.will;
        this.userProperties = builder.userProperties;
    }

    public Long getKeepAliveIntervalSeconds() {
        return this.keepAliveIntervalSeconds;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public Long getSessionExpiryIntervalSeconds() {
        return this.sessionExpiryIntervalSeconds;
    }

    public Boolean getRequestResponseInformation() {
        return this.requestResponseInformation;
    }

    public Boolean getRequestProblemInformation() {
        return this.requestProblemInformation;
    }

    public Long getReceiveMaximum() {
        return this.receiveMaximum;
    }

    public Long getMaximumPacketSizeBytes() {
        return this.maximumPacketSizeBytes;
    }

    public Long getWillDelayIntervalSeconds() {
        return this.willDelayIntervalSeconds;
    }

    public PublishPacket getWill() {
        return this.will;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public static final class ConnectPacketBuilder {
        private Long keepAliveIntervalSeconds = 1200L;
        private String clientId;
        private String username;
        private byte[] password;
        private Long sessionExpiryIntervalSeconds;
        private Boolean requestResponseInformation;
        private Boolean requestProblemInformation;
        private Long receiveMaximum;
        private Long maximumPacketSizeBytes;
        private Long willDelayIntervalSeconds;
        private PublishPacket will = null;
        private List<UserProperty> userProperties;

        public ConnectPacketBuilder withKeepAliveIntervalSeconds(Long keepAliveInteralSeconds) {
            this.keepAliveIntervalSeconds = keepAliveInteralSeconds;
            return this;
        }

        public ConnectPacketBuilder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public ConnectPacketBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public ConnectPacketBuilder withPassword(byte[] password) {
            this.password = password;
            return this;
        }

        public ConnectPacketBuilder withSessionExpiryIntervalSeconds(Long sessionExpiryIntervalSeconds) {
            this.sessionExpiryIntervalSeconds = sessionExpiryIntervalSeconds;
            return this;
        }

        public ConnectPacketBuilder withRequestResponseInformation(Boolean requestResponseInformation) {
            this.requestResponseInformation = requestResponseInformation;
            return this;
        }

        public ConnectPacketBuilder withRequestProblemInformation(Boolean requestProblemInformation) {
            this.requestProblemInformation = requestProblemInformation;
            return this;
        }

        public ConnectPacketBuilder withReceiveMaximum(Long receiveMaximum) {
            this.receiveMaximum = receiveMaximum;
            return this;
        }

        public ConnectPacketBuilder withMaximumPacketSizeBytes(Long maximumPacketSizeBytes) {
            this.maximumPacketSizeBytes = maximumPacketSizeBytes;
            return this;
        }

        public ConnectPacketBuilder withWillDelayIntervalSeconds(Long willDelayIntervalSeconds) {
            this.willDelayIntervalSeconds = willDelayIntervalSeconds;
            return this;
        }

        public ConnectPacketBuilder withWill(PublishPacket will) {
            this.will = will;
            return this;
        }

        public ConnectPacketBuilder withUserProperties(List<UserProperty> userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        public ConnectPacket build() {
            return new ConnectPacket(this);
        }
    }
}

