/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum QOS {
    AT_MOST_ONCE(0),
    AT_LEAST_ONCE(1),
    EXACTLY_ONCE(2);

    private int qos;
    private static Map<Integer, QOS> enumMapping;

    private QOS(int value) {
        this.qos = value;
    }

    public int getValue() {
        return this.qos;
    }

    public static QOS getEnumValueFromInteger(int value) {
        QOS enumValue = enumMapping.get(value);
        if (enumValue != null) {
            return enumValue;
        }
        throw new RuntimeException("Illegal QOS");
    }

    private static Map<Integer, QOS> buildEnumMapping() {
        return Stream.of(QOS.values()).collect(Collectors.toMap(QOS::getValue, Function.identity()));
    }

    static {
        enumMapping = QOS.buildEnumMapping();
    }
}

