/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyLocalGatewayRouteRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyLocalGatewayRouteRequest> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(ModifyLocalGatewayRouteRequest.getter(ModifyLocalGatewayRouteRequest::destinationCidrBlock)).setter(ModifyLocalGatewayRouteRequest.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("DestinationCidrBlock").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayRouteTableId").getter(ModifyLocalGatewayRouteRequest.getter(ModifyLocalGatewayRouteRequest::localGatewayRouteTableId)).setter(ModifyLocalGatewayRouteRequest.setter(Builder::localGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId").unmarshallLocationName("LocalGatewayRouteTableId").build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalGatewayVirtualInterfaceGroupId").getter(ModifyLocalGatewayRouteRequest.getter(ModifyLocalGatewayRouteRequest::localGatewayVirtualInterfaceGroupId)).setter(ModifyLocalGatewayRouteRequest.setter(Builder::localGatewayVirtualInterfaceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceGroupId").unmarshallLocationName("LocalGatewayVirtualInterfaceGroupId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(ModifyLocalGatewayRouteRequest.getter(ModifyLocalGatewayRouteRequest::networkInterfaceId)).setter(ModifyLocalGatewayRouteRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyLocalGatewayRouteRequest.getter(ModifyLocalGatewayRouteRequest::dryRun)).setter(ModifyLocalGatewayRouteRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> DESTINATION_PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPrefixListId").getter(ModifyLocalGatewayRouteRequest.getter(ModifyLocalGatewayRouteRequest::destinationPrefixListId)).setter(ModifyLocalGatewayRouteRequest.setter(Builder::destinationPrefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixListId").unmarshallLocationName("DestinationPrefixListId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD, LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, DRY_RUN_FIELD, DESTINATION_PREFIX_LIST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyLocalGatewayRouteRequest.memberNameToFieldInitializer();
    private final String destinationCidrBlock;
    private final String localGatewayRouteTableId;
    private final String localGatewayVirtualInterfaceGroupId;
    private final String networkInterfaceId;
    private final Boolean dryRun;
    private final String destinationPrefixListId;

    private ModifyLocalGatewayRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
        this.localGatewayVirtualInterfaceGroupId = builder.localGatewayVirtualInterfaceGroupId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.dryRun = builder.dryRun;
        this.destinationPrefixListId = builder.destinationPrefixListId;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String localGatewayRouteTableId() {
        return this.localGatewayRouteTableId;
    }

    public final String localGatewayVirtualInterfaceGroupId() {
        return this.localGatewayVirtualInterfaceGroupId;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String destinationPrefixListId() {
        return this.destinationPrefixListId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayVirtualInterfaceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPrefixListId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyLocalGatewayRouteRequest)) {
            return false;
        }
        ModifyLocalGatewayRouteRequest other = (ModifyLocalGatewayRouteRequest)((Object)obj);
        return Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.localGatewayRouteTableId(), other.localGatewayRouteTableId()) && Objects.equals(this.localGatewayVirtualInterfaceGroupId(), other.localGatewayVirtualInterfaceGroupId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.destinationPrefixListId(), other.destinationPrefixListId());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyLocalGatewayRouteRequest").add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("LocalGatewayRouteTableId", (Object)this.localGatewayRouteTableId()).add("LocalGatewayVirtualInterfaceGroupId", (Object)this.localGatewayVirtualInterfaceGroupId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("DryRun", (Object)this.dryRun()).add("DestinationPrefixListId", (Object)this.destinationPrefixListId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "LocalGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayRouteTableId()));
            }
            case "LocalGatewayVirtualInterfaceGroupId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaceGroupId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "DestinationPrefixListId": {
                return Optional.ofNullable(clazz.cast(this.destinationPrefixListId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        map.put("LocalGatewayRouteTableId", LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD);
        map.put("LocalGatewayVirtualInterfaceGroupId", LOCAL_GATEWAY_VIRTUAL_INTERFACE_GROUP_ID_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("DestinationPrefixListId", DESTINATION_PREFIX_LIST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyLocalGatewayRouteRequest, T> g) {
        return obj -> g.apply((ModifyLocalGatewayRouteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String localGatewayRouteTableId;
        private String localGatewayVirtualInterfaceGroupId;
        private String networkInterfaceId;
        private Boolean dryRun;
        private String destinationPrefixListId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyLocalGatewayRouteRequest model) {
            super(model);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.localGatewayRouteTableId(model.localGatewayRouteTableId);
            this.localGatewayVirtualInterfaceGroupId(model.localGatewayVirtualInterfaceGroupId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.dryRun(model.dryRun);
            this.destinationPrefixListId(model.destinationPrefixListId);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getLocalGatewayRouteTableId() {
            return this.localGatewayRouteTableId;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        @Override
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final String getLocalGatewayVirtualInterfaceGroupId() {
            return this.localGatewayVirtualInterfaceGroupId;
        }

        public final void setLocalGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceGroupId(String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getDestinationPrefixListId() {
            return this.destinationPrefixListId;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyLocalGatewayRouteRequest build() {
            return new ModifyLocalGatewayRouteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyLocalGatewayRouteRequest> {
        public Builder destinationCidrBlock(String var1);

        public Builder localGatewayRouteTableId(String var1);

        public Builder localGatewayVirtualInterfaceGroupId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder dryRun(Boolean var1);

        public Builder destinationPrefixListId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

