/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceBandwidthWeighting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceNetworkPerformanceOptionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyInstanceNetworkPerformanceOptionsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ModifyInstanceNetworkPerformanceOptionsRequest.getter(ModifyInstanceNetworkPerformanceOptionsRequest::instanceId)).setter(ModifyInstanceNetworkPerformanceOptionsRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("InstanceId").build()}).build();
    private static final SdkField<String> BANDWIDTH_WEIGHTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BandwidthWeighting").getter(ModifyInstanceNetworkPerformanceOptionsRequest.getter(ModifyInstanceNetworkPerformanceOptionsRequest::bandwidthWeightingAsString)).setter(ModifyInstanceNetworkPerformanceOptionsRequest.setter(Builder::bandwidthWeighting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandwidthWeighting").unmarshallLocationName("BandwidthWeighting").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyInstanceNetworkPerformanceOptionsRequest.getter(ModifyInstanceNetworkPerformanceOptionsRequest::dryRun)).setter(ModifyInstanceNetworkPerformanceOptionsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, BANDWIDTH_WEIGHTING_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyInstanceNetworkPerformanceOptionsRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String bandwidthWeighting;
    private final Boolean dryRun;

    private ModifyInstanceNetworkPerformanceOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.bandwidthWeighting = builder.bandwidthWeighting;
        this.dryRun = builder.dryRun;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final InstanceBandwidthWeighting bandwidthWeighting() {
        return InstanceBandwidthWeighting.fromValue(this.bandwidthWeighting);
    }

    public final String bandwidthWeightingAsString() {
        return this.bandwidthWeighting;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidthWeightingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceNetworkPerformanceOptionsRequest)) {
            return false;
        }
        ModifyInstanceNetworkPerformanceOptionsRequest other = (ModifyInstanceNetworkPerformanceOptionsRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.bandwidthWeightingAsString(), other.bandwidthWeightingAsString()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyInstanceNetworkPerformanceOptionsRequest").add("InstanceId", (Object)this.instanceId()).add("BandwidthWeighting", (Object)this.bandwidthWeightingAsString()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "BandwidthWeighting": {
                return Optional.ofNullable(clazz.cast(this.bandwidthWeightingAsString()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("BandwidthWeighting", BANDWIDTH_WEIGHTING_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceNetworkPerformanceOptionsRequest, T> g) {
        return obj -> g.apply((ModifyInstanceNetworkPerformanceOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String instanceId;
        private String bandwidthWeighting;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceNetworkPerformanceOptionsRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.bandwidthWeighting(model.bandwidthWeighting);
            this.dryRun(model.dryRun);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getBandwidthWeighting() {
            return this.bandwidthWeighting;
        }

        public final void setBandwidthWeighting(String bandwidthWeighting) {
            this.bandwidthWeighting = bandwidthWeighting;
        }

        @Override
        public final Builder bandwidthWeighting(String bandwidthWeighting) {
            this.bandwidthWeighting = bandwidthWeighting;
            return this;
        }

        @Override
        public final Builder bandwidthWeighting(InstanceBandwidthWeighting bandwidthWeighting) {
            this.bandwidthWeighting(bandwidthWeighting == null ? null : bandwidthWeighting.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceNetworkPerformanceOptionsRequest build() {
            return new ModifyInstanceNetworkPerformanceOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceNetworkPerformanceOptionsRequest> {
        public Builder instanceId(String var1);

        public Builder bandwidthWeighting(String var1);

        public Builder bandwidthWeighting(InstanceBandwidthWeighting var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

