/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSubnetCidrReservationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteSubnetCidrReservationRequest> {
    private static final SdkField<String> SUBNET_CIDR_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetCidrReservationId").getter(DeleteSubnetCidrReservationRequest.getter(DeleteSubnetCidrReservationRequest::subnetCidrReservationId)).setter(DeleteSubnetCidrReservationRequest.setter(Builder::subnetCidrReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetCidrReservationId").unmarshallLocationName("SubnetCidrReservationId").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DeleteSubnetCidrReservationRequest.getter(DeleteSubnetCidrReservationRequest::dryRun)).setter(DeleteSubnetCidrReservationRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_CIDR_RESERVATION_ID_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteSubnetCidrReservationRequest.memberNameToFieldInitializer();
    private final String subnetCidrReservationId;
    private final Boolean dryRun;

    private DeleteSubnetCidrReservationRequest(BuilderImpl builder) {
        super(builder);
        this.subnetCidrReservationId = builder.subnetCidrReservationId;
        this.dryRun = builder.dryRun;
    }

    public final String subnetCidrReservationId() {
        return this.subnetCidrReservationId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetCidrReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSubnetCidrReservationRequest)) {
            return false;
        }
        DeleteSubnetCidrReservationRequest other = (DeleteSubnetCidrReservationRequest)((Object)obj);
        return Objects.equals(this.subnetCidrReservationId(), other.subnetCidrReservationId()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSubnetCidrReservationRequest").add("SubnetCidrReservationId", (Object)this.subnetCidrReservationId()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetCidrReservationId": {
                return Optional.ofNullable(clazz.cast(this.subnetCidrReservationId()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubnetCidrReservationId", SUBNET_CIDR_RESERVATION_ID_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSubnetCidrReservationRequest, T> g) {
        return obj -> g.apply((DeleteSubnetCidrReservationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String subnetCidrReservationId;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSubnetCidrReservationRequest model) {
            super(model);
            this.subnetCidrReservationId(model.subnetCidrReservationId);
            this.dryRun(model.dryRun);
        }

        public final String getSubnetCidrReservationId() {
            return this.subnetCidrReservationId;
        }

        public final void setSubnetCidrReservationId(String subnetCidrReservationId) {
            this.subnetCidrReservationId = subnetCidrReservationId;
        }

        @Override
        public final Builder subnetCidrReservationId(String subnetCidrReservationId) {
            this.subnetCidrReservationId = subnetCidrReservationId;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSubnetCidrReservationRequest build() {
            return new DeleteSubnetCidrReservationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSubnetCidrReservationRequest> {
        public Builder subnetCidrReservationId(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

